/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures;

import com.mathworks.toolbox.javabuilder.Disposable;
import com.mathworks.toolbox.javabuilder.MWArray;
import com.mathworks.toolbox.javabuilder.MWClassID;
import com.mathworks.toolbox.javabuilder.MWException;
import com.mathworks.toolbox.javabuilder.MWNumericArray;
import com.mathworks.toolbox.javabuilder.internal.MWFunctionSignature;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import com.mathworks.toolbox.javabuilder.logging.MWLogger;
import com.mathworks.toolbox.javabuilder.services.ServicePeerCreationError;
import com.mathworks.toolbox.javabuilder.services.ServiceResourceMismatchException;
import com.mathworks.toolbox.javabuilder.services.StatefulResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;

public class WebFigure
implements StatefulResource,
Disposable {
    public static final String RESOURCE_TYPE_NAME = WebFigure.class.getName();
    public static final String SERVICE_ROOT_ATTRIBUTE = "mathworks.webfigures.service.root";
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    private static final Logger LOGGER = MWLogger.getLogger(WebFigure.class.getPackage().getName());
    private static final MWFunctionSignature SAVEWEBFIGURE = new MWFunctionSignature(1, false, "savewebfigure", 1, false);
    private byte[] fFigureData;
    private int fWidth;
    private int fHeight;
    private int fAzimuth;
    private int fElevation;
    private int[] fBackgroundColor;
    private UUID fId = UUID.randomUUID();

    private static int normalize(int n, int n2, int n3, int n4) {
        while (n < n2) {
            n += 360;
        }
        while (n > n3) {
            n -= 360;
        }
        n -= n % n4;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeObject(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(object);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)("Error serializing Object (" + object + ") : " + iOException));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public WebFigure(MWArray mWArray, int n, int n2, int n3, int n4, int[] nArray) {
        this.fFigureData = WebFigure.serializeObject(mWArray);
        this.fWidth = n;
        this.fHeight = n2;
        this.fAzimuth = n3;
        this.fElevation = n4;
        this.fBackgroundColor = (int[])nArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebFigure(MWMCR mWMCR, double d) throws MWException, IOException {
        Object[] objectArray = new Object[6];
        try {
            mWMCR.invoke(Arrays.asList(objectArray), Arrays.asList(d), SAVEWEBFIGURE);
            try {
                this.fFigureData = WebFigure.serializeObject(objectArray[0]);
                this.fWidth = ((MWNumericArray)objectArray[1]).getInt();
                this.fHeight = ((MWNumericArray)objectArray[2]).getInt();
                this.fAzimuth = ((MWNumericArray)objectArray[3]).getInt();
                this.fElevation = ((MWNumericArray)objectArray[4]).getInt();
                double[] dArray = (double[])((MWNumericArray)objectArray[5]).getData();
                this.fBackgroundColor = new int[]{(int)(dArray[0] * 255.0), (int)(dArray[1] * 255.0), (int)(dArray[2] * 255.0)};
                this.fElevation = WebFigure.normalize(this.fElevation, -90, 90, 10);
                if (this.fElevation < -90 || this.fElevation > 90) {
                    this.fElevation *= -1;
                    this.fAzimuth += 180;
                }
                this.fAzimuth = WebFigure.normalize(this.fAzimuth, 0, 360, 10);
            }
            finally {
                MWArray.disposeArray(objectArray);
            }
        }
        catch (MWException mWException) {
            LOGGER.throwing("WebFigure", "<init>", mWException);
            throw mWException;
        }
    }

    public WebFigure(Object object, int n, int n2, int n3, int n4, double[] dArray) throws Exception {
        MWNumericArray mWNumericArray = null;
        try {
            mWNumericArray = new MWNumericArray(object, MWClassID.UINT8);
            this.fFigureData = WebFigure.serializeObject(mWNumericArray);
            this.fWidth = n;
            this.fHeight = n2;
            this.fAzimuth = n3;
            this.fElevation = n4;
            double[] dArray2 = dArray;
            this.fBackgroundColor = new int[]{(int)(dArray2[0] * 255.0), (int)(dArray2[1] * 255.0), (int)(dArray2[2] * 255.0)};
            this.fElevation = WebFigure.normalize(this.fElevation, -90, 90, 10);
            if (this.fElevation < -90 || this.fElevation > 90) {
                this.fElevation *= -1;
                this.fAzimuth += 180;
            }
            this.fAzimuth = WebFigure.normalize(this.fAzimuth, 0, 360, 10);
        }
        catch (Exception exception) {
            try {
                LOGGER.throwing("WebFigure", "<init>", exception);
                throw exception;
            }
            catch (Throwable throwable) {
                MWArray.disposeArray(mWNumericArray);
                throw throwable;
            }
        }
        MWArray.disposeArray(mWNumericArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWArray getFigureData() {
        MWArray mWArray;
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.fFigureData));
        try {
            mWArray = (MWArray)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)("Error deserializing MWArray: " + iOException.getMessage()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)("Error deserializing MWArray: " + classNotFoundException.getMessage()));
            }
        }
        objectInputStream.close();
        return mWArray;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public int getAzimuth() {
        return this.fAzimuth;
    }

    public int getElevation() {
        return this.fElevation;
    }

    public int[] getBackgroundColor() {
        return (int[])this.fBackgroundColor.clone();
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE_NAME;
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    public UUID getUUID() {
        return this.fId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WebFigure webFigure = (WebFigure)object;
        return this.fId.equals(webFigure.fId);
    }

    @Override
    @Deprecated
    public void dispose() {
    }

    public static WebFigure newInstance(MWMCR mWMCR, double d) throws MWException, ServiceResourceMismatchException, ServicePeerCreationError, IOException {
        return new WebFigure(mWMCR, d);
    }

    public static WebFigure newInstance(Object object, int n, int n2, int n3, int n4, double[] dArray) throws Exception {
        return new WebFigure(object, n, n2, n3, n4, dArray);
    }
}

