/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.request;

import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerException;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigure;
import com.mathworks.toolbox.javabuilder.webfigures.internal.WebFigureResources;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.NamedWebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Locale;

public class WebFigureInterfaceRequest
extends NamedWebFigureServiceRequest<WebFigureBinaryResourceResult> {
    private static final String INTERFACE_TEMPLATE_RESOURCE_NAME = "/interface.html_tmpl";

    public WebFigureInterfaceRequest(String string, String string2) {
        super(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebFigureBinaryResourceResult process(StateManagerContext stateManagerContext, StatefulServicePeerActionDispatcher statefulServicePeerActionDispatcher) throws ServiceException {
        Object object;
        WebFigure webFigure = (WebFigure)stateManagerContext.getContextScope(this.getScope()).get(this.getName());
        int[] nArray = webFigure.getBackgroundColor();
        String string = String.format(Locale.US, "#%02x%02x%02x", nArray[0], nArray[1], nArray[2]);
        String string2 = String.format(Locale.US, "%d", webFigure.getAzimuth());
        String string3 = String.format(Locale.US, "%d", webFigure.getElevation());
        InputStream inputStream = WebFigureResources.getResourceAsStream(INTERFACE_TEMPLATE_RESOURCE_NAME, stateManagerContext);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));){
                while (null != (object = bufferedReader.readLine())) {
                    object = ((String)object).replace("$(NAME)", this.getName()).replace("$(SCOPE)", this.getScope()).replace("$(BGCOLOR)", string).replace("$(AZIMUTH)", string2).replace("$(ELEVATION)", string3);
                    bufferedWriter.write((String)object + '\n');
                }
            }
            object = new WebFigureBinaryResourceResult(byteArrayOutputStream.toByteArray(), "text/html;charset=UTF-8");
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ServiceException("An IOException was thrown: " + iOException);
            }
            catch (StateManagerException stateManagerException) {
                throw new ServiceException(stateManagerException);
            }
        }
        bufferedReader.close();
        return object;
    }
}

