/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.request;

import com.mathworks.toolbox.javabuilder.io.Streams;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerException;
import com.mathworks.toolbox.javabuilder.web.util.ContentEncoding;
import com.mathworks.toolbox.javabuilder.web.util.ContentType;
import com.mathworks.toolbox.javabuilder.webfigures.internal.WebFigureResources;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.WebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebFigureJavaScriptRequest
implements WebFigureServiceRequest<WebFigureBinaryResourceResult> {
    private String fRequestUrl;
    private String fRequestedResource;
    private boolean fMinifyRequested = true;
    private String fAcceptEncoding = null;

    public WebFigureJavaScriptRequest(String string, String string2, String string3) {
        if (null == string) {
            throw new IllegalArgumentException("requestUrl is null");
        }
        if (null == string2) {
            throw new IllegalArgumentException("requestedResource is null");
        }
        this.fRequestUrl = string;
        this.fRequestedResource = string2;
        this.fAcceptEncoding = string3;
    }

    public String getRequestUrl() {
        return this.fRequestUrl;
    }

    public void setRequestUrl(String string) {
        this.fRequestUrl = string;
    }

    public String getRequestedResource() {
        return this.fRequestedResource;
    }

    public void setRequestedResource(String string) {
        this.fRequestedResource = string;
    }

    public boolean isMinifyRequested() {
        return this.fMinifyRequested;
    }

    public void setMinifyRequested(boolean bl) {
        this.fMinifyRequested = bl;
    }

    public String getAcceptEncoding() {
        return this.fAcceptEncoding;
    }

    public void setAcceptEncoding(String string) {
        this.fAcceptEncoding = string;
    }

    public int hashCode() {
        return this.fRequestedResource.hashCode() ^ this.fRequestUrl.hashCode() ^ (this.fAcceptEncoding == null ? 0 : this.fAcceptEncoding.hashCode()) ^ Boolean.valueOf(this.fMinifyRequested).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WebFigureJavaScriptRequest)) {
            return false;
        }
        WebFigureJavaScriptRequest webFigureJavaScriptRequest = (WebFigureJavaScriptRequest)object;
        return webFigureJavaScriptRequest.getRequestedResource().equals(this.getRequestedResource()) && webFigureJavaScriptRequest.getRequestUrl().equals(this.getRequestUrl()) && (this.getAcceptEncoding() == webFigureJavaScriptRequest.getAcceptEncoding() || this.getAcceptEncoding() != null && webFigureJavaScriptRequest.getAcceptEncoding() != null && this.getAcceptEncoding().equals(webFigureJavaScriptRequest.getAcceptEncoding())) && webFigureJavaScriptRequest.isMinifyRequested() == this.isMinifyRequested();
    }

    public String toString() {
        return this.fRequestedResource + " (" + this.fRequestUrl + "), " + (this.fMinifyRequested ? "minified" : "unminified");
    }

    private BufferedReader openScript(String string, StateManagerContext stateManagerContext) throws IOException, StateManagerException {
        boolean bl;
        string = "/javascript" + string;
        InputStream inputStream = WebFigureResources.getResourceAsStream(string, stateManagerContext);
        String string2 = System.getProperty("mathworks.webfigures.disableJSMin");
        boolean bl2 = bl = string2 != null && Boolean.valueOf(string2) != false;
        if (this.isMinifyRequested() && !bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Class<?> clazz = Class.forName("org.inconspicuous.jsmin.JSMin");
                Constructor<?> constructor = clazz.getConstructor(InputStream.class, OutputStream.class);
                Object obj = constructor.newInstance(inputStream, byteArrayOutputStream);
                Method method = clazz.getMethod("jsmin", new Class[0]);
                method.invoke(obj, new Object[0]);
                return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebFigureBinaryResourceResult process(StateManagerContext stateManagerContext, StatefulServicePeerActionDispatcher statefulServicePeerActionDispatcher) throws ServiceException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = ContentType.fromExtension(this.getRequestedResource()).getName();
        try {
            Object object;
            block14: {
                if ("application/javascript".equals(string)) {
                    int n = this.getRequestUrl().lastIndexOf(this.getRequestedResource());
                    object = new PrintWriter(new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream)));
                    try (BufferedReader bufferedReader = this.openScript(this.getRequestedResource(), stateManagerContext);){
                        String string2;
                        while (null != (string2 = bufferedReader.readLine())) {
                            ((PrintWriter)object).write(string2 + '\n');
                        }
                        break block14;
                    }
                    finally {
                        ((PrintWriter)object).close();
                    }
                }
                try (InputStream inputStream = WebFigureResources.getResourceAsStream("/javascript" + this.getRequestedResource(), stateManagerContext);){
                    Streams.copyAllAvailable(inputStream, byteArrayOutputStream);
                }
            }
            WebFigureBinaryResourceResult webFigureBinaryResourceResult = new WebFigureBinaryResourceResult(byteArrayOutputStream.toByteArray(), string);
            object = ContentEncoding.fromAcceptEncoding(this.getAcceptEncoding());
            webFigureBinaryResourceResult.applyContentEncoding((ContentEncoding)object);
            return webFigureBinaryResourceResult;
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        catch (StateManagerException stateManagerException) {
            throw new ServiceException(stateManagerException);
        }
    }
}

