/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthComboPopup;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    Insets popupInsets;
    private boolean buttonWhenNotEditable;
    private boolean pressedWhenPopupVisible;
    private ButtonHandler buttonHandler;
    private EditorFocusHandler editorFocusHandler;
    private boolean forceOpaque = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.buttonHandler = new ButtonHandler();
        super.installUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox jComboBox) {
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext(jComboBox, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.padding = (Insets)this.style.get(synthContext, "ComboBox.padding");
            this.popupInsets = (Insets)this.style.get(synthContext, "ComboBox.popupInsets");
            this.useListColors = this.style.getBoolean(synthContext, "ComboBox.rendererUseListColors", true);
            this.buttonWhenNotEditable = this.style.getBoolean(synthContext, "ComboBox.buttonWhenNotEditable", false);
            this.pressedWhenPopupVisible = this.style.getBoolean(synthContext, "ComboBox.pressedWhenPopupVisible", false);
            this.squareButton = this.style.getBoolean(synthContext, "ComboBox.squareButton", true);
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
            this.forceOpaque = this.style.getBoolean(synthContext, "ComboBox.forceOpaque", false);
        }
        synthContext.dispose();
        if (this.listBox != null) {
            SynthLookAndFeel.updateStyles(this.listBox);
        }
    }

    @Override
    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        this.comboBox.addMouseListener(this.buttonHandler);
        this.editorFocusHandler = new EditorFocusHandler(this.comboBox);
        super.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.popup instanceof SynthComboPopup) {
            ((SynthComboPopup)this.popup).removePopupMenuListener(this.buttonHandler);
        }
        super.uninstallUI(jComponent);
        this.buttonHandler = null;
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.editorFocusHandler.unregister();
        this.comboBox.removePropertyChangeListener(this);
        this.comboBox.removeMouseListener(this.buttonHandler);
        this.buttonHandler.pressed = false;
        this.buttonHandler.over = false;
        super.uninstallListeners();
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        if (!(jComponent instanceof JComboBox)) {
            return SynthLookAndFeel.getComponentState(jComponent);
        }
        JComboBox jComboBox = (JComboBox)jComponent;
        if (this.shouldActLikeButton()) {
            int n = 1;
            if (!jComponent.isEnabled()) {
                n = 8;
            }
            if (this.buttonHandler.isPressed()) {
                n |= 4;
            }
            if (this.buttonHandler.isRollover()) {
                n |= 2;
            }
            if (jComboBox.isFocusOwner()) {
                n |= 0x100;
            }
            return n;
        }
        int n = SynthLookAndFeel.getComponentState(jComponent);
        if (jComboBox.isEditable() && jComboBox.getEditor().getEditorComponent().isFocusOwner()) {
            n |= 0x100;
        }
        return n;
    }

    @Override
    protected ComboPopup createPopup() {
        SynthComboPopup synthComboPopup = new SynthComboPopup(this.comboBox);
        synthComboPopup.addPopupMenuListener(this.buttonHandler);
        return synthComboPopup;
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.comboBox);
        }
    }

    @Override
    protected JButton createArrowButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.setName("ComboBox.arrowButton");
        synthArrowButton.setModel(this.buttonHandler);
        return synthArrowButton;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintComboBoxBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintComboBoxBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        boolean bl2;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean bl3 = false;
        if (component instanceof JPanel) {
            bl3 = true;
        }
        if (component instanceof UIResource) {
            component.setName("ComboBox.renderer");
        }
        boolean bl4 = bl2 = this.forceOpaque && component instanceof JComponent;
        if (bl2) {
            ((JComponent)component).setOpaque(false);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.padding != null) {
            n = rectangle.x + this.padding.left;
            n2 = rectangle.y + this.padding.top;
            n3 = rectangle.width - (this.padding.left + this.padding.right);
            n4 = rectangle.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, n, n2, n3, n4, bl3);
        if (bl2) {
            ((JComponent)component).setOpaque(true);
        }
    }

    private boolean shouldActLikeButton() {
        return this.buttonWhenNotEditable && !this.comboBox.isEditable();
    }

    @Override
    protected Dimension getDefaultSize() {
        SynthComboBoxRenderer synthComboBoxRenderer = new SynthComboBoxRenderer();
        Dimension dimension = this.getSizeForComponent(synthComboBoxRenderer.getListCellRendererComponent((JList<?>)this.listBox, " ", -1, false, false));
        return new Dimension(dimension.width, dimension.height);
    }

    private static class EditorFocusHandler
    implements FocusListener,
    PropertyChangeListener {
        private JComboBox comboBox;
        private ComboBoxEditor editor = null;
        private Component editorComponent = null;

        private EditorFocusHandler(JComboBox jComboBox) {
            this.comboBox = jComboBox;
            this.editor = jComboBox.getEditor();
            if (this.editor != null) {
                this.editorComponent = this.editor.getEditorComponent();
                if (this.editorComponent != null) {
                    this.editorComponent.addFocusListener(this);
                }
            }
            jComboBox.addPropertyChangeListener("editor", this);
        }

        public void unregister() {
            this.comboBox.removePropertyChangeListener(this);
            if (this.editorComponent != null) {
                this.editorComponent.removeFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.comboBox.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.comboBox.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
            if (this.editor != comboBoxEditor) {
                if (this.editorComponent != null) {
                    this.editorComponent.removeFocusListener(this);
                }
                this.editor = comboBoxEditor;
                if (this.editor != null) {
                    this.editorComponent = this.editor.getEditorComponent();
                    if (this.editorComponent != null) {
                        this.editorComponent.addFocusListener(this);
                    }
                }
            }
        }
    }

    private final class ButtonHandler
    extends DefaultButtonModel
    implements MouseListener,
    PopupMenuListener {
        private boolean over;
        private boolean pressed;

        private ButtonHandler() {
        }

        private void updatePressed(boolean bl) {
            boolean bl2 = this.pressed = bl && this.isEnabled();
            if (SynthComboBoxUI.this.shouldActLikeButton()) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        private void updateOver(boolean bl) {
            boolean bl2 = this.isRollover();
            this.over = bl && this.isEnabled();
            boolean bl3 = this.isRollover();
            if (SynthComboBoxUI.this.shouldActLikeButton() && bl2 != bl3) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public boolean isPressed() {
            boolean bl = SynthComboBoxUI.this.shouldActLikeButton() ? this.pressed : super.isPressed();
            return bl || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
        }

        @Override
        public boolean isArmed() {
            boolean bl = SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
            return bl ? this.isPressed() : super.isArmed();
        }

        @Override
        public boolean isRollover() {
            return SynthComboBoxUI.this.shouldActLikeButton() ? this.over : super.isRollover();
        }

        @Override
        public void setPressed(boolean bl) {
            super.setPressed(bl);
            this.updatePressed(bl);
        }

        @Override
        public void setRollover(boolean bl) {
            super.setRollover(bl);
            this.updateOver(bl);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateOver(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateOver(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updatePressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.updatePressed(false);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    private static class SynthComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        private SynthComboBoxEditor() {
        }

        @Override
        public JTextField createEditorComponent() {
            JTextField jTextField = new JTextField("", 9);
            jTextField.setName("ComboBox.textField");
            return jTextField;
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object>,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setText(" ");
        }

        @Override
        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            SynthLookAndFeel.resetSelectedUI();
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (!SynthComboBoxUI.this.useListColors) {
                    SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl, bl2, jList.isEnabled(), false);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
                this.setText("");
            } else {
                String string;
                String string2 = string = object == null ? " " : object.toString();
                if ("".equals(string)) {
                    string = " ";
                }
                this.setText(string);
            }
            if (SynthComboBoxUI.this.comboBox != null) {
                this.setEnabled(SynthComboBoxUI.this.comboBox.isEnabled());
                this.setComponentOrientation(SynthComboBoxUI.this.comboBox.getComponentOrientation());
            }
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

