/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.security.AccessController;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.windows.WWindowPeer;
import sun.java2d.DestSurfaceProvider;
import sun.java2d.InvalidPipeException;
import sun.java2d.Surface;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.opengl.WGLSurfaceData;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.hw.AccelGraphicsConfig;
import sun.java2d.pipe.hw.AccelSurface;
import sun.security.action.GetPropertyAction;

public abstract class TranslucentWindowPainter {
    protected Window window;
    protected WWindowPeer peer;
    private static final boolean forceOpt = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.java2d.twp.forceopt", "false")));
    private static final boolean forceSW = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.java2d.twp.forcesw", "false")));

    public static TranslucentWindowPainter createInstance(WWindowPeer wWindowPeer) {
        GraphicsConfiguration graphicsConfiguration = wWindowPeer.getGraphicsConfiguration();
        if (!forceSW && graphicsConfiguration instanceof AccelGraphicsConfig) {
            String string = graphicsConfiguration.getClass().getSimpleName();
            AccelGraphicsConfig accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration);
            if ((accelGraphicsConfig.getContextCapabilities().getCaps() & 0x100) != 0 || forceOpt) {
                if (string.startsWith("D3D")) {
                    return new VIOptD3DWindowPainter(wWindowPeer);
                }
                if (forceOpt && string.startsWith("WGL")) {
                    return new VIOptWGLWindowPainter(wWindowPeer);
                }
            }
        }
        return new BIWindowPainter(wWindowPeer);
    }

    protected TranslucentWindowPainter(WWindowPeer wWindowPeer) {
        this.peer = wWindowPeer;
        this.window = (Window)wWindowPeer.getTarget();
    }

    protected abstract Image getBackBuffer(boolean var1);

    protected abstract boolean update(Image var1);

    public abstract void flush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindow(boolean bl) {
        boolean bl2 = false;
        Image image = this.getBackBuffer(bl);
        while (!bl2) {
            if (bl) {
                Graphics2D graphics2D = (Graphics2D)image.getGraphics();
                try {
                    this.window.paintAll(graphics2D);
                }
                finally {
                    graphics2D.dispose();
                }
            }
            if (bl2 = this.update(image)) continue;
            bl = true;
            image = this.getBackBuffer(true);
        }
    }

    private static final Image clearImage(Image image) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n, n2);
        return image;
    }

    private static class VIOptWGLWindowPainter
    extends VIOptWindowPainter {
        protected VIOptWGLWindowPainter(WWindowPeer wWindowPeer) {
            super(wWindowPeer);
        }

        @Override
        protected boolean updateWindowAccel(long l, int n, int n2) {
            return WGLSurfaceData.updateWindowAccelImpl(l, this.peer, n, n2);
        }
    }

    private static class VIOptD3DWindowPainter
    extends VIOptWindowPainter {
        protected VIOptD3DWindowPainter(WWindowPeer wWindowPeer) {
            super(wWindowPeer);
        }

        @Override
        protected boolean updateWindowAccel(long l, int n, int n2) {
            return D3DSurfaceData.updateWindowAccelImpl(l, this.peer.getData(), n, n2);
        }
    }

    private static abstract class VIOptWindowPainter
    extends VIWindowPainter {
        protected VIOptWindowPainter(WWindowPeer wWindowPeer) {
            super(wWindowPeer);
        }

        protected abstract boolean updateWindowAccel(long var1, int var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean update(Image image) {
            Surface surface;
            if (image instanceof DestSurfaceProvider && (surface = ((DestSurfaceProvider)((Object)image)).getDestSurface()) instanceof AccelSurface) {
                final int n = image.getWidth(null);
                final int n2 = image.getHeight(null);
                final boolean[] blArray = new boolean[]{false};
                final AccelSurface accelSurface = (AccelSurface)surface;
                RenderQueue renderQueue = accelSurface.getContext().getRenderQueue();
                renderQueue.lock();
                try {
                    BufferedContext.validateContext(accelSurface);
                    renderQueue.flushAndInvokeNow(new Runnable(){

                        @Override
                        public void run() {
                            long l = accelSurface.getNativeOps();
                            blArray[0] = this.updateWindowAccel(l, n, n2);
                        }
                    });
                }
                catch (InvalidPipeException invalidPipeException) {
                }
                finally {
                    renderQueue.unlock();
                }
                return blArray[0];
            }
            return super.update(image);
        }
    }

    private static class VIWindowPainter
    extends BIWindowPainter {
        private VolatileImage viBB;

        protected VIWindowPainter(WWindowPeer wWindowPeer) {
            super(wWindowPeer);
        }

        @Override
        protected Image getBackBuffer(boolean bl) {
            int n = this.window.getWidth();
            int n2 = this.window.getHeight();
            GraphicsConfiguration graphicsConfiguration = this.peer.getGraphicsConfiguration();
            if (this.viBB == null || this.viBB.getWidth() != n || this.viBB.getHeight() != n2 || this.viBB.validate(graphicsConfiguration) == 2) {
                this.flush();
                if (graphicsConfiguration instanceof AccelGraphicsConfig) {
                    AccelGraphicsConfig accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration);
                    this.viBB = accelGraphicsConfig.createCompatibleVolatileImage(n, n2, 3, 2);
                }
                if (this.viBB == null) {
                    this.viBB = graphicsConfiguration.createCompatibleVolatileImage(n, n2, 3);
                }
                this.viBB.validate(graphicsConfiguration);
            }
            return bl ? TranslucentWindowPainter.clearImage(this.viBB) : this.viBB;
        }

        @Override
        public void flush() {
            if (this.viBB != null) {
                this.viBB.flush();
                this.viBB = null;
            }
        }
    }

    private static class BIWindowPainter
    extends TranslucentWindowPainter {
        private BufferedImage backBuffer;

        protected BIWindowPainter(WWindowPeer wWindowPeer) {
            super(wWindowPeer);
        }

        @Override
        protected Image getBackBuffer(boolean bl) {
            int n = this.window.getWidth();
            int n2 = this.window.getHeight();
            if (this.backBuffer == null || this.backBuffer.getWidth() != n || this.backBuffer.getHeight() != n2) {
                this.flush();
                this.backBuffer = new BufferedImage(n, n2, 3);
            }
            return bl ? (BufferedImage)TranslucentWindowPainter.clearImage(this.backBuffer) : this.backBuffer;
        }

        @Override
        protected boolean update(Image image) {
            Object object;
            VolatileImage volatileImage = null;
            if (image instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)image;
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                this.peer.updateWindowImpl(nArray, bufferedImage.getWidth(), bufferedImage.getHeight());
                return true;
            }
            if (image instanceof VolatileImage) {
                volatileImage = (VolatileImage)image;
                if (image instanceof DestSurfaceProvider && (object = ((DestSurfaceProvider)((Object)image)).getDestSurface()) instanceof BufImgSurfaceData) {
                    int n = volatileImage.getWidth();
                    int n2 = volatileImage.getHeight();
                    BufImgSurfaceData bufImgSurfaceData = (BufImgSurfaceData)object;
                    int[] nArray = ((DataBufferInt)bufImgSurfaceData.getRaster(0, 0, n, n2).getDataBuffer()).getData();
                    this.peer.updateWindowImpl(nArray, n, n2);
                    return true;
                }
            }
            object = (BufferedImage)TranslucentWindowPainter.clearImage(this.backBuffer);
            int[] nArray = ((DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer()).getData();
            this.peer.updateWindowImpl(nArray, ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
            return volatileImage != null ? !volatileImage.contentsLost() : true;
        }

        @Override
        public void flush() {
            if (this.backBuffer != null) {
                this.backBuffer.flush();
                this.backBuffer = null;
            }
        }
    }
}

