/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.ClassSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class ClassRepository
extends GenericDeclRepository<ClassSignature> {
    public static final ClassRepository NONE = ClassRepository.make("Ljava/lang/Object;", null);
    private Type superclass;
    private Type[] superInterfaces;

    private ClassRepository(String string, GenericsFactory genericsFactory) {
        super(string, genericsFactory);
    }

    @Override
    protected ClassSignature parse(String string) {
        return SignatureParser.make().parseClassSig(string);
    }

    public static ClassRepository make(String string, GenericsFactory genericsFactory) {
        return new ClassRepository(string, genericsFactory);
    }

    public Type getSuperclass() {
        if (this.superclass == null) {
            Reifier reifier = this.getReifier();
            ((ClassSignature)this.getTree()).getSuperclass().accept(reifier);
            this.superclass = reifier.getResult();
        }
        return this.superclass;
    }

    public Type[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            ClassTypeSignature[] classTypeSignatureArray = ((ClassSignature)this.getTree()).getSuperInterfaces();
            Type[] typeArray = new Type[classTypeSignatureArray.length];
            for (int i = 0; i < classTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                classTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.superInterfaces = typeArray;
        }
        return (Type[])this.superInterfaces.clone();
    }
}

