/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = debug != null && Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static CRLReason[] values = CRLReason.values();
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private final AlgorithmId sigAlgId;
    private final byte[] signature;
    private final byte[] tbsResponseData;
    private final byte[] responseNonce;
    private List<X509CertImpl> certs;
    private X509CertImpl signerCert = null;
    private X500Principal responderName = null;
    private KeyIdentifier responderKeyId = null;

    private static int initializeClockSkew() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (n == null || n < 0) {
            return 900000;
        }
        return n * 1000;
    }

    OCSPResponse(byte[] byArray) throws IOException {
        Object object;
        DerValue[] derValueArray;
        int n;
        Object object2;
        if (dump) {
            object2 = new HexDumpEncoder();
            debug.println("OCSPResponse bytes...\n\n" + ((CharacterEncoder)object2).encode(byArray) + "\n");
        }
        object2 = new DerValue(byArray);
        if (((DerValue)object2).tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = ((DerValue)object2).getData();
        int n2 = derInputStream.getEnumerated();
        if (n2 < 0 || n2 >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n2);
        }
        this.responseStatus = rsvalues[n2];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.certs = new ArrayList<X509CertImpl>();
            this.sigAlgId = null;
            this.signature = null;
            this.tbsResponseData = null;
            this.responseNonce = null;
            return;
        }
        object2 = derInputStream.getDerValue();
        if (!((DerValue)object2).isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue = ((DerValue)object2).data.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        if (derValueArray2.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue2 = derValueArray2[0];
        this.tbsResponseData = derValueArray2[0].toByteArray();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue2.data;
        DerValue derValue3 = derInputStream3.getDerValue();
        if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed() && derValue3.isContextSpecific()) {
            derValue3 = derValue3.data.getDerValue();
            n = derValue3.getInteger();
            if (derValue3.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue3 = derInputStream3.getDerValue();
        }
        if ((n = (int)((byte)(derValue3.tag & 0x1F))) == 1) {
            this.responderName = new X500Principal(derValue3.getData().toByteArray());
            if (debug != null) {
                debug.println("Responder's name: " + this.responderName);
            }
        } else if (n == 2) {
            this.responderKeyId = new KeyIdentifier(derValue3.getData().getOctetString());
            if (debug != null) {
                debug.println("Responder's key ID: " + Debug.toString(this.responderKeyId.getIdentifier()));
            }
        } else {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        derValue3 = derInputStream3.getDerValue();
        if (debug != null) {
            derValueArray = derValue3.getGeneralizedTime();
            debug.println("OCSP response produced at: " + derValueArray);
        }
        derValueArray = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + derValueArray.length);
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            object = new SingleResponse(derValueArray[i]);
            this.singleResponseMap.put(((SingleResponse)object).getCertId(), (SingleResponse)object);
        }
        byte[] byArray2 = null;
        if (derInputStream3.available() > 0 && (derValue3 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            object = derValue3.data.getSequence(3);
            for (int i = 0; i < ((DerValue[])object).length; ++i) {
                sun.security.x509.Extension extension = new sun.security.x509.Extension(object[i]);
                if (debug != null) {
                    debug.println("OCSP extension: " + extension);
                }
                if (extension.getExtensionId().equals((Object)OCSP.NONCE_EXTENSION_OID)) {
                    byArray2 = extension.getExtensionValue();
                    continue;
                }
                if (!extension.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + extension.getExtensionId());
            }
        }
        this.responseNonce = byArray2;
        this.sigAlgId = AlgorithmId.parse(derValueArray2[1]);
        this.signature = derValueArray2[2].getBitString();
        if (derValueArray2.length > 3) {
            object = derValueArray2[3];
            if (!((DerValue)object).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] derValueArray3 = ((DerValue)object).getData().getSequence(3);
            this.certs = new ArrayList<X509CertImpl>(derValueArray3.length);
            try {
                for (int i = 0; i < derValueArray3.length; ++i) {
                    X509CertImpl x509CertImpl = new X509CertImpl(derValueArray3[i].toByteArray());
                    this.certs.add(x509CertImpl);
                    if (debug == null) continue;
                    debug.println("OCSP response cert #" + (i + 1) + ": " + x509CertImpl.getSubjectX500Principal());
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Bad encoding in X509 Certificate", certificateException);
            }
        } else {
            this.certs = new ArrayList<X509CertImpl>();
        }
    }

    void verify(List<CertId> list, X509Certificate x509Certificate, X509Certificate x509Certificate2, Date date, byte[] byArray) throws CertPathValidatorException {
        Object object;
        switch (this.responseStatus) {
            case SUCCESSFUL: {
                break;
            }
            case TRY_LATER: 
            case INTERNAL_ERROR: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus), null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
            default: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus));
            }
        }
        for (CertId object2 : list) {
            object = this.getSingleResponse(object2);
            if (object == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + object2);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + object2.getSerialNumber() + ") is: " + (Object)((Object)((SingleResponse)object).getCertStatus()));
        }
        if (this.signerCert == null) {
            try {
                this.certs.add(X509CertImpl.toImpl(x509Certificate));
                if (x509Certificate2 != null) {
                    this.certs.add(X509CertImpl.toImpl(x509Certificate2));
                }
            }
            catch (CertificateException certificateException) {
                throw new CertPathValidatorException("Invalid issuer or trusted responder certificate", certificateException);
            }
            if (this.responderName != null) {
                for (X509CertImpl x509CertImpl : this.certs) {
                    if (!x509CertImpl.getSubjectX500Principal().equals(this.responderName)) continue;
                    this.signerCert = x509CertImpl;
                    break;
                }
            } else if (this.responderKeyId != null) {
                for (X509CertImpl x509CertImpl : this.certs) {
                    object = x509CertImpl.getSubjectKeyId();
                    if (object != null && this.responderKeyId.equals(object)) {
                        this.signerCert = x509CertImpl;
                        break;
                    }
                    try {
                        object = new KeyIdentifier(x509CertImpl.getPublicKey());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!this.responderKeyId.equals(object)) continue;
                    this.signerCert = x509CertImpl;
                    break;
                }
            }
        }
        if (this.signerCert != null) {
            if (this.signerCert.equals(x509Certificate)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by the target's Issuing CA");
                }
            } else if (this.signerCert.equals(x509Certificate2)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by a Trusted Responder");
                }
            } else if (this.signerCert.getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) {
                Object object3;
                try {
                    object3 = this.signerCert.getExtendedKeyUsage();
                    if (object3 == null || !object3.contains(KP_OCSP_SIGNING_OID)) {
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException certificateParsingException) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", certificateParsingException);
                }
                object3 = new AlgorithmChecker(new TrustAnchor(x509Certificate, null));
                ((AlgorithmChecker)object3).init(false);
                ((AlgorithmChecker)object3).check(this.signerCert, Collections.emptySet());
                try {
                    if (date == null) {
                        this.signerCert.checkValidity();
                    } else {
                        this.signerCert.checkValidity(date);
                    }
                }
                catch (CertificateException certificateException) {
                    throw new CertPathValidatorException("Responder's certificate not within the validity period", certificateException);
                }
                sun.security.x509.Extension extension = this.signerCert.getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (extension != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    this.signerCert.verify(x509Certificate.getPublicKey());
                    if (debug != null) {
                        debug.println("OCSP response is signed by an Authorized Responder");
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    this.signerCert = null;
                }
            } else {
                throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
            }
        }
        if (this.signerCert != null) {
            AlgorithmChecker.check(this.signerCert.getPublicKey(), this.sigAlgId);
            if (!this.verifySignature(this.signerCert)) {
                throw new CertPathValidatorException("Error verifying OCSP Response's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (byArray != null && this.responseNonce != null && !Arrays.equals(byArray, this.responseNonce)) {
            throw new CertPathValidatorException("Nonces don't match");
        }
        long l = date == null ? System.currentTimeMillis() : date.getTime();
        object = new Date(l + (long)MAX_CLOCK_SKEW);
        Date date2 = new Date(l - (long)MAX_CLOCK_SKEW);
        for (SingleResponse singleResponse : this.singleResponseMap.values()) {
            if (debug != null) {
                String string = "";
                if (singleResponse.nextUpdate != null) {
                    string = " until " + singleResponse.nextUpdate;
                }
                debug.println("Response's validity interval is from " + singleResponse.thisUpdate + string);
            }
            if ((singleResponse.thisUpdate == null || !((Date)object).before(singleResponse.thisUpdate)) && (singleResponse.nextUpdate == null || !date2.after(singleResponse.nextUpdate))) continue;
            throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifySignature(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(this.sigAlgId.getName());
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(this.tbsResponseData);
            if (signature.verify(this.signature)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Response");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Response");
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new CertPathValidatorException(generalSecurityException);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, Extension> singleExtensions;

        private SingleResponse(DerValue derValue) throws IOException {
            int n;
            DerValue[] derValueArray;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    derValueArray = derValue2.data.getDerValue();
                    s = (byte)(derValueArray.tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = derValueArray.data.getEnumerated()) >= 0 && n < values.length ? values[n] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = CRLReason.UNSPECIFIED;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() == 0) {
                this.nextUpdate = null;
            } else {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                if (s == 0) {
                    this.nextUpdate = derValue2.data.getGeneralizedTime();
                    if (derInputStream.available() != 0) {
                        derValue2 = derInputStream.getDerValue();
                        s = (byte)(derValue2.tag & 0x1F);
                    }
                } else {
                    this.nextUpdate = null;
                }
            }
            if (derInputStream.available() > 0) {
                derValue2 = derInputStream.getDerValue();
                if (derValue2.isContextSpecific((byte)1)) {
                    derValueArray = derValue2.data.getSequence(3);
                    this.singleExtensions = new HashMap<String, Extension>(derValueArray.length);
                    for (n = 0; n < derValueArray.length; ++n) {
                        sun.security.x509.Extension extension = new sun.security.x509.Extension(derValueArray[n]);
                        if (debug != null) {
                            debug.println("OCSP single extension: " + extension);
                        }
                        if (extension.isCritical()) {
                            throw new IOException("Unsupported OCSP critical extension: " + extension.getExtensionId());
                        }
                        this.singleExtensions.put(extension.getId(), extension);
                    }
                } else {
                    this.singleExtensions = Collections.emptyMap();
                }
            } else {
                this.singleExtensions = Collections.emptyMap();
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        @Override
        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:  \n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is " + this.revocationTime + "\n");
                stringBuilder.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            stringBuilder.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return stringBuilder.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

