#!/bin/sh

# change umask to 0 to solve problems related to LLPD
umask 0

# enable the possibility to get core files of binaries started from this script
ulimit -c unlimited

OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"
TRS_ROM_CONFIG="/ffs/run/config/trs"
LTE_PASSIVE_BACKUP="/ffs/stb/passive/backup"
CONFIG_UPGRADE_FILE_EXIST="FALSE"
NETWORKING="${OPT_DIR}/etc/networking"
TRS_CORE_DEST="/ffs/run/logs/"


[ -f "${NETWORKING}" ] && . "${NETWORKING}"

IPTABLE_LMP_SECURITY_RULES="${OPT_DIR}/etc/iptable_lmp_security_rules"

[ -f "${IPTABLE_LMP_SECURITY_RULES}" ] && . "${IPTABLE_LMP_SECURITY_RULES}"

ENCFSPRG=${TRS_BIN_DEST}/changeScenario
ENCFSOPT="-boot"
TRS_BOARD_PUB_KEY_PATH="/etc/keys.d/public"
CONFIG_UPGRADE_FILE="${TRS_ACT_DEST}/config_upgrade.xml"
CONFIG_UPGRADE_TRS_FILE="${TRS_ACT_DEST}/config_upgrade_trs.xml"
AC_CONFIG_UPGRADE_FILE="${TRS_ACT_DEST}/ac_config_upgrade.xml"
AC_CONFIG_UPGRADE_TRS_FILE="${TRS_ACT_DEST}/ac_config_upgrade_trs.xml"

export PATH="${TRS_BIN_DEST}:/sbin:/bin:$PATH"
export LD_LIBRARY_PATH="/usr/lib:${CCS_DIR}:/usr/lib64:/lib64:/lib:$LD_LIBRARY_PATH"

disableRP441()
{
    sed -i '/0x20088/d' /ffs/run/swconfig.txt >/dev/null 2>&1
    sed -i '/sys.hwapi.supervisor/d' /tmp/rat_psconfig.xml >/dev/null 2>&1
    exists=$(grep -c TRS /ffs/run/apps/fct/AppDef*.txt)
    if [ $exists -eq 1 ] ; then
        sed -i 's/#TRS/TRS/' /ffs/run/apps/fct/AppDef*.txt
    else
        sed -i '$ a\TRS;\/opt\/trs\/tmgr;;0;1;' /ffs/run/apps/fct/AppDef*.txt
    fi
    crasign /ffs/run/apps/fct/AppDef*.txt
}

generateboardkeys()
{
    if [ ! -d "$TRS_BOARD_PUB_KEY_PATH" ]; then
        rm -rf "$TRS_BOARD_PUB_KEY_PATH"
        mkdir -m 0775 -p "$TRS_BOARD_PUB_KEY_PATH"
        cragenbkeyset -i /etc/keys.d/board/unitid.dat -s /etc/keys.d/board/privkey.pem sok sig enc </dev/null
    fi
}

renameConfigUpgradeFile()
{
    if [ -e "${CONFIG_UPGRADE_FILE}" ]; then
       mv "${CONFIG_UPGRADE_FILE}" "${CONFIG_UPGRADE_TRS_FILE}"
    fi
}

renameAutoConnConfigUpgradeFile()
{
    if [ -e "${AC_CONFIG_UPGRADE_FILE}" ]; then
       mv "${AC_CONFIG_UPGRADE_FILE}" "${AC_CONFIG_UPGRADE_TRS_FILE}"
    fi
}

loadencfs()
{
    $ENCFSPRG $ENCFSOPT </dev/null
    RET=$?
}

updateEepromInfo()
{
    if [ ! -d "${TRS_DB_DEST}" ]; then
        rm -rf "${TRS_DB_DEST}"
        mkdir -m 0775 -p "${TRS_DB_DEST}"
    fi

    (cd "${TRS_ETC_DEST}" && md5sum eeprom0 eeprom1 >/tmp/eeprom.md5sum)
    if [ ! -s "${TRS_DB_DEST}/eeprom.md5sum" ] || ! cmp -s /tmp/eeprom.md5sum "${TRS_DB_DEST}/eeprom.md5sum"; then
        cp -f "${TRS_ETC_DEST}/eeprom0" "${TRS_DB_DEST}/eeprom0"
        cp -f "${TRS_ETC_DEST}/eeprom1" "${TRS_DB_DEST}/eeprom1"
        chmod 644 /tmp/eeprom.md5sum
        cp -f /tmp/eeprom.md5sum "${TRS_DB_DEST}/eeprom.md5sum"
    else
        rm -f /tmp/eeprom.md5sum
    fi
}

traceLog_copy()
{
   # copy of  TraceLog from active to /ffs/run/log and remove TraceLog from /ffs/run/trs_data/active
    find "/ffs/run/trs_data/active" -name '*Trace*' | while read file; do cp -f "$file" $TRS_PMD_DIR; rm -rf "$file" ; done
}

updatePassiveBackupPath()
{
    local softLink="/ffs/run"
    local activePath=$(readlink $softLink)
    local passivePath="/ffs/fs1"
    if [ $activePath == "/ffs/fs1" ] ; then
        passivePath="/ffs/fs2"
    fi
    LTE_PASSIVE_BACKUP="$passivePath/passive/backup"
}

checkIfConfigUpgradeFileExist()
{
    if [ -f "/ffs/run/trs_data/active/config_upgrade.xml" ]; then
       CONFIG_UPGRADE_FILE_EXIST="TRUE"
    fi
}

copyCertificates()
{
    if [ $CONFIG_UPGRADE_FILE_EXIST == "TRUE" ]; then
        updatePassiveBackupPath
        if [ ! -d $LTE_PASSIVE_BACKUP ] || [ -z "$(ls -A $LTE_PASSIVE_BACKUP)" ]; then
            echo "Certificates migration: $LTE_PASSIVE_BACKUP Doesn't Exist or Empty"
        else
            echo "Certificates migration: Copying from $LTE_PASSIVE_BACKUP"
            cp -a "${LTE_PASSIVE_BACKUP}"/* "${TRS_ACT_DEST}/keystorage/"
            chown -R btssw:btssw $TRS_ACT_DEST/keystorage/*
        fi
    elif [ -d $TRS_ROM_CONFIG ]; then
        if [ -z "$(ls -A $TRS_ROM_CONFIG)" ]; then
            echo "Certificates migration: $TRS_ROM_CONFIG is Empty"
        else
            echo "Certificates migration: Copying from $TRS_ROM_CONFIG"
            cp -a "${TRS_ROM_CONFIG}"/* "${TRS_ACT_DEST}"
            chown -R btssw:btssw $TRS_ACT_DEST/keystorage/*
            rm -rf "${TRS_ROM_CONFIG}"
        fi
    else
        echo "No certificates migrated: $TRS_ROM_CONFIG doesn't Exist"
    fi
}

updateResetCnt()
{
    local cnt
    local thiscnt
    local file
    local keep
    local keepfiles
    local thesefiles
    local deletefiles

    let cnt=$(test_hlEeprom getResetCnt allResets | awk '{print $NF}')
    let thiscnt=$cnt
    let ++cnt
    if [ $cnt -gt 65535 ]; then
        let cnt=0
    fi
    test_hlEeprom setResetCnt allResets $cnt >/dev/null 2>&1

    # create list of files to keep
    let keep=5
    while [ $keep -gt 0 ]; do
        thesefiles="${TRS_PMD_DIR}/TraceLog.${thiscnt}|${TRS_STB_PMD_DIR}/TraceLog.${thiscnt}"
        if [ "x$keepfiles" = "x" ]; then
            keepfiles="$thesefiles"
        else
            keepfiles="${keepfiles}|${thesefiles}"
        fi
        let --keep
        let --thiscnt
        if [ $thiscnt -lt 0 ]; then
            let thiscnt=65535
        fi
    done

    # create list of files to delete
    for file in $(ls "${TRS_PMD_DIR}"/TraceLog.* "${TRS_STB_PMD_DIR}"/TraceLog.* 2>/dev/null); do
        eval "case \"\$file\" in
            $keepfiles)
                ;;
            *)
                deletefiles=\"\$deletefiles '\$file'\"
                ;;
        esac"
    done

    # delete the files
    if [ "x$deletefiles" != "x" ]; then
        eval "rm -f $deletefiles"
    fi
}

createTargetBDInfo()
{
    local VERSION

    VERSION=$(cat "${TRS_SRV_DEST}/targetBD.xml" | grep softwareReleaseVersion|tail -n 1 | FS="\"" awk 'BEGIN { FS = "\"" } ; { print $2 }')
    cp -f "${TRS_SRV_DEST}/targetBD.xml" "${TRS_ACT_DEST}/${VERSION}.xml"
    ln -sf "${VERSION}.xml" "${TRS_ACT_DEST}/swdlBD.xml"

    if [ ! -f "${TRS_ACT_DEST}/passiveBD.xml" ]; then
        cp -f "${TRS_SRV_DEST}/targetBD.xml" "${TRS_ACT_DEST}/passiveBD.xml"
    fi
}

is_failed() {
    if [ $1 -eq 0 ]; then
        echo  ": Done."
    else
        echo  ": Failed ($1)"
    fi
}

loadRMmodule()
{
    echo -n "Loading trs resource manager driver "
    modprobe trs-rm
    is_failed $?
}

loadStartSe()
{
    echo "Loading IP SE on cpu 3-5"
    ${TRS_BIN_DEST}/trswStartup_init 1 3

    # give some time to load SE completely
    usleep 500000
}

loadKmodules()
{
    echo -n "Loading trs FPCi driver "
    modprobe fpci_disp
    is_failed $?

    echo  -n "Loading trs ethernet driver "
    modprobe trs-ethernet
    is_failed $?

    modprobe mem_alloc
    modprobe mcheck_mod
    modprobe mlppp_dev
    modprobe ppp_async
    modprobe esp4
    modprobe esp6

    # VPe: Disable generic-segmentation-offload for eth5 (LMP) for FSMr3
    # in kernel 3.10 LFS Ethernet driver it's enabled by default, while in kernel 2.6 is wasn't
    ethtool -K eth5 gso off
}

initFpPifidx()
{
    ${TRS_BIN_DEST}/FpPifidxIntfApp /opt/trs/etc/pifidx2intfmap.conf
}

startPipelineApp()
{
    ${TRS_BIN_DEST}/sePipelineApp >/dev/null 2>&1 &
    usleep 500000
}

startSeApps()
{
    echo "Starting SE applications"
    initFpPifidx
    startPipelineApp
}

loadFpBridge()
{
    echo "Loading IpFpBridge"
    ${TRS_BIN_DEST}/IpFpBridge >/dev/null 2>&1 &
    disown %+
}

setL2Switch()
{
    echo "Configuring Marvel L2 switch..."

    # set P2 for murkk interface
    # set P3 to Gigabit Ethernet, FTIF ATM traffic path
    ${TRS_BIN_DEST}/trswStartup_init 2 2
    echo "Configuring Marvel L2 switch: DONE"
}

configLmpIf()
{
    identifyLmpIpAddress

    # Configure LMP Interface using trswStartup_init binary
    echo "Config lmp using trswStartup_init"
    ${TRS_BIN_DEST}/trswStartup_init 2 3
    echo "!!!LMP OPENED!!!"

    # Configure iptable securitry rules for LMP,
    # especially enabling/disabling SSH and R&D ports
    configure_lmp_security_rules

    # do not start secure mode
    chmod a+x ${TRS_ETC_DEST}/set_secure_mode
    ${TRS_ETC_DEST}/set_secure_mode init
    ${TRS_ETC_DEST}/set_secure_mode 0
}

addSeDefaultConfiguration()
{
    #Configure ether types
    ${TRS_BIN_DEST}/FPCiTest vtc_ether_type_list_test
    #Enable multicast
    ${TRS_BIN_DEST}/FPCiTest vtc_enable_multicast_test 1
    #Max IP reassembly size
    ${TRS_BIN_DEST}/FPCiTest ip_reass_max_size_set 61439
    #disable Autoconnection
    ${TRS_BIN_DEST}/FPCiTest iptest_auto_conn_flag_se_modify 0
    #Max eth frame size
    ${TRS_BIN_DEST}/FPCiTest vtc_eth_maxFrameSizeSet_test 9600
    # change the queue Weight of queue 3 to be used for mplane
    ${TRS_BIN_DEST}/FPCiTest vtc_hostProtection_setQueueWeight_test 3 64
}

create_fxif_links()
{
    # running script to create links for FxIF images
    if [ -f "${TRS_BIN_DEST}/fxif_link_creation.sh" ]; then
        chmod a+x "${TRS_BIN_DEST}/fxif_link_creation.sh"
        "${TRS_BIN_DEST}/fxif_link_creation.sh"
    fi
}

startTftpMonitor()
{
    if [ -x "${TRS_BIN_DEST}/ftifBist" ]; then
        echo "Starting the tftp LED monitoring porcess"
        ${TRS_BIN_DEST}/ftifBist -a &
        echo "Starting the tftp LED monitoring porcess: DONE"
    fi
}

startFxIFLED()
{
    echo "Set FTIF LED COLOR TO STABLE RED..."
    echo 2 > /sys/class/led/slot3_led_ftif/brightness
    echo "Set FTIF LED COLOR TO STABLE RED: DONE"
}

loadFTIF()
{
    create_fxif_links
    startTftpMonitor
    startFxIFLED

    ln -s /ffs/run/trs/images /tmp/trs/tftpboot
    touch /ffs/run/trs/images/ftif_core
    chmod 644 /ffs/run/trs/images/ftif_core

    ${TRS_BIN_DEST}/trswStartup_init 4 1
}

sysComRoutefile()
{
    if [ -e "/opt/trs/etc/SysComRoute-trsw.xml" ]; then
        cp -f "/opt/trs/etc/SysComRoute-trsw.xml" "/tmp/SysComRoute-trsw.xml"
    fi
}

create_empty_daemon_files()
{
    DAEMON_INI_PATH="/tmp"

    touch ${DAEMON_INI_PATH}/ethd.ini; chmod 664 ${DAEMON_INI_PATH}/ethd.ini;
    touch ${DAEMON_INI_PATH}/mlpppfctd.ini; chmod 664 ${DAEMON_INI_PATH}/mlpppfctd.ini;
    touch ${DAEMON_INI_PATH}/synced.ini; chmod 664 ${DAEMON_INI_PATH}/synced.ini;
    touch ${DAEMON_INI_PATH}/certd.ini; chmod 664 ${DAEMON_INI_PATH}/certd.ini;
    touch ${DAEMON_INI_PATH}/twampd.ini; chmod 664 ${DAEMON_INI_PATH}/twampd.ini;
    touch ${DAEMON_INI_PATH}/bfdd.ini; chmod 664 ${DAEMON_INI_PATH}/bfdd.ini
    touch ${DAEMON_INI_PATH}/triggerd.ini; chmod 664 ${DAEMON_INI_PATH}/triggerd.ini;
    touch ${DAEMON_INI_PATH}/netlinknotifyd.ini; chmod 664 ${DAEMON_INI_PATH}/netlinknotifyd.ini;
    touch ${DAEMON_INI_PATH}/routeconfigd.ini; chmod 664 ${DAEMON_INI_PATH}/routeconfigd.ini;
    touch ${DAEMON_INI_PATH}/congCtrld.ini; chmod 664 ${DAEMON_INI_PATH}/congCtrld.ini;
    touch ${DAEMON_INI_PATH}/rttd.ini; chmod 664 ${DAEMON_INI_PATH}/rttd.ini;
    touch ${DAEMON_INI_PATH}/iptrafficlimd.ini; chmod 664 ${DAEMON_INI_PATH}/iptrafficlimd.ini;
    touch ${DAEMON_INI_PATH}/firewalld.ini; chmod 664 ${DAEMON_INI_PATH}/firewalld.ini;
    touch ${DAEMON_INI_PATH}/ethloamd.ini; chmod 664 ${DAEMON_INI_PATH}/ethloamd.ini;
    touch ${DAEMON_INI_PATH}/gtpPsvd.ini; chmod 664 ${DAEMON_INI_PATH}/gtpPsvd.ini
    touch ${DAEMON_INI_PATH}/upsvd.ini; chmod 664 ${DAEMON_INI_PATH}/upsvd.ini;
    touch ${DAEMON_INI_PATH}/soamd.ini; chmod 664 ${DAEMON_INI_PATH}/soamd.ini
    echo -e "[common]\ntriggerSock = ${DAEMON_INI_PATH}/triggerd.sock" > ${DAEMON_INI_PATH}/routeconfigd.ini;
}

create_dir_traffic_capture()
{
    mkdir /lte1460
    chmod 755 /lte1460
    ln -s /lte1460 /tmp/lte1460
}

#RP00901: World-writable directories shall not be present on the system.
change_directory_permissions()
{
    chmod 755 /ffs/run/apps
    chmod 755 /ffs/run/apps/fct
    chmod 755 /ffs/run/trs
    chmod 755 /ffs/run/trs_data/active
    chmod 755 /ffs/run/addons/fct
    chmod 755 /ffs/run/trs/images
    chmod 755 /tmp/trs
}

#LTE 1891: add mac address for eth6 interface
add_mDTX_virtual_interface()
{
    ip link set eth6 down
    ip link set eth6 address 00:00:00:00:18:91 up
    ${TRS_BIN_DEST}/FPCiTest vtc_set_intf_mac_mdtx_test eth6
    echo 1 > /proc/sys/net/ipv4/conf/eth6/forwarding
}

copy_pppd_ip_up_scripts()
{
    mkdir -m 0744 -p "/etc/ppp"
    cp -f "${TRS_ETC_DEST}/ppp/ip-up" "/etc/ppp/ip-up" &
}

start_vtc_tasks()
{
    echo "start_vtc_tasks"
    ${TRS_BIN_DEST}/vtcTskMgr -c ${TRS_ETC_DEST}/vtc_tsks.conf -m true &
}

disable_links()
{
    echo "Disabling links"
    ${TRS_BIN_DEST}/ddal_test_tool -s 0 -d 0 -n 1 -o 6
    ${TRS_BIN_DEST}/ddal_test_tool -s 0 -d 2 -n 2 -o 11
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 2 -n 0 -o 11
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 2 -n 1 -o 11
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 0 -n 2 -o 6
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 0 -n 3 -o 6
}

update_vtc_task_file_if_FTIF_not_present()
{
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 6 -n 0 -o 1 -v data=5 \
        | grep "Oper=HOTPLUG_BOARD_PRESENT Board= 5 Status= NOT PRESENT" &> /dev/null

    if [ $? == 0 ]; then
        echo "FTIF board not present"
        sed -i '/mlpppfctd/d' ${TRS_ETC_DEST}/vtc_tsks.conf
    fi

}
start_move_pppd_log_script()
{
    ${TRS_BIN_DEST}/ddal_test_tool -s 2 -d 6 -n 0 -o 1 -v data=5 \
        | grep "Oper=HOTPLUG_BOARD_PRESENT Board= 5 Status= PRESENT" &> /dev/null

        if [ $? == 0 ]; then
            if [ -f ${TRS_BIN_DEST}/pppd_log_move.sh ]; then
                ${TRS_BIN_DEST}/pppd_log_move.sh /tmp 83 &
            fi
        fi
}

clear_ipsec_configuration_file()
{
    if ([ -f /etc/ipsec.conf ])
    then
        truncate -s 0  /etc/ipsec.conf
    fi
}

create_default_rule()
{
    ip -6 rule add from all table default priority 32767
}

start_tcpdump_during_boot()
{
    #NEW LOG: Capture tcpdump during bootup.
    #TODO : Enhance code to store multiple reboot files
    rm -rf $TRS_CORE_DEST/eNB_boot_tcpdump.pcap
    touch  $TRS_CORE_DEST/eNB_boot_tcpdump.pcap
    chmod 644  $TRS_CORE_DEST/eNB_boot_tcpdump.pcap
    tcpdump -i eth3 -c 1000 -U -w $TRS_CORE_DEST/eNB_boot_tcpdump.pcap &
}

#**************** VTC application starts here **************************#

disableRP441

generateboardkeys

# Need to preserve config_upgrade.xml existence before renaming
checkIfConfigUpgradeFileExist

#Rename the config_upgrade.xml file so that it will be handled by OAM.
#OAM to handle migration scenario from WMP to SOAM based on the renamed file.
renameConfigUpgradeFile

#Rename the ac_config_upgrade.xml file so that it will be handled by OAM.
#OAM to handle migration scenario from WMP to SOAM based on the renamed file.
renameAutoConnConfigUpgradeFile

loadencfs

updateEepromInfo

traceLog_copy

copyCertificates

updateResetCnt

createTargetBDInfo

# load trs resource mngr kmod
loadRMmodule

# Start SEs
loadStartSe

# Now load remaining trs kernel modules
loadKmodules

# Run SE Applications here
startSeApps

loadFpBridge

setL2Switch

configLmpIf

add_proc_entries

addSeDefaultConfiguration

loadFTIF

enable_sw_interfaces

start_tcpdump_during_boot

sysComRoutefile

create_empty_daemon_files

create_dir_traffic_capture

change_directory_permissions

add_mDTX_virtual_interface

update_vtc_task_file_if_FTIF_not_present

copy_pppd_ip_up_scripts

start_vtc_tasks

disable_links

start_move_pppd_log_script

clear_ipsec_configuration_file

create_default_rule

#**************** VTC application starts here **************************#
