#!/bin/bash
MIGRATION_DIRECTORY="/rom/migration"
MOUNTPOINT="/tmp/sqsh"
MIG_PARAMS="/tmp/migrationParams.json"
SCF=$1
SQSH=$2
BIM=$3
ARCH=`uname -m`
[ $ARCH == "mips64" ] && NODE="../node12_mips" || NODE="../node_arm"

if [ ! -d "$MIGRATION_DIRECTORY" ]; then
    mkdir $MIGRATION_DIRECTORY
fi

if [ ! -d "$MOUNTPOINT" ]; then
    mkdir $MOUNTPOINT
fi

[ $ARCH == "mips64" ] && SCFDLOCATION='{"SCFDLocation": "/rom/rules/SCFD"}' || SCFDLOCATION='{"SCFDLocation": "/rom/swpool/OAM/rules/SCFD"}'
echo "$SCFDLOCATION" > "$MIG_PARAMS"
mount $SQSH $MOUNTPOINT -t squashfs

cd "$MOUNTPOINT"/siteoam/
$NODE --expose-gc src/confMigrateScript.js --NODE_ENV=confupdatescript --additionalParamsPath="$MIG_PARAMS" "$BIM" "$SCF"

cd /
umount $MOUNTPOINT
