import zlib
from zlib import adler32
import sys
import os
import log

class checksum_verify():
    def __init__(self, file_to_check, correct_cheksum_value):
        self.file_to_check = file_to_check
        self.correct_cheksum_value = correct_cheksum_value

    def calculate_checksum(self):
        file_stream=open(file_to_check,'rb')
        sum=1L
        while True:
            file_lines=file_stream.read(4096)
            if not file_lines:
                break          
            sum=zlib.adler32(file_lines,sum)
        file_stream.close()
        log.logger.info("Calculated checksum for file %s is %d" % (file_to_check, sum & 0xffffffff))
        return sum & 0xffffffff

    def is_checksum_ok(self):
        if self.calculate_checksum() == self.correct_cheksum_value:
            log.logger.info("Checksum success")
            return 0
        else:
            log.logger.error("Checksum fail")
            return -1

if __name__ == '__main__':
    file_to_check = sys.argv[1]
    correct_value = sys.argv[2]
    verify = checksum_verify(file_to_check, int(correct_value))
    if int(correct_value) == 0:
        log.logger.info("Input cheksum is 0, no need to calculate")
        result = 0
    else:
        result = verify.is_checksum_ok()

    if result == 0:
        sys.exit(result)
    else:
        sys.exit("ChecksumFail")
