# Logger

Implementation of asynchronous logger with different backends or appenders:

* *console* prints to process.stdout
* *syslog* sends lines to given host and port as UDP packets
* *file* produces a log file in file system
* *platform* forwards loging to AaSyslog platform implementation

## Add to package.json

```
npm install @nokia/logger --save
```

## Usage

Loggers should be activated using a ```package```, which will define the used logging level. Also the log lines will contain the package name, so relevant log lines can be easily seen.

If no package is given, the *root logger* is used along with it's log level. The root package name is empty string and it's log level is used for all packages if not configured otherwise.

```
var logger = require("@nokia/logger").forPackage("test");
logger.debug("String to output: %s", "String");
```

output is

```
01 <06:06:51.559> DEBUG/test:String to output: String
```


## Options

Logging should be *configured* to produce needed output.

The configuration object contains the following properties:

* *levels* define the active logging levels for packages
* *appenders* a list of appenders and their configuration

Full configuration example:

```
var loggerConfig = {
    component: "NODEOAM",
    levels: {
        "": "WRN",
        "mescom": "TRC"
    },
    appenders: [
        {name: "console"},
        {name: "syslog", opts: {host: "192.168.255.126", port: 51000}},
        {name: "file", opts: {filename: "/ram/nodeoam.log"}}
    ]
};
require("@nokia/logger").configure(loggerConfig);
```

Logging levels can be set programmatically. Supported levels are *'ERR', 'WRN', 'INF', 'DBG', 'TRC'* and the special 'SILENT' (which means no output).


## Development

Tests and jshint checks are run using [Grunt](http://gruntjs.com/). Default run task is both test & lint:

```
grunt
```
