#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2016 Nokia Solutions and Networks. All rights reserved

import signal
import Queue
import socket
import loader_socket
import message_dispatcher
import message_handler
import log
import os
import sys


class loader():

    def __init__(self):
        log.logger.info("loader: init ...")
        self.message_queue = Queue.Queue()
        self.esm_socket = loader_socket.LoaderSocket(
            socket.AF_UNIX, self.message_queue)
        self.psm_socket = loader_socket.LoaderSocket(
            socket.AF_INET, self.message_queue)

        self.esm_message_handler = message_handler.EsmMessageHandler(
            self.psm_socket, self.esm_socket)
        self.psm_rpc_message_handler = message_handler.PsmMessageHandler(
            self.esm_socket)
        self.psm_command_handler = message_handler.CommandHandler(
            self.psm_socket)

        self.dispatcher = message_dispatcher.MessageDispatcher(
            self.message_queue)

    def run(self, sock_addr):
        log.logger.info("loader: start ...")
        log.logger.info("loader location-os.getcwd(): %s" % os.getcwd())
        self.dispatcher.register_handler(self.esm_message_handler)
        self.dispatcher.register_handler(self.psm_rpc_message_handler)
        self.dispatcher.register_handler(self.psm_command_handler)

        # start ESM socket firstly.
        self.esm_socket.start(sock_addr, "esmSocket")

        # dispatch is started to handle message
        self.dispatcher.run()
        # send first message to ESM.
        self.esm_message_handler.initialize()

        signal.signal(signal.SIGALRM, self.loader_terminate)
        signal.pause()

    def loader_terminate(self, signum, frame):
        log.logger.info("loader: receive terminate signal: %d" % signum)
        self.destroy()

    def destroy(self):
        self.esm_socket.stop()
        self.psm_socket.stop()
        self.dispatcher.stop()

        self.dispatcher.unregister_handler(self.esm_message_handler)
        self.dispatcher.unregister_handler(self.psm_rpc_message_handler)
        self.dispatcher.unregister_handler(self.psm_command_handler)
        log.logger.info("loader: destroy ...")


def get_esm_sock_address():
    if(3 != len(sys.argv)):
        log.logger.info("loader: Invalid parameter account = %d" % len(sys.argv))
        print sys.argv
        return None

    if(sys.argv[1] != "--socket-path"):
        log.logger.info("loader: Invalid option(" + sys.argv[1] + ")")
        log.logger.info("loader: The accepted option is only --socket-path")
        return None

    sock_addr = sys.argv[2]
    if(os.path.exists(sock_addr)):
        log.logger.info("loader: File exist in system " + sock_addr)
    else:
        log.logger.info("loader: File not exist in system " + sock_addr)

    return sock_addr


def check_tmp_content(file_path):
    file_list = os.listdir(file_path)
    log.logger.info("loader: file content in tmp begin")
    for item in file_list:
        log.logger.info("loader: %s" % item)
    log.logger.info("loader: file content in tmp end")


# main entry of loader
if __name__ == '__main__':
    exit_code = 1
    sock_addr = get_esm_sock_address()

    if(sock_addr is None):
        log.logger.info("loader: exit as invalid address")
        sys.exit(exit_code)
    else:
        exit_code = 0

    log.logger.info("loader: start to create loader instance")
    loader = loader()

    try:
        loader.run(sock_addr)
    except Exception as e:
        log.logger.error("loader: exception is catched during running")
        log.logger.error("loader: exception info: " + str(e))
        exit_code = 1
    finally:
        log.logger.info("loader: destroy")
        loader.destroy()
        sys.exit(exit_code)
