#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2016 Nokia Solutions and Networks. All rights reserved


import threading
import log


class MessageDispatcher():

    def __init__(self, queue):
        self.queue = queue
        self.messagecount = 0
        self.is_thread_alive = True
        self.handler = []

    def register_handler(self, handler):
        self.handler.append(handler)

    def unregister_handler(self, handler):
        self.handler.remove(handler)

    def __messagehandle__(self):
        while self.is_thread_alive:
            message = self.queue.get()
            is_message_consume = False
            for handler in self.handler:
                try:
                    if handler.handle(message):
                        is_message_consume = True
                        break
                except Exception as e:
                    log.logger.warn("MessageDispatcher: exception is detectd and will be ignored")
                    log.logger.warn("MessageDispatcher: exception info: " + str(e))
                    # it's possible that there is exception while handling message
                    # The way to handle such exception is to ignore it and try next handler.
                    # PSM or ESM will tominate laoder if this is something wrong in Loader.
                    # Just make laoder alway working and don't do decision of exit.
                    continue;

            if not is_message_consume:
                log.logger.warn("MessageDispatcher: unknown message received, just discard it")

        log.logger.warn("MessageDispatcher: thread is exiting")

    def stop(self):
        self.is_thread_alive = False

    def run(self):
        log.logger.info("MessageDispatcher: is started...")
        self.dispatcher_thread = threading.Thread(
            target=self.__messagehandle__, name="messageDispatcher")
        self.dispatcher_thread.setDaemon(True)
        self.dispatcher_thread.start()

    def join(self):
        self.dispatcher_thread.join()
