#! /bin/sh

OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"
LOG_DIR="/var/log"
LOG_DIR_LIGHTTPD="/ffs/run/trs_data/active/"

TRS_DATA="/ffs/run/trs_data"
TRS_ACT_DEST="${TRS_DATA}/active"

# ---------- Dest Path ------------------

TRS_BIN_DEST="${OPT_DIR}/bin"
TRS_LIB_DEST="${OPT_DIR}/lib64"
TRS_ETC_DEST="${OPT_DIR}/etc"

TRS_KEYSTR_DEST="${TRS_ACT_DEST}/keystorage"
TRS_KEYSTR_DEST_CERTS="${TRS_KEYSTR_DEST}/certs"

export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib64:/lib64:/lib:$LD_LIBRARY_PATH"
export PATH="${TRS_BIN_DEST}:$PATH"

for file in $LOG_DIR $LOG_DIR_LIGHTTPD/lighttpd.pid /tmp/lighttpd /tmp/lighttpd/cache /tmp/lighttpd/cache/compress; do
    if [ -e "$file" ]; then
        chmod 777 $file
    fi
done

mkdir -m 0775 -p "${TRS_KEYSTR_DEST_CERTS}"

if [ ! -e "${TRS_KEYSTR_DEST_CERTS}/privkey.crk" ]; then
    /bin/cp -f "${TRS_ETC_DEST}/cert/bts_priv_key.pem" "${TRS_KEYSTR_DEST_CERTS}/privkey.crk"
fi

if [ ! -e "${TRS_KEYSTR_DEST_CERTS}/cert.pem" ]; then
    /bin/cp -f "${TRS_ETC_DEST}/cert/bts_pub_cert.pem" "${TRS_KEYSTR_DEST_CERTS}/cert.pem"
fi

${OPT_DIR}/trs.lighttpd.sh start
