#!/bin/bash
##########################################################################
# core_pattern
# |/opt/CCS/crashHandler.sh <CoreSize> <CorePath> %c %e
#-------------------------------------------------------------------------
# Input parameters:
         CORESIZE=$1        # <CoreSize>    Maximum size of the compressed core file
readonly COREPATH=$2        # <CorePath>    Path where the corefile and bt-coreinfo will be stored
readonly SOFTLIMIT=$3       # %c            core file size soft resource limit of crashing process (since Linux 2.6.24)
readonly PROCNAME=$4        # %e            executable filename (without path prefix)
#
# Path and Filename:
         COREFILE=$COREPATH/core.xz
readonly BTCOREINFO=$COREPATH/bt-coreinfo.txt
#
# Binary paths
readonly CRASHHANDLER=/usr/bin/crashHandler
#
# Lockfile setting
readonly LOCKPATH=$COREPATH
readonly SCRIPTNAME=$(basename "$0")
readonly LOCK_FD=200

##########################################################################

coreDumping() {
    if [[ "$SOFTLIMIT" == "0" ]]; then
        CORESIZE=0
    fi
    if [[ "$CORESIZE" == "0" ]]; then
        COREFILE=/dev/null
    fi
    ${CRASHHANDLER} -dk -s $CORESIZE -o "$COREFILE" -l "$BTCOREINFO" "$PROCNAME"
}

lock() {
    lock_file=$COREPATH/.$SCRIPTNAME.lock

    eval "exec $LOCK_FD>$lock_file"

    flock -n $LOCK_FD \
        && return 0 \
        || return 1
}
#main function
main() {
    lock || exit 1
    umask 0037
    coreDumping
    rm $lock_file
}
# entry point
main
