#!/bin/bash
#****************************************************************************************
#
# Copyright 2016 Nokia. All rights reserved.
#
#****************************************************************************************
# run_fixPicoGNSS
#
# Created 9.03.2015 / korus
#
# copy to directory: /opt/bm/
#

APPLY_ID="FWEC FWED FWEE FWFB FWFC FWFD FWFE FWFF FWFG FWGI FWGJ FWGK FWGL FWGM FWGN FWHG FWHH FWHI FWHJ FWHK FWHL FWIC FWID FWIE FWNA FWNB FWNC FWQB FWQC FWQD"
APPLY_VERSION=".X1 .X2"

UNIT_ID=`cat /proc/device-tree/board-identity/unit-id`
VERSION=`cat /proc/device-tree/board-identity/product-code | sed -e 's/.*\(.X..\)/\1/' -e 's/.$//'`

BM_SCRIPTS_LOG=/tmp/bm-scripts.log
WRITE_IS_OK="write test works!"


if [[ $APPLY_ID == *$UNIT_ID* && $APPLY_VERSION == *$VERSION* ]]; then
	echo -e "Detected pico board $UNIT_ID $VERSION - apply fix for GNSS signal sensitivity" > $BM_SCRIPTS_LOG

	status=0

	echo -e "Clearing GPSLNAsel bit and reset GNSS receiver" >> $BM_SCRIPTS_LOG
	fpgamem -L 0x14 "&0xfbfffffe" > /dev/null
	if [ $? -ne '0' ]; then
		echo -e "Write failed!!!" >> $BM_SCRIPTS_LOG
		(( ++status ))
	fi

	sleep 1

	echo -e "Enabling GNSS" >> $BM_SCRIPTS_LOG
	fpgamem -L 0x14 "|0x1" > /dev/null
	if [ $? -ne '0' ]; then
        echo -e "Write failed!!!\n" >> $BM_SCRIPTS_LOG
		(( ++status ))
	fi

	if [ $status -eq '0' ]; then
		echo -e "GNSS fix was applied successfully" >> $BM_SCRIPTS_LOG
	elif [ $status -eq '1' ]; then
		echo -e "Error occured while GNSS fix was applied" >> $BM_SCRIPTS_LOG
	else
		echo -e "Errors occured while GNSS fix was applied" >> $BM_SCRIPTS_LOG
	fi
else
	echo -e "Detected board $UNIT_ID $VERSION - GNSS fix not needed" > $BM_SCRIPTS_LOG
fi
