#!/bin/sh
#############################################################################
#  Copyright 2017 Nokia. All Rights Reserved
#  File : extlog.sh
#  Description: This shell script is added as part of fid 176358 to
#               support archiving of FLR and CT logs when feature is enabled.
#               Following options are supported
#               "-r" to remove older archives when number of archives to be
#                    saved is lowered.
#               "-c" to check file size in /store/extlog against a qutoa
#                    and remove the oldest archive if quota is exceeded and
#                    to remove the oldest archive and move the rest of archives.
#               "-o" In addition to "-c" calls optf_read to create the text file
#                    of the current OPTF file and create a zip file of this
#                    output file
##############################################################################
#set -x
#set -e

getLock() {
touch "$LOCK_FILE"
# Try to obtain lock
while [ "`cat $LOCK_FILE 2> /dev/null`" != $$ ]; do
    [ ! -s "$LOCK_FILE" ] && echo $$ >> "$LOCK_FILE" && break
    usleep 10000
done
}

#checkQuota <quota> <file_name> <type> <last_archive_num>
checkQuota() {
  # if quota is 0 then it is considered unlimited quota
  # return ok in this case
  if [ $1 -eq 0 ]
  then
      return 0
  fi
  ITER=$(($4))
  while [ $ITER -ge 0 ]; do
    FILE_SIZE=$((`find $OUT_DIR  -type f -name "*ext$3*" | xargs wc | tail -n 1 | awk '{print $3}'`))
    #echo $FILE_SIZE
    if [ $FILE_SIZE -gt $1 ]
    then
        #rm "$OUT_DIR/$2.ext$3.$ITER.zip" 2>/dev/null
        rm "$OUT_DIR/$2.ext$3.$ITER.gz" 2>/dev/null
    else
        return 0
    fi
    export ITER=$((ITER-1))
  done
  return 1
}

#moveArchive <filename> <type> <last_archive_num>
moveArchive() {
  #[ -f "$OUT_DIR/$1.ext$2.$3.zip" ] && rm "$OUT_DIR/$1.ext$2.$3.zip"
  [ -f "$OUT_DIR/$1.ext$2.$3.gz" ] && rm "$OUT_DIR/$1.ext$2.$3.gz"
  ITER=$(($3-1))
 while [ $ITER -ge 0 ]; do
    #[ -f "$OUT_DIR/$1.ext$2.$ITER.zip" ] && mv -f "$OUT_DIR/$1.ext$2.$ITER.zip" "$OUT_DIR/$1.ext$2.$((ITER+1)).zip"
    [ -f "$OUT_DIR/$1.ext$2.$ITER.gz" ] && mv -f "$OUT_DIR/$1.ext$2.$ITER.gz" "$OUT_DIR/$1.ext$2.$((ITER+1)).gz"
    export ITER=$((ITER-1))
 done
}
#removeFiles <name> <file_type> <start> <end>
removeFiles() {
  i=$(($3+1))
  end=$(($4+1))
  while [[ $i -lt $end ]];
    do
    #echo "$1.ext$2.$i.zip"
    #rm "$OUT_DIR/$1.ext$2.$i.zip" 2>/dev/null
    rm "$OUT_DIR/$1.ext$2.$i.gz" 2>/dev/null
    i=$(($i+1))
  done
}

#removeGreaterThan <name> <file_type> <last_valid_arch#>
removeGreaterThan() {

   #find how many archives have the same name format
   #NUMBER_FILES=$((`find $OUT_DIR -type f -name "$1.ext$2.*.zip" | wc -l`))
   NUMBER_FILES=$((`find $OUT_DIR -type f -name "$1.ext$2.*.gz" | wc -l`))

  #loop through all files checking the archive number
   while [ $NUMBER_FILES -gt 0 ]; do
	#get the archive number
	#ARCH_NUM=`find $OUT_DIR -type f -name "$1.ext$2.*.zip" | sed -n "$NUMBER_FILES p" | awk -F '[.]' '{printf $5}'`
	ARCH_NUM=`find $OUT_DIR -type f -name "$1.ext$2.*.gz" | sed -n "$NUMBER_FILES p" | awk -F '[.]' '{printf $5}'`

	#check against the new max of archives
	if [ $ARCH_NUM -gt $3 ]
	then
		#echo "$1.ext$2.$ARCH_NUM.zip"
		#rm "$OUT_DIR/$1.ext$2.$ARCH_NUM.zip" 2>/dev/null
		rm "$OUT_DIR/$1.ext$2.$ARCH_NUM.gz" 2>/dev/null
	fi
	NUMBER_FILES=$(($NUMBER_FILES-1))
  done

  return 0
}

usage() {
   echo "Usage:"
        echo "       ${0} -c quota filename file_type last_archive_num"
        echo "       ${0} -o quota filename file_type last_archive_num input_file"
        echo "       ${0} -r filename file_type start_archive_num end_archive_num"
	echo "       ${0} -g filename file_type max_archive_num"
        echo "               "
        echo $1 $2 $3 $4 $5 $6
}
if [ $# != 4 ] && [ $# != 5 ] && [ $# != 6 ]
then
    usage
    exit 1
fi
if [ $1 != "-c" ] && [ $1 != "-o" ] && [ $1 != "-r" ] && [ $1 != "-g" ]
then
    usage
    exit 1
fi
#echo $1 $2 $3 $4 $5 $6

trap 'rm -f "$LOCK_FILE" 2> /dev/null' 0
trap "exit 2" 1 2 3 15

#export OUT_DIR=/store/extlog
if [ $1 == "-r" ] || [ $1 == "-g" ]
then
export OUT_FILE=`basename $2`
export OUT_DIR=`dirname $2`
else
export OUT_FILE=`basename $3`
export OUT_DIR=`dirname $3`
fi
export LOCK_FILE="/tmp/$OUT_FILE"

getLock

if [ $1 == "-r" ]
then
    if [ $4 -gt $5 ]
    then
        usage
        exit 1
    fi
    removeFiles $OUT_FILE $3 $4 $5
    exit 0
fi

if [ $1 == "-g" ]
then
    removeGreaterThan $OUT_FILE $3 $4
    exit 0
fi


[ ! -d "$OUT_DIR" ] && mkdir "$OUT_DIR"

checkQuota $2 $OUT_FILE $4 $5

if [ $? -ne 0 ]
then
    echo "checkQuota failed"
    exit 1
fi

moveArchive $OUT_FILE $4 $5

if [ $1 == "-o" ]
then
    /active/bin/optf_read $6 > "$OUT_DIR/$OUT_FILE"
    cd $OUT_DIR
    zip -9q "$OUT_DIR/$OUT_FILE.extFlr.1.zip"  "$OUT_DIR/$OUT_FILE"
    #echo $?
    chmod 755 "$OUT_DIR/$OUT_FILE.extFlr.1.zip"
    rm "$OUT_DIR/$OUT_FILE"
fi
