#!/bin/bash
##########################################################################
# core_pattern
# |/opt/CCS/coreDispatcher.sh <Host NodeID> %e %P %s %t %c %h <CoreSize> <CorePath> <MultiCoreEnabled> <MultiCoreLockTimeout>
# crashHandler is a common name for CCS and RT and the name should not be changed
# crashHandler is called in following parameters:
# crashHandler <NodeID> %e %P %s %t %c <CoreSize> <CorePath>
#-------------------------------------------------------------------------
# Input parameters:
readonly HOST_NODEID=$1                 # <NodeID>                NodeID on which the crash occurred.
readonly PROCPATH=$2                    # %E                      Pathname of executable, with slashes ('/') replaced by exclamation marks ('!').
readonly PID=$3                         # %P                      PID of dumped process, as seen in the initial PID namespace
readonly SIGNALNO=$4                    # %s                      Number of signal causing dump.
readonly TIME=$5                        # %t                      Time of dump, expressed as seconds since the Epoch, 1970-01-01 00:00:00 +0000 (UTC).
readonly SOFTLIMIT=$6                   # %c                      Core file size soft resource limit of crashing process (since Linux 2.6.24).
readonly HOSTNAME=$7                    # %h                      Hostname (for virtual nodes host name indicates virtual nodeId).
readonly CORESIZE=$8                    # <CoreSize>              Maximum size of the compressed core file.
readonly COREPATH=$9                    # <CorePath>              Path where the corefile and bt-coreinfo will be stored.
readonly MULTICORE_ENABLED=${10}        # <MultiCoreEnabled>      Flag to enable multi core dumping.
readonly MULTICORE_LOCK_TIMEOUT=${11}   # <MultiCoreLockTimeout>  Lock timeout for multi core dumping.

# Binary paths
readonly CRASHHANDLER=/opt/CCS/crashHandler.sh
readonly LXC_SYSROOT_PATH=/tmp/node_${HOSTNAME}
readonly LXC_CRASHHANDLER="${LXC_SYSROOT_PATH}/${CRASHHANDLER}"

#Process name:
readonly PROCNAME="$(basename $(echo "${PROCPATH}" | tr '!' '/'))"

#Pass correct NodeID to the crashHandler
if [[ $HOSTNAME =~ 0[xX][0-9A-Fa-f]{4}$ ]]; then
    readonly NODEID=${BASH_REMATCH}
    logger --tag "[CCS]" "using HOSTNAME ($HOSTNAME) as NODEID ($NODEID)"
else
    readonly NODEID=$HOST_NODEID
    logger --tag "[CCS]" "using HOST_NODEID ($HOST_NODEID) as NODEID"
fi

redirectCoreTo()
{
    logger --tag "[CCS]" "redirecting core to $1 with parameters: $NODEID $PROCNAME $PID $SIGNALNO $TIME $SOFTLIMIT $CORESIZE $COREPATH $MULTICORE_ENABLED $MULTICORE_LOCK_TIMEOUT"
    ${1} "$NODEID" "$PROCNAME" "$PID" "$SIGNALNO" "$TIME" "$SOFTLIMIT" "$CORESIZE" "$COREPATH" "$MULTICORE_ENABLED" "$MULTICORE_LOCK_TIMEOUT"
}

##########################################################################
main()
{
    if [ -e "$LXC_CRASHHANDLER" ] ; then
        redirectCoreTo "$LXC_CRASHHANDLER"
    else
        redirectCoreTo $CRASHHANDLER
    fi;
}

# entry point
main
