#!/bin/bash

# list_to_keep - if any lines in AppDef.txt contains string which is listed in list_to_keep, the lines will NOT be deleted from Appdef.txt file. 
# For example: to delete whole AppDef.txt contains, list_to_keep should be empty.
# If list_to_keep contains ".tgz", all lines contains ".tgz" string in file Appdef.txt will NOT be deleted.  
list_to_keep=""

echo "slave_post_install started" 

if [ ! -e ./new_release/addons ]
then
        echo "./new_release/addons does not exist - slave_post_install stopped"
        exit 1
fi

if [ ! -e ./new_release/addons/APPDEF*.tgz ]
then
        echo "file APPDEF*.tgz does not exist - slave_post_install stopped"
        exit 1
fi

cd ./new_release/addons
appdef_file=`ls APPDEF*.tgz`
temp_dir="appdef_temp_dir"

if [ ! -e $temp_dir ]
then
        mkdir $temp_dir
fi

cp $appdef_file $temp_dir
cd $temp_dir

tar xf $appdef_file

if [ ! -e ram/AppDef.txt ]
then
        echo "file ram/AppDef.txt does not exist - slave_post_install stopped"
        cd ..
	rm -rf $temp_dir
	exit 1
fi

rm $appdef_file
old_file=$(cat ram/AppDef.txt)
new_list=""
while read -r line;
do
	while read -r keep_line;
	do
		if [[ "$keep_line" != "" && "$line" == *"$keep_line"* ]]; then
			printf -v new_list "%s%s\n" "$new_list" "$line"
			break
		fi
	done <<< "$list_to_keep"
done <<< "$old_file"

echo "$new_list" > ram/AppDef.txt

tar czf $appdef_file *
mv $appdef_file ../
cd ..
chmod a+r $appdef_file
rm -rf $temp_dir
cd ..
echo "slave_post_install completed"
exit 0
