#!/bin/sh
function addCoredumpRADToSwconfig() {
    local TARGET_FILE=/rom/swconfig.txt
    if [[ -f $TARGET_FILE ]]; then
        sed -r '/0x100[bB]7/ d' -i $TARGET_FILE
        echo "0x100B7 = 1" >> $TARGET_FILE   
    fi
}

# Replace nid , masternid and slave nid in ccs.appstart (LTE1996) (LTE2137)
MASK="0x00ff"
MASK1="0xff00"
NID="/rom/btsom/config/active/nid_config.txt"
if [ -f "$NID" ]; then
    #load nid number from nid_config.txt, nid number in this file has format 0x#### where # is hexadecimal digit
    NUMBER=$(cat $NID)
   
    #getting the slave nid value from the existing ccs.appstart
    SLAVE_NID=$(grep "export SLAVE_NID=" /opt/appstart.d/ccs.appstart |  cut -d'=' -f2)
    #Updating slave nid value to correct value(0x214d from 0x124d) based on the Board Id of the FZAP,The cpuid(4d)is constant for slave hence updating the board id
    SLAVE_NID=$((${SLAVE_NID}&${MASK})) 
    VAR=$((${NUMBER}&${MASK1}))
    SLAVE_NID=$((${SLAVE_NID}|${VAR}))
    SLAVE_NID=0x`echo "obase=16;ibase=10; $SLAVE_NID" | bc`

    #replace all occurances of .=nid=0x####. with .=nid=0xNID number from file.
    sed -i 's/SINGLE_NID=0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/SINGLE_NID='"$NUMBER"'/' /opt/appstart.d/ccs.appstart 
    sed -i 's/MASTER_NID=0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/MASTER_NID='"$NUMBER"'/' /opt/appstart.d/ccs.appstart 
    sed -i 's/SLAVE_NID=0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/SLAVE_NID='"$SLAVE_NID"'/' /opt/appstart.d/ccs.appstart

    #replace the following 0x123d occurances with new NID=NUMBER (like 213d).
    # <tag name="sys.default.nodeid" type="u16">0x123D</tag>
    # <tag name="ccs.service.aasyslog.sicaddress.local" type="u32">0x123d0601</tag>
    # <tag name="ccs.service.aasyslog.sicaddress.remote" type="u32">0x123d031D</tag>
    cat /opt/hwr/CCSEarlyConfig.xml \
    | sed 's/<tag name="sys.default.nodeid" type="u16">0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/<tag name="sys.default.nodeid" type="u16">'"$NUMBER"'/'  \
    | sed 's/<tag name="ccs.service.aasyslog.sicaddress.local" type="u32">0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/<tag name="ccs.service.aasyslog.sicaddress.local" type="u32">'"$NUMBER"'/' \
    | sed 's/<tag name="ccs.service.aasyslog.sicaddress.remote" type="u32">0x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]/<tag name="ccs.service.aasyslog.sicaddress.remote" type="u32">'"$NUMBER"'/'  \
    > /opt/hwr/CCSEarlyConfig.xml1
    mv /opt/hwr/CCSEarlyConfig.xml1 /opt/hwr/CCSEarlyConfig.xml    
fi

FIREWALL_DISABLE="/rom/btsom/config/firewall.txt"
if [ -f "$FIREWALL_DISABLE" ]; then
    echo "
    while true
    do
        iptables -F
        iptables -P INPUT ACCEPT
        iptables -P FORWARD ACCEPT
        iptables -P OUTPUT ACCEPT
        sleep 5
    done
    " > /ffs/run/clearIptables.sh
    chmod a+x /ffs/run/clearIptables.sh
    nohup /ffs/run/clearIptables.sh& >/dev/null
fi

# Copy the BTSOM specific shared libraries to /lib64 directory
cp /opt/BTSOM/lib/* /lib64
cp /opt/BTSOM/lib/* /lib

addCoredumpRADToSwconfig

# Create the BTSOM config directories in /rom
mkdir -p /rom/btsom/config/active
mkdir -p /rom/btsom/config/backup
mkdir -p /rom/btsom/config/inactive/xoh
mkdir -p /rom/btsom/config/inactive/asn

# Create the BTSOM config directories in /tmp
mkdir -p /tmp/LTE
mkdir -p /rom/Raml

# Copy files
cp /opt/BTSOM/config/SUTool /rom/btsom/config/active
cp /opt/BTSOM/config/SCFD*.txt /rom/btsom/config/active
cp /opt/BTSOM/config/vendor_fdd.xml /tmp
cp /opt/BTSOM/config/vendor_tdd.xml /tmp
cp /opt/BTSOM/config/config_fpga /rom/config
cp /opt/BTSOM/config/aif--config_6_RP3-LB_and_Antenna.txt /rom/config

#Zone stuff
cp /opt/BTSOM/config/APPDEF_AIO.tgz /rom/config/APPDEF_AIO.tgz


chmod 755 /opt/trs/www/html/cgi-bin/TSDataLogFile.sh


