# BTS configuration delete. This script will be
# executed by HWAPI module when configuration reset action is
# triggered via SEM.
# PATH: /opt/BTSOM/oam.configdelete.sh
# Req Reference: ConfigReset usecase

CONFIG_BACKUP_PATH=/ffs/run/config.bak
CONFIG_PATH=/ffs/run/config
LOG_FILE=/var/log/config_reset.log
BACKUP_LOG_FILE=/var/log/config_reset_backup.log
ACT_AUTOCONF_REPORT=/rom/config/AutoConfReport.txt
ACT_AUTOCONF_LOG=/rom/config/AutoConfLog.txt
RESET_REASON_BACKUP_FILE=/ffs/run/btsom.bak/reset_reason_log.txt
RESET_REASON_FILE=/ffs/run/btsom/reset_reason_log.txt
BTSOM_DIR=/ffs/run/btsom/
export SHELL=/bin/sh

if [ -e "$LOG_FILE" ]; then
    count=$(wc -l "$LOG_FILE"|awk '{print $1}')
    if [ $count -gt 98  ]; then
        rm -f "${BACKUP_LOG_FILE}" >/dev/null 2>&1
        mv -f "${LOG_FILE}" "${BACKUP_LOG_FILE}"
    fi
fi

echo "BTS Configuration delete Triggered at $(date)" >> $LOG_FILE

if [ -e "${CONFIG_BACKUP_PATH}" ]; then
    echo "Moving of configuration backup to config." >> $LOG_FILE
    /bin/mv -f "${CONFIG_BACKUP_PATH}" "${CONFIG_PATH}" > /dev/null 2>&1
fi

if [ -e "${RESET_REASON_BACKUP_FILE}" ]; then
    echo "Moving of ${RESET_REASON_BACKUP_FILE} file to ${RESET_REASON_FILE}" >> $LOG_FILE
    /bin/mkdir -p "${BTSOM_DIR}" > /dev/null 2>&1
    chown toor4nsn:root "${BTSOM_DIR}" > /dev/null 2>&1
    /bin/cp -a "${RESET_REASON_BACKUP_FILE}" "${RESET_REASON_FILE}" > /dev/null 2>&1
fi

if [ -e "${ACT_AUTOCONF_REPORT}" ]; then
    echo "Deleting Auto config reort at $(date)" >> $LOG_FILE
    /bin/rm -rf "${ACT_AUTOCONF_REPORT}" > /dev/null 2>&1
fi

if [ -e "${ACT_AUTOCONF_LOG}"  ]; then
    echo "Deleting Auto config Log at $(date)" >> $LOG_FILE
    /bin/rm -rf "${ACT_AUTOCONF_LOG}" > /dev/null 2>&1
fi

echo "BTS Configuration delete finished at: $(date)" >> $LOG_FILE
