#/opt/BTSOM/scripts/generate_snapshot.sh
HOME="/ram/LTE/SNAPSHOT_HOME"
DATE=`date +'%Y%m%d'`

if [[ $# -ne 3 ]]; then
echo "Usage: /opt/BTSOM/scripts/generate_snapshot.sh <full/minor/crash> <btsid> <nodeid>"
exit
fi

if [[ $1 == "full" ]]; then
echo "Received FULL"
elif [[ $1 == "minor" ]]; then
echo "Received MINOR"
elif [[ $1 == "crash" ]]; then
echo "Received CRASH"
else
echo "Improper input ---- Usage: /opt/BTSOM/scripts/generate_snapshot.sh <full/minor/crash> <btsid> <nodeid>"
fi

#Removing old Files if any from /ram/LTE/
rm -rf $HOME/*BTS_Config*
rm -rf $HOME/*BTS_Log*
rm -rf $HOME/*TRS_Config*
rm -rf $HOME/*TRS_Log*
rm -rf $HOME/*_metadata*


########################################################################################################################
mkdir -p $HOME/BTS_Config/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/ is not created"
exit
fi



cp -p /ffs/run/SiteEM.xml $HOME/BTS_Config/BTS$2_$3_SiteEM.xml
cp -p /ram/vendor.xml $HOME/BTS_Config/BTS$2_$3_vendor.xml
cp -p /ram/LTE_CurrentBD.xml $HOME/BTS_Config/BTS$2_$3_LTE_CurrentBD.xml
cp -p /opt/hwr/CCSEarlyConfig.xml $HOME/BTS_Config/BTS$2_$3_CCSEarlyConfig.xml
cp -p /opt/BTSOM/config/btsom_asn_config.txt $HOME/BTS_Config/BTS$2_$3_btsom_asn_config.txt
cp -p /ram/AppDef.txt $HOME/BTS_Config/BTS$2_$3_AppDef.txt
cp -p /opt/hwr/service.xml $HOME/BTS_Config/BTS$2_$3_hwr_service.xml
cp -p /opt/hwr/hwr.xml $HOME/BTS_Config/BTS$2_$3_hwr.xml
cp -p /opt/BTSOM/config/alarmRulesData.txt $HOME/BTS_Config/BTS$2_$3_alarmRulesData.txt
journalctl -b > $HOME/BTS_Config/BTS$2_$3_journal.log

mkdir -p $HOME/BTS_Config/active/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/active/ is not created"
else
cp -p /rom/btsom/config/active/* $HOME/BTS_Config/active/
fi


mkdir -p $HOME/BTS_Config/backup/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/backup/ is not created"
else
cp -p /rom/btsom/config/backup/* $HOME/BTS_Config/backup/
fi

if [[ -d /rom/LTEU-stats/ ]] ; then
tar --directory=/rom/ -cf LTEU-stats.tar LTEU-stats/
cp -p /rom/LTEU-stats.tar $HOME/BTS_Config
rm -rf /rom/LTEU-stats.tar
fi


cd $HOME
tar -cf BTS$2_$3_BTS_Config.tar BTS_Config
gzip $HOME/BTS$2_$3_BTS_Config.tar
rm -rf $HOME/BTS_Config




########################################################################################################################
mkdir -p $HOME/BTS_Log/
mkdir -p $HOME/BTS_Log/SupervisionOut/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Log/ is not created"
exit
fi


#ExtendedSystemInfo.log
/opt/BTSOM/scripts/ExtendedSystemInfo_log.sh > $HOME/BTS_Log/ExtendedSystemInfo.log 2>&1


cp -p /ram/stats/RD.BTS-* $HOME/BTS_Log/
cp -p /ram/stats/PM.BTS-* $HOME/BTS_Log/
cp -p /ram/ActiveRawAlarmList.txt $HOME/BTS_Log/BTS$2_$3_ActiveRawAlarmList.txt
cp -p /ram/RawFaults.xml $HOME/BTS_Log/BTS$2_$3_RawFaults.xml
cp -p /ram/RawFaultsDropped.xml $HOME/BTS_Log/BTS$2_$3_RawFaultsDropped.xml
cp -p /ram/BtsOmAlarms.xml $HOME/BTS_Log/BTS$2_$3_BtsOmAlarms.xml
cp -p /ram/AlarmsSuppressed.xml $HOME/BTS_Log/BTS$2_$3_AlarmsSuppressed.xml
cp -p /rom/dcp/dcp_* $HOME/BTS_Log/BTS$2_$3_dcp_log.tar.z

# copy the debug and syslogs for additional debugging if needed
cp -p /var/log/local/debug* $HOME/BTS_Log/
cp -p /var/log/local/syslog* $HOME/BTS_Log/

cp -p /rom/supervision/* $HOME/BTS_Log/SupervisionOut/

cd $HOME
tar -cf BTS$2_$3_BTS_Log.tar BTS_Log
gzip $HOME/BTS$2_$3_BTS_Log.tar
rm -rf $HOME/BTS_Log

########################################################################################################################
