#!/bin/bash
#
# start_om.sh
#
#
# Function for error logging
#
function error()
{
    logger -p daemon.err -t FZ_BTSOM "$@"
}

#
# Function for info logging
#
function info()
{
    logger -p daemon.info -t FZ_BTSOM "$@"
}

Node=`echo $(hostname) | cut -d '-' -f1`

info "This is $Node node starting FZ_BTSOM."

info "waiting for TRSApps to come up..."

TIMEOUT=60

export BTSOMROOT=/opt/nsn/BTS_SC_OAM_FZM
export LD_LIBRARY_PATH=lib:/lib64:$BTSOMROOT/lib:$LD_LIBRARY_PATH

#-----------------------------------------------------------------------------------
# wait for TRSApps
#-----------------------------------------------------------------------------------

i=0
while [ ! ` pgrep  ukTmgr ` ] ; do
    info "Waiting for TRSApps"
    sleep 5
    if [ $i -lt $TIMEOUT ]
    then
        ((i=i+5))
	info "Waiting for TRSApps $i sec, Timeout after $TIMEOUT"
    else
        error "Waiting for TRSApps timeout reached, exiting"
        exit 1
    fi
done
sleep 15

#-----------------------------------------------------------------------------------
# Create the BTSOM config directores and copy files.
#-----------------------------------------------------------------------------------
/opt/nsn/BTS_SC_OAM_FZM/script/create_links.sh

#-----------------------------------------------------------------------------------
# BTSOM startup
#-----------------------------------------------------------------------------------

info "TRSApps is up, launching FZ_BTSOM Apps"

#$BTSOMROOT/bin/BStatexe 2>&1 &
#sleep  5
#$BTSOMROOT/bin/FaRecoexe 2>&1 &
#sleep 5
#$BTSOMROOT/bin/CellPexe 2>&1 &
#sleep 5
#$BTSOMROOT/bin/RP1Aexe 2>&1 &
#sleep 5
#$BTSOMROOT/bin/BMgrexe 2>&1 &
#sleep 5
#$BTSOMROOT/bin/BCtrlexe 2>&1 &
#sleep 5

#./kill_om.sh

#sleep 5

#info "restarting.... FZ_BTSOM Apps"

$BTSOMROOT/bin/BStatexe 2>&1 &
sleep 3
$BTSOMROOT/bin/FaRecoexe 2>&1 &
sleep 3
$BTSOMROOT/bin/CellPexe 2>&1 &
sleep 3
$BTSOMROOT/bin/RP1Aexe 2>&1 &
sleep 3
$BTSOMROOT/bin/BMgrexe 2>&1 &
sleep 3
exec $BTSOMROOT/bin/BCtrlexe 2>&1
