// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		DisplayCellInformation.js
//
// ****************************************************************************

( function( $ )
{
        var REQUEST_TIMER_INTERVAL = 10000;
	var MAX_CELL_NUM = 3;
        var xmlHttp;
        var timerId;

	var startRequestTimer = function()
	{
		if( $( "#cellInfoPanel" ).is( ":visible" ) )
		{
			timerId = setTimeout( function() {

				// Reset timer ID to undefined
				timerId = void( 0 );

				// Invoke call back function
				sendCellInfoRequest();

			}, REQUEST_TIMER_INTERVAL );
		}

		// Else, panel has been closed while waiting for response from server; don't
		// start timer.
	}

	var stopRequestTimer = function()
	{
		if( typeof timerId !== "undefined" )
		{
			clearTimeout( timerId );

			// Reset to undefined
			timerId = void( 0 );
		}
	}

	var sendCellInfoRequest = function()
	{
		// Create and send XMLHttpRequest to server
		try
		{
			xmlHttp = new XMLHttpRequest();
		
			// Register event listener for response
			xmlHttp.addEventListener( "readystatechange", processCellInfoResponse, false );
		
			// GET information asynchronously from server
			xmlHttp.open( "GET", "cgi-bin/CellInfoHandler.php", true );
			xmlHttp.send();
		}
		catch( exception )
		{
			console.log( "Asynchronous cell information request failed" );

			// Set timer and try again later.
			startRequestTimer();
			return;
		}
	}

	var processCellInfoResponse = function()
	{
		if( (xmlHttp.readyState == 4) && (xmlHttp.status == 200) )
		{
			// Regardless of success or failure, set timer to send next request
			// after a wait interval.
			startRequestTimer();

			var CellInfoResponse;

			try
			{
				// A valid response should contain a JSON object.
				CellInfoResponse = JSON.parse( xmlHttp.responseText );
			}
			catch( exception )
			{
				// Parsing failure
				console.log( "JSON parsing error in processCellInfoResponse():\n" + exception );
				console.log( xmlHttp.responseText );
				return;
			}


			if( !("statusInd" in CellInfoResponse) ||
			     (typeof CellInfoResponse.statusInd !== "string") )
			{
				console.log( "Invalid cell info response; missing status indicator" );
				return;
			}

			if( CellInfoResponse.statusInd === "Success" )
			{
				updateCellInfoPanel( CellInfoResponse );
			}
			else
			{
				// Failure has occurred. Read failure reason.
				if( !("_failReason" in CellInfoResponse) ||
				     (typeof CellInfoResponse._failReason !== "string") )
				{
					console.log( "Invalid cell info response; missing failure reason" );
					return;
				}

				console.log( "Cell info failure reason: " + CellInfoResponse._failReason );

				if( CellInfoResponse._failReason === "invalidSession" )
				{
					stopRequestTimer();

					// Configuration failed because the user session has expired.
					window.alert( "Session has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}
			}
		}

		else if( xmlHttp.readyState == 4 )
		{
			// HTTP level failure has occurred.
			console.log( "Failed to receive cell info response from server" );

			// Try again next interval
			startRequestTimer();
		}
	}

	var populateCellInfo = function( cellInfo, cellIndex )
	{

		var $cell_div = $( "#cellInfoPanel" ).find( "#cell_" + cellIndex );
		$cell_div.show();

		if( !("_id" in cellInfo) ||
		 (typeof cellInfo._id !== "string"))
		{
			console.log( "Invalid cell info response; missing _id" );
			$cell_div.find( "h4" ).find("strong").text("Cell");
		}
		else
		{
			$cell_div.find( "h4" ).find("strong").text( "Cell-" + cellInfo._id );
		}

		if( !("_globalCellId" in cellInfo) ||
		 (typeof cellInfo._globalCellId !== "string"))
		{
			console.log( "Invalid cell info response; missing _globalCellId" );
			$cell_div.find( ".global-cell-id" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".global-cell-id" ).text( cellInfo._globalCellId );
		}

		if( !("phyCellId" in cellInfo) ||
		 (typeof cellInfo.phyCellId !== "string"))
		{
			console.log( "Invalid cell info response; missing phyCellId" );
			$cell_div.find( ".phy-cell-id" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".phy-cell-id" ).text( cellInfo.phyCellId );
		}

		if( !("ULCarrierFrequency" in cellInfo) ||
		 (typeof cellInfo.ULCarrierFrequency !== "string"))
		{
			console.log( "Invalid cell info response; missing ULCarrierFrequency" );
			$cell_div.find( ".ul-carrier-frequency" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".ul-carrier-frequency" ).text( cellInfo.ULCarrierFrequency );
		}

		if( !("DLCarrierFrequency" in cellInfo) ||
		 (typeof cellInfo.DLCarrierFrequency !== "string"))
		{
			console.log( "Invalid cell info response; missing DLCarrierFrequency" );
			$cell_div.find( ".dl-carrier-frequency" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".dl-carrier-frequency" ).text( cellInfo.DLCarrierFrequency );
		}

		//if channel bandwidth is give, assume to be a TDD site, hide uplink/downlink channel bandwidth, and show channel bandwidth
		//otherwise assume t be FDD site, hide channel bandwidth and show uplink/downlink channel bandwidth
		if( ("chBw" in cellInfo) )
		{
			$cell_div.find( ".channel-bandwidth" ).parent().show();
			$cell_div.find( ".ul-channel-bandwidth" ).parent().hide();
			$cell_div.find( ".dl-channel-bandwidth" ).parent().hide();
			if( typeof cellInfo.chBw === "string" )
			{
				$cell_div.find( ".channel-bandwidth" ).text( cellInfo.chBw );
			}
			else
			{
				$cell_div.find( ".channel-bandwidth" ).text( "Not available" );
			}
		}
		else
		{
			$cell_div.find( ".channel-bandwidth" ).parent().hide();
			$cell_div.find( ".ul-channel-bandwidth" ).parent().show();
			$cell_div.find( ".dl-channel-bandwidth" ).parent().show();

			if( !("ulChBw" in cellInfo) ||
				(typeof cellInfo.ulChBw !== "string"))
			{
				console.log( "Invalid cell info response; missing ulChBw" );
				$cell_div.find( ".ul-channel-bandwidth" ).text("Not available");
			}
			else
			{
				$cell_div.find( ".ul-channel-bandwidth" ).text( cellInfo.ulChBw );
			}

			if( !("dlChBw" in cellInfo) ||
				(typeof cellInfo.dlChBw !== "string"))
			{
				console.log( "Invalid cell info response; missing dlChBw" );
				$cell_div.find( ".dl-channel-bandwidth" ).text("Not available");
			}
			else
			{
				$cell_div.find( ".dl-channel-bandwidth" ).text( cellInfo.dlChBw );
			}
		}

		if( !("mimoType" in cellInfo) ||
		 (typeof cellInfo.mimoType !== "string"))
		{
			console.log( "Invalid cell info response; missing mimoType" );
			$cell_div.find( ".mimo-type" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".mimo-type" ).text( cellInfo.mimoType );
		}

		if( !("_operationalState" in cellInfo) ||
		 (typeof cellInfo._operationalState !== "string"))
		{
			console.log( "Invalid cell info response; missing _operationalState" );
			$cell_div.find( ".cell-op-state" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".cell-op-state" ).text( cellInfo._operationalState );
		}

		if( !("_blockingState" in cellInfo) ||
		 (typeof cellInfo._blockingState !== "string"))
		{
			console.log( "Invalid cell info response; missing _blockingState" );
			$cell_div.find( ".cell-block-state" ).text("Not available");
		}
		else
		{
			$cell_div.find( ".cell-block-state" ).text( cellInfo._blockingState );
		}
	}

	var updateCellInfoPanel = function( CellInfoResponse )
	{
		if( CellInfoResponse == null )
		{
			return;
		}
		
		var $cellInfoPanel = $( "#cellInfoPanel" );
		$cellInfoPanel.find( "#cell_0" ).hide();
		$cellInfoPanel.find( "#cell_1" ).hide();
		$cellInfoPanel.find( "#cell_2" ).hide();
		$cellInfoPanel.find( "#cellInfoMissingDescription" ).hide();

		//check the cell info in the respond should be an array
		if( "Cell" in  CellInfoResponse )
		{
			if( $.isArray( CellInfoResponse.Cell ) )
			{
				for(var i = 0; ( i < CellInfoResponse.Cell.length) && ( i < MAX_CELL_NUM ) ; i++)
				{
					populateCellInfo( CellInfoResponse.Cell[i], i );
				}
			}
			else
			{
				populateCellInfo( CellInfoResponse.Cell, "0" );
			}
		}
		else
		{ 
			$cellInfoPanel.find( "#cellInfoMissingDescription" ).show();
		}

	}

	NSNReady( function()
	{	

		$( "#displayCellInfoLink" ).click( function() 
		{

                        if( $( this ).parent().is( ".disabled" ) )
                        {
                                return;
                        }
	
			if( $( "#cellInfoPanel" ).is( ":visible" ) )
			{
				return;
			}

			// Hide any open panel(s) in the display area.
			$( ".content-display-panel" ).not( "#cellInfoPanel" ).trigger( "closePanel" );

			// Show the cell info panel in the display area.
			$( "#cellInfoPanel" ).show();

			//Display cellInfo not available by default
                        $( "#cellInfoPanel" ).find( ".channel-bandwidth" ).parent().hide();
                        $( "#cellInfoPanel" ).find( ".ul-channel-bandwidth" ).parent().show();
                        $( "#cellInfoPanel" ).find( ".dl-channel-bandwidth" ).parent().show();
			$( "#cellInfoPanel" ).find( "#cell_0" ).hide();
                        $( "#cellInfoPanel" ).find( "#cell_1" ).hide();
                        $( "#cellInfoPanel" ).find( "#cell_2" ).hide();
                        $( "#cellInfoPanel" ).find( "#cellInfoMissingDescription" ).show();

			sendCellInfoRequest();
		});
	
		$( "#cellInfoPanel" ).bind( "uncommissionedEvent", function()
		{
			//site switch to uncommissioned, hide all cell_div 
			//and display cell info not available

			$( "#cellInfoPanel" ).find( "#cell_0" ).hide();
			$( "#cellInfoPanel" ).find( "#cell_1" ).hide();
			$( "#cellInfoPanel" ).find( "#cell_2" ).hide();
			$( "#cellInfoPanel" ).find( "#cellInfoMissingDescription" ).show();	
		});

		$( "#cellInfoPanel" ).bind( "closePanel", function()
		{
			// Stop periodic timer if active.
			stopRequestTimer();

			if( typeof xmlHttp !== "undefined" )
			{
				xmlHttp.removeEventListener( "readystatechange", processCellInfoResponse, false );
				xmlHttp.abort();
			}

			$( "#cellInfoPanel" ).hide();
		});

		$( "#cellInfoPanel" ).hide();
	});

})( jQuery )
