// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		DisplaySiteInformation.js
//
// ****************************************************************************

( function( $ )
{

	var REQUEST_TIMER_INTERVAL = 10000;
	var xmlHttp;
	var timerId;


	var startRequestTimer = function()
	{
		if( $( "#siteInfoPanel" ).is( ":visible" ) )
		{
			timerId = setTimeout( function() {

				// Reset timer ID to undefined
				timerId = void( 0 );

				// Invoke call back function
				sendSiteInfoRequest();

			}, REQUEST_TIMER_INTERVAL );
		}

		// Else, panel has been closed while waiting for response from server; don't
		// start timer.
	}

	var stopRequestTimer = function()
	{
		if( typeof timerId !== "undefined" )
		{
			clearTimeout( timerId );

			// Reset to undefined
			timerId = void( 0 );
		}
	}



	var sendSiteInfoRequest = function()
	{
		// Create and send XMLHttpRequest to server
		try
		{
			xmlHttp = new XMLHttpRequest();
		
			// Register event listener for response
			xmlHttp.addEventListener( "readystatechange", processSiteInfoResponse, false );
		
			// GET information asynchronously from server
			xmlHttp.open( "GET", "cgi-bin/SiteInfoHandler.php", true );
			xmlHttp.send();
		}
		catch( exception )
		{
			console.log( "Asynchronous site information request failed" );

			// Set timer and try again later.
			startRequestTimer();
			return;
		}
	}


	var processSiteInfoResponse = function()
	{
		if( (xmlHttp.readyState == 4) && (xmlHttp.status == 200) )
		{
			// Regardless of success or failure, set timer to send next request
			// after a wait interval.
			startRequestTimer();

			var siteInfoResponse;

			try
			{
				// A valid response should contain a JSON object.
				siteInfoResponse = JSON.parse( xmlHttp.responseText );
			}
			catch( exception )
			{
				// Parsing failure
				console.log( "JSON parsing error in processSiteInfoResponse():\n" + exception );
				console.log( xmlHttp.responseText );
				return;
			}


			if( !("statusInd" in siteInfoResponse) ||
			     (typeof siteInfoResponse.statusInd !== "string") )
			{
				console.log( "Invalid site info response; missing status indicator" );
				return;
			}

			if( siteInfoResponse.statusInd === "Success" )
			{
				updateSiteInfoPanel( siteInfoResponse );
			}
			else
			{
				// Failure has occurred. Read failure reason.
				if( !("_failReason" in siteInfoResponse) ||
				     (typeof siteInfoResponse._failReason !== "string") )
				{
					console.log( "Invalid site info response; missing failure reason" );
					return;
				}

				console.log( "Site info failure reason: " + siteInfoResponse._failReason );

				if( siteInfoResponse._failReason === "invalidSession" )
				{
					stopRequestTimer();

					// Configuration failed because the user session has expired.
					window.alert( "Session has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}
			}
		}

		else if( xmlHttp.readyState == 4 )
		{
			// HTTP level failure has occurred.
			console.log( "Failed to receive site info response from server" );

			// Try again next interval
			startRequestTimer();
		}
	}

	var updateSiteInfoPanel = function( siteInfoResponse )
	{
		if( siteInfoResponse == null )
		{
			return;
		}
		
		var $siteInfoPanel = $( "#siteInfoPanel" );
		//apMod update
		if( !("_apModId" in siteInfoResponse) )
		{
			console.log( "missing _apModId, assume site to be FZM" );
			$siteInfoPanel.find( "#apModId" ).parent().hide();
		}
		else if( (typeof siteInfoResponse._apModId !== "string") )
		{
			console.log( "Invalid site info response; bad parameter:_apModId" );
			$siteInfoPanel.find( "#apModId" ).parent().show();
			$siteInfoPanel.find( "#apModId" ).text("Not available");
		}
		else
		{
			$siteInfoPanel.find( "#apModId" ).parent().show();
		        $siteInfoPanel.find( "#apModId" ).text( siteInfoResponse._apModId );
		}
		//antMod update
		if( !("_antModId" in siteInfoResponse) )
		{
			console.log( "missing _antModId, assume site to be FZM or FZAP" );
			$siteInfoPanel.find( "#antModId" ).parent().hide();
		}
		else if( (typeof siteInfoResponse._antModId !== "string") )
		{
			console.log( "Invalid site info response; bad parameter:_antModId" );
			$siteInfoPanel.find( "#antModId" ).parent().show();
			$siteInfoPanel.find( "#antModId" ).text("Not available");
		}
		else
		{
			$siteInfoPanel.find( "#antModId" ).parent().show();
			$siteInfoPanel.find( "#antModId" ).text( siteInfoResponse._antModId );
		}
		//sfnApMasterId update
		if( !("sfnApMasterId" in siteInfoResponse) )
		{
			console.log( "missing sfnApMasterId, assume site to be FZM or FZAP" );
			$siteInfoPanel.find( "#sfnApMasterId" ).parent().hide();
		}
		else if( (typeof siteInfoResponse.sfnApMasterId !== "string") )
		{
			console.log( "Invalid site info response; bad parameter:sfnApMasterId" );
			$siteInfoPanel.find( "#sfnApMasterId" ).parent().show();
			$siteInfoPanel.find( "#sfnApMasterId" ).text("Not available");
		}
		else
		{
			$siteInfoPanel.find( "#sfnApMasterId" ).parent().show();
			$siteInfoPanel.find( "#sfnApMasterId" ).text( siteInfoResponse.sfnApMasterId );
		}
		//Site Name update
		if( !("_siteName" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._siteName !== "string"))
		{
			console.log( "Invalid site info response; missing site Name" );
			$siteInfoPanel.find( "#siteName" ).text("Not available");
		}
		else
		{
		        $siteInfoPanel.find( "#siteName" ).text( siteInfoResponse._siteName );
		}
		//BTS type update
		if( !("btsType" in siteInfoResponse)  ||
			(typeof siteInfoResponse.btsType !== "string"))
		{
			console.log( "Invalid site info response; missing BTS type" );
			$siteInfoPanel.find( "#btsType" ).text("Not available");
		}
		else
		{
			if( siteInfoResponse.btsType.indexOf("Master") == -1 )
			{
				$("#displayAntennaInfoLink").parent().hide();
			}
			$siteInfoPanel.find( "#btsType" ).text( siteInfoResponse.btsType );
		}
		//Site Id update
		if( !("AutoconnectionSiteId" in siteInfoResponse)  ||
		    (typeof siteInfoResponse.AutoconnectionSiteId !== "string") )
		{
			console.log( "Invalid site info response; missing AutoconnectionSiteId" );
		        $siteInfoPanel.find( "#siteId" ).text("Not available");
		}
		else
		{
		        $siteInfoPanel.find( "#siteId" ).text( siteInfoResponse.AutoconnectionSiteId );
		}
		//Bts Id update
		if( !("_bsId" in siteInfoResponse)   ||
		    (typeof siteInfoResponse._bsId !== "string"))
		{
			console.log( "Invalid site info response; missing AutoconnectionBtsId" );
			$siteInfoPanel.find( "#btsId" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#btsId" ).text( siteInfoResponse._bsId );
		}

		//HW type update
		if( !("_unitName" in siteInfoResponse)  ||
			(typeof siteInfoResponse._unitName !== "string") )
		{
			console.log( "Invalid site info response; missing _unitName(HW type)" );
			$siteInfoPanel.find( "#unitName" ).text("Not available" );
		}
		else
		{
			$siteInfoPanel.find( "#unitName" ).text( siteInfoResponse._unitName );
		}

		//Bts serial num  update
		if( !("_serialNro" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._serialNro !== "string") )
		{
			console.log( "Invalid site info response; missing _serialNro(Serial Number)" );
			$siteInfoPanel.find( "#hwSerialNumber" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#hwSerialNumber" ).text( siteInfoResponse._serialNro);
		}
		
		//Managed object in scf update
		if( !("_distName" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._distName !== "string") )
		{
			console.log( "Invalid site info response; missing _distName(MOIScf)" );
			$siteInfoPanel.find( "#managedObject" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#managedObject" ).text( siteInfoResponse._distName );
		}

		//BTS address (mplane)
		if( !("_bsAddress" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._bsAddress !== "string") )
		{
			console.log( "Invalid site info response; missing _bsAddress" );
			$siteInfoPanel.find( "#btsAddress" ).text("Not available" );
		}
        else
        { 
           $siteInfoPanel.find( "#btsAddress" ).text( siteInfoResponse._bsAddress );
        }

		//swVersion
		if( !("SIReleaseVersion" in siteInfoResponse)  ||
		    (typeof siteInfoResponse.SIReleaseVersion !== "string") )
		{
			console.log( "Invalid site info response; missing SW Release Version " );
			$siteInfoPanel.find( "#swVersion" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#swVersion" ).text( siteInfoResponse.SIReleaseVersion );
		}

		//Operational State update
		if( !("_operationalStatus" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._operationalStatus !== "string"))
		{
			console.log( "Invalid site info response; missing OperationalState" );
			$siteInfoPanel.find( "#opState" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#opState" ).text( siteInfoResponse._operationalStatus );
		}		
		//Blocking State update
		if( !("_blockingState" in siteInfoResponse)  ||
		    (typeof siteInfoResponse._blockingState !== "string") )
		{
			console.log( "Invalid site info response; missing _blockingState" );
			$siteInfoPanel.find( "#blockState" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#blockState" ).text( siteInfoResponse._blockingState );
		}
		//Synchronization Source update
		if( !("SyncSource" in siteInfoResponse)  ||
		    (typeof siteInfoResponse.SyncSource !== "string") )
		{
			console.log( "Invalid site info response; missing SyncSource" );
			$siteInfoPanel.find( "#syncSource" ).text("Not available");
		}
		else
		{
		    $siteInfoPanel.find( "#syncSource" ).text( siteInfoResponse.SyncSource );
		}
	}

	
	NSNReady( function()
	{	

		// Request information to display from server.
		sendSiteInfoRequest();

		$( "#displaySiteInfoLink" ).click( function() {
	
			if( $( "#siteInfoPanel" ).is( ":visible" ) )
			{
				return;
			}

			// Hide any open panel(s) in the display area.
			$( ".content-display-panel" ).not( "#siteInfoPanel" ).trigger( "closePanel" );

			// Show the site info panel in the display area.
			$( "#siteInfoPanel" ).show();

			sendSiteInfoRequest();
		});
	
		$( "#siteInfoPanel" ).bind( "closePanel", function()
		{
			// Stop periodic timer if active.
			stopRequestTimer();

			if( typeof xmlHttp !== "undefined" )
			{
				xmlHttp.removeEventListener( "readystatechange", processSiteInfoResponse, false );
				xmlHttp.abort();
			}

			$( "#siteInfoPanel" ).hide();
		});
	});

})( jQuery )
