// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		LocationLockManagement.js
//
// ****************************************************************************

( function( $ )
{
	var xmlHttpLocationLockUpdateRequest;
	var LocationLockStatus = "false";
	var infoRequest = false;
	var $closeButton = $( "#locationLockCloseButton" );
	var $startButton = $( "#locationLockStartButton" );
    
	NSNReady( function()
	{
		$( "#locationLockLink" ).click( function() 
		{
			if( $( "#locationLockDialog" ).is( ":visible" ) )
			{
				//Dialog window already open
				return;
			}

			if( $( this ).parent().is( ".disabled" ) )
			{
				//Button disabled
				return;
			}

			//Hide Progress Indicator and "location lock status unavailable"
			$( "#locationLockProgressIndicator" ).hide();
			$( "#locationLockStatusUnavailable" ).hide();
			$( "#locationLockDisplay" ).show();

			//assign statuses for buttons
			//setting Close to call-to-action to avoid accidental locks/unlocks
			//setting Start to disabled until the radio value changes
			$startButton.removeClass( "call-to-action" )
				.removeClass( "disabled" )
				.show();
                
			$closeButton.removeClass( "disabled" )
            	.addClass( "call-to-action" )
				.show()
				.find( ".button-content" ).text( "Cancel" );

			//enable all radio buttons
			$( "[name='locationLockUpdate']" ).parent().next().removeClass( "disabled" );

			//retrieve _actLocationLock value
			updateAndShowProgressIndicator( "current" );
			$( "[name='locationLockUpdate']" ).parent().next().addClass( "disabled" );
			sendLocationLockInfoRequest();

            //Set focus to close button when dialog is open
            setTimeout( function()
            {
            	$closeButton.focus();
            } , 100 );
                
            //click handler for close button
            $closeButton.click( function() 
			{
            	if( $( this ).is( ".disabled" ) )
                {
					return;
                }
                
				$( this ).addClass( "disabled" );
                        
                // Close the dialog window.
                $( "#locationLockDialog" ).trigger( "close" );
            } );
                
            //handle the start button click
            $startButton.click( function()
            {
            	//do nothing if start button is disabled
                if( $( this ).is( ".disabled" ) )
                {
					return;
            	}
                      
                //disable the button
                $( this ).addClass( "disabled" );
				$closeButton.addClass( "disabled" );        
                updateAndShowProgressIndicator( "current" , "Updating location lock" );
				$( "[name='locationLockUpdate']" ).parent().next().addClass( "disabled" );
                sendLocationLockUpdateRequest();
			} );

			$( "#locationLockDialog" ).bind( "close" , function() 
			{
				// Stop any ongoing request.
				// Note, the dialog window itself is closed by handler in webuiDialogs.js
				if( typeof xmlHttpLocationLockUpdateRequest !== "undefined" )
				{
					xmlHttpLocationLockUpdateRequest.removeEventListener( "readystatechange", processModifyBandClassResponse, false );
					xmlHttpLocationLockUpdateRequest.abort();
				}
 
			} );
            
			//Open the dialog
			$( "#locationLockDialog" ).trigger( "open" );
		} );	
	} );

	var sendLocationLockInfoRequest = function()
	{
		try
		{
			xmlHttp = new XMLHttpRequest();

			// Register event listener for response
			xmlHttp.addEventListener( "readystatechange" , processLocationLockInfoResponse , false );

			var url = "cgi-bin/LocationLockInfoHandler.php";

			// GET information asynchronously from server
			xmlHttp.open( "GET" , url , true );
			xmlHttp.send();
			infoRequest = true;
		}
		
		catch( exception )
		{
			console.log( "Asynchronous locationLock info request failed" );

			updateAndShowProgressIndicator( "error" );
			updateButtonsOnFailure();
			return;
		}
	}

	var processLocationLockInfoResponse = function()
	{
		var $dialog = $( "#LocationLockDialog" );
	
		if( ( xmlHttp.readyState == 4 ) && ( xmlHttp.status == 200 ) )
		{
			// Received response from server. Check the result.
			var LocationLockInfoResponse;

			try
			{
				LocationLockInfoResponse = JSON.parse( xmlHttp.responseText );
			}
			
			catch( exception)
			{
				// Parsing failure
				console.log( "JSON parsing error in processLocationLockInfoResponse():\n" + exception );
				console.log( xmlHttp.responseText );
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
				return;
			}
				
			if( !( "statusInd" in LocationLockInfoResponse ) ||
				( typeof LocationLockInfoResponse.statusInd !== "string" ) )
			{
				console.log( "Invalid locationLockInfo response; missing status indicator" );
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
			}

			if( LocationLockInfoResponse.statusInd === "Success" )
			{
				if( "_actLocationLock" in LocationLockInfoResponse && typeof LocationLockInfoResponse._actLocationLock === "string" )
				{
					if( LocationLockInfoResponse._actLocationLock === "true" )
					{
						LocationLockStatus = "true";
						$( "#locationLockProgressIndicator" ).hide();
					}
				
					else if( LocationLockInfoResponse._actLocationLock === "false" )
					{
						LocationLockStatus = "false";
						$( "#locationLockProgressIndicator" ).hide();
					}

					if( LocationLockStatus !== $( "#locationLockDialog input[name=locationLockUpdate]:checked" ).val() )
					{
						flipRadioSelection();
					}

					$("#locationLockCurrent").text( LocationLockStatus );
					$( "[name='locationLockUpdate']" ).parent().next().removeClass( "disabled" );
				}
			
				else
				{
					console.log( "_actLocationLock missing from responseText" );
					updateAndShowProgressIndicator( "error" );
					updateButtonsOnFailure();
				}
			}
		
			else
			{
				if( !( "_failReason" in LocationLockInfoResponse ) ||
					( typeof LocationLockInfoResponse._failReason  !== "string" ) )
				{
					console.log( "Invalid _actLocationLockInfo response; missing failure reason" );
					$( "#locationLockDisplay" ).hide();
					$( "#locationLockStatusUnavailable" ).show();
					$( "#locationLockDialog" ).find( ".radiobutton-container" ).removeClass( "disabled" );
					updateAndShowProgressIndicator( "error" );
					updateButtonsOnFailure();
					return;
				}

				console.log( "Location lock info request failure reason: " + LocationLockInfoResponse._failReason );

				if( LocationLockInfoResponse._failReason === "invalidSession" )
				{
					updateAndShowProgressIndicator( "warning" , "Session expired" );
					updateButtonsOnFailure();

					// User session has expired.
					window.alert( "Session has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}
				
				// Procedure failed.
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
			}
		}
		
		else if( xmlHttp.readyState == 4 )
		{
			// HTTP level failure has occurred.
			infoRequest = false;
			console.log( "Failed to receive LocationLockInfoResponse from server" );
			updateAndShowProgressIndicator( "error" );
			updateButtonsOnFailure();
		}
	}

	var sendLocationLockUpdateRequest = function()
	{
		// Create and send XMLHttpRequest to server.
		// This is the initial request to update locationLock.
		try
		{
			xmlHttp = new XMLHttpRequest();

			// Register event listener for response
			xmlHttp.addEventListener( "readystatechange", processLocationLockUpdateResponse, false );
			var url = "cgi-bin/LocationLockUpdateHandler.php";
		
			// Get security token
			var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();
			var csrfTokenEncoded = encodeURIComponent( csrfToken );

			// Read selected location lock value from user interface
			var locationLockUpdateStatus;
			
			if($( "#locationLockDialog input[name=locationLockUpdate]:checked" ).val() == "true")
			{
				console.log("Updating location lock to " + $( "#locationLockDialog input[name=locationLockUpdate]:checked" ).val());
				locationLockUpdateStatus = "true";
			}
		
			else
			{
				console.log("Updating location lock to " + $( "#locationLockDialog input[name=locationLockUpdate]:checked" ).val());
				locationLockUpdateStatus = "false";
			}

			var postData = "_actLocationLock=" + locationLockUpdateStatus + "&ctkn=" + csrfTokenEncoded;

			// POST information asynchronously
			xmlHttp.open( "POST", url, true );

			// Set encoding used for the request body (HTML form) and length of contents.
			xmlHttp.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
			xmlHttp.setRequestHeader( "Content-Length", postData.length );

			xmlHttp.send(postData);
		}
	
		catch( exception )
		{
			console.log( "Asynchronous location lock update request failed" );
			console.log(exception);
			updateAndShowProgressIndicator( "error" );
			updateButtonsOnFailure();
			return;
		}
	}

	var processLocationLockUpdateResponse = function()
	{
		var $dialog = $( "#LocationLockDialog" );
	
		if( ( xmlHttp.readyState == 4 ) && ( xmlHttp.status == 200 ) )
		{
			// Received response from server. Check the result.
			var LocationLockUpdateResponse;

			try
			{
				LocationLockUpdateResponse = JSON.parse( xmlHttp.responseText );
			}
		
			catch( exception )
			{
				console.log( "JSON parsing error in processLocationLockUpdateResponse():\n" + exception );
				console.log( xmlHttp.responseText );
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
				return;
			}
		
			if( !( "statusInd" in LocationLockUpdateResponse ) ||
				( typeof LocationLockUpdateResponse.statusInd !== "string" ) )
			{
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
				return;
			}

			if( LocationLockUpdateResponse.statusInd === "Success" )
			{
				if( "_actLocationLock" in LocationLockUpdateResponse && typeof LocationLockUpdateResponse._actLocationLock === "string" )
				{
					if( LocationLockUpdateResponse._actLocationLock === "true" )
					{
						LocationLockStatus = "true";
					}
				
					else
					{
						LocationLockStatus = "false";
					}
					
					updateAndShowProgressIndicator( "success" );
					updateButtonsOnSuccess();
					$("#locationLockCurrent").text( LocationLockStatus );
				}
				
				else
				{
					console.log( "_actLocationLock missing from responseText" );
					updateAndShowProgressIndicator( "error" );
					updateButtonsOnFailure();
				}
			}
		
			else
			{
				// Failure has occurred. Read failure reason.
				if( !( "_failReason" in LocationLockUpdateResponse ) ||
					(typeof LocationLockUpdateResponse._failReason  !== "string" ) )
				{
					console.log( "Invalid _actLocationLockUpdate response; missing failure reason" );
					updateAndShowProgressIndicator( "error" );
					updateButtonsOnFailure();
					return;
				}

				console.log( "Location lock update failure reason: " + LocationLockUpdateResponse._failReason );

				if( LocationLockUpdateResponse._failReason === "invalidSession" )
				{
					updateAndShowProgressIndicator( "warning" , "Session expired" );

					// User session has expired.
					window.alert( "Session has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}

				if( LocationLockUpdateResponse._failReason === "invalidSecurityToken" )
				{
					updateAndShowProgressIndicator( "warning" , "Security Token expired" );
					$( "[name='locationLockUpdate']" ).parent().next().removeClass( "disabled" );

					// User session has expired.
					window.alert( "Security token has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}
				
				// Procedure failed.
				updateAndShowProgressIndicator( "error" );
				updateButtonsOnFailure();
			}
		}
		
		else if( xmlHttp.readyState == 4 )
		{
			// HTTP level failure has occurred.
			console.log( "Failed to receive LocationLockUpdateResponse from server" );
			updateAndShowProgressIndicator( "error" );
			updateButtonsOnFailure();
		}
	}

	var updateAndShowProgressIndicator = function( stepName , displayText )
	{
		// displayText argument is "optional". Expected to be explicitly passed
		// by calling function for info and warning step indicators.
		if( typeof displayText === "undefined" )
		{
			switch( stepName )
			{
				case "current":
					displayText = "Performing operation";
					break;
                               
				case "error":
					displayText = "Operation failed";
					break;
                               
				case "success":
					displayText = "Update successful";
					break;
                               
				default:
					// Explicit display text should have been provided.
					console.log( "Unrecognized step: " + stepName );
					return;
			}
		}

		var classList = "step " + stepName;

		$( "#locationLockProgressIndicator" )
			.removeClass()
			.addClass( classList )
			.find( ".text" ).text( displayText ).end()
			.show();
	}

	var updateButtonsOnSuccess = function()
	{
		var $closeButton = $( "#locationLockCloseButton" );
		$closeButton.removeClass( "disabled" );
		$closeButton.addClass( "call-to-action" ).find( ".button-content" ).text( "Close" );;
		$( "#locationLockStartButton" ).removeClass( "call-to-action" ).addClass( "disabled" ).hide();
		$( "[name='locationLockUpdate']" ).parent().next().removeClass( "disabled" );
	}

	var updateButtonsOnFailure = function()
	{
		var $closeButton = $( "#locationLockCloseButton" );
		var $startButton = $( "#locationLockStartButton" ).hide();
		$startButton.removeClass( "disabled" );
		$closeButton.removeClass( "disabled" ).find( ".button-content" ).text( "Close" );
		$closeButton.addClass( "call-to-action" );
		$( "[name='locationLockUpdate']" ).parent().next().removeClass( "disabled" );
	}

	var flipRadioSelection = function()
	{
		var $current_radio = $(".radiobutton-container[name='locationLockUpdate'] .checked").removeClass("checked");
		$("#locationLockDialog").find(".radiobutton").not($current_radio).addClass("checked");	
		var $current_html = $("input[name='locationLockUpdate']:checked").removeAttr('checked');
		$("input[name='locationLockUpdate']").not($current_html).attr("checked", true);
	}
} ) ( jQuery )