// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		Logout.js
//
// ****************************************************************************

var xmlHttpLogout;

NSNReady( function () {

	$( "#logoutLink" ).click( logoutSubmit );
});


function logoutSubmit()
{
	// Remove menu panel
	$( "#menuPanel" ).slideUp( "slow", function() {

		// Remove any open dialogs.
		$( ".dialog" ).trigger( "close" );

		// Close any open display panel(s) in the content area.
		$( ".content-display-panel" ).trigger( "closePanel" );
	});

	$( document ).trigger( "stopLinkManagement" );

	try
	{
		xmlHttpLogout = new XMLHttpRequest();
		
		// Register event listener for response
		xmlHttpLogout.addEventListener( "readystatechange", processLogoutResponse, false );
		
		// POST information to server
		xmlHttpLogout.open( "GET", "cgi-bin/LogoutHandler.php", true );
		
		xmlHttpLogout.send();
	}
	catch( exception )
	{
		window.alert( "Logout Failed" );
	}
}

function processLogoutResponse()
{
	if( (xmlHttpLogout.readyState == 4) && (xmlHttpLogout.status == 200) )
	{	
		// console.log( "Logout response: " + xmlHttpLogout.responseText );
		
		// Received response from server. Check the result.
		var logoutResponse = parseInt( xmlHttpLogout.responseText );
		
		if( (logoutResponse !== NaN) && (logoutResponse > 0) )
		{
			// Logout successful. Open login page with logout indication.
			location.assign( "login.php?logout" );
			return;
		}
		else
		{	
			window.alert( "Logout failed" );
		}
	}
}

