// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		Preload.js
//
// ****************************************************************************

( function( $ )
{

	var INIT_DELAY = 1000;
	var IMAGE_DIR = "/OceanTouch/images/";

	// List of images to preload. These are background images that are not immediately
	// displayed on the index page.
	var IMAGES = [
		"alert-icons.png",
		"bubble.png",
		"buttons.png",
        "checkboxes.png",
		"dialog-header.png",
		"dialog-header-background.png",
		"dialog-white-noise.png",
		"icon-close.png",
		"icon-list.png",
		"icons.png",
		"panel-white.png",
		"pulldowns.png",
		"radiobuttons.png",
		"spinner.gif",
		"standard-table.png",
		"textareas.png",
		"textinputs.png",
		"textinput-states.png",
		"tooltip.png"
	];


	NSNReady( function()
	{
		// Preload background images so that they are available even if connectivity
		// to server is lost. This is especially important for the link loss dialog
		// which is shown on loss of connection.
		setTimeout( preloadImages, INIT_DELAY );
	});


	var preloadImages = function()
	{
		var img = new Array();

		for( var i = 0; i < IMAGES.length; i++ )
		{
			var imageUrl = IMAGE_DIR + IMAGES[i];

			// Preload into cache.
			img[i] = new Image();
			img[i].src = imageUrl;
		}
	}

})( jQuery )
