// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		ResetSite.js
//
// ****************************************************************************

( function( $ )
{

   var xmlHttp;
NSNReady(function ()
{

    // Add event listener for reset site link.
    $( "#resetSiteLink" ).click( function() 
     {
	    
         var $resetSiteDialog = $("#resetSiteDialog");
         if( $resetSiteDialog.is(":visible"))
         {
            // Dialog window already open
            return;
         }

         // Initial settings. Progress indication is shown once reset operation
	 // is initiated. The close button is initially labeled Cancel to indicate the
         // user can close the dialog window without starting the procedure. The label
         // is changed to Close once the operation is complete.
         $("#resetSiteProgressIndicator").hide();
         $("#resetSiteConfirm").find(".button-content" ).text( "Confirm" );
         $("#resetSiteConfirm").removeClass( "disabled" ).addClass("call-to-action").show();

         var $cancelButton = $("#resetSiteCancel");
         $cancelButton.removeClass("disabled");
         $cancelButton.removeClass("call-to-action");
         $cancelButton.find(".button-content" ).text( "Cancel" );
         $( "#resetSiteErrorDescription" ).hide().prev().removeClass( "ruled" );

         $( "#resetSiteDialog" ).trigger( "open" );	

         // Set focus to confirm button once dialog has opened.
         setTimeout( function()
         {
             $( "#resetSiteConfirm" ).focus();
         }, 100 );

         // Event listener for confirm button 
         $( "#resetSiteConfirm" ).click( function() 
         {
            if( $( this ).is( ".disabled" ) )
            {
               return;
            }
	      
            $cancelButton.addClass("disabled");
            $( this ).addClass( "disabled" );
            updateAndShowProgressIndicator( "current" );
            $( "#resetSiteErrorDescription" ).hide().prev().removeClass( "ruled" );
            sendSiteResetRequest();        
         });
					    
         $cancelButton.click(function()
         {
            if( $( this ).is( ".disabled" ) )
            {
               return;
            }
		
            // Close the dialog window.
            $resetSiteDialog.trigger( "close" );
     });

         $( "#blockDialog" ).bind( "close", function()
         {
            // Stop any ongoing request.
            // Note, the dialog window itself is closed by handler in webuiDialogs.js
            if( typeof xmlHttp !== "undefined" )
            {
               xmlHttp.removeEventListener( "readystatechange", processResetRequestResponse, false );
               xmlHttp.abort();
            }
         });

      });
   });

    var sendSiteResetRequest = function()
    {
	  var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();

      // Create and send XMLHttpRequest to server.
      try
      {
         xmlHttp = new XMLHttpRequest();		
         // Register event listener for response
         xmlHttp.addEventListener( "readystatechange", processResetRequestResponse, false );
         var url = "cgi-bin/ResetSite.php";
	    
		 var csrfTokenEncoded = encodeURIComponent( csrfToken );
		  // FZM/FZAP reset have antModId of 0
		 var postData = "&antModId=0" + "&ctkn=" + csrfTokenEncoded;
		 // GET information asynchronously from server
         xmlHttp.open( "POST", url, true );
		 // Set encoding used for the request body (HTML form) and length of contents.
		 xmlHttp.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
		 xmlHttp.setRequestHeader( "Content-length", postData.length );

         xmlHttp.send(postData);
      }
      catch( exception )
	  {
         console.log( "Asynchronous reset request failed" );

         updateAndShowProgressIndicator( "error" );
         updateButtonsOnFailure();
         return;
      }
   }
        
    var processResetRequestResponse = function()
    {
       if( (xmlHttp.readyState == 4) && (xmlHttp.status == 200) )
          {
          var resetRequestResponse;

          try
          {
             resetRequestResponse = JSON.parse(xmlHttp.responseText);                 
          }
          catch (exception)
          {
             // Parsing failure
             console.log( "JSON parsing error in processResetRequestResponse():\n" + exception );
             console.log( xmlHttp.responseText );
            updateAndShowProgressIndicator( "error" );
            updateButtonsOnFailure();
            return;
         }
         
          if(!("statusInd" in resetRequestResponse) ||
              (typeof resetRequestResponse.statusInd !== "string"))
          {
             console.log( "Invalid reset site response; missing status indicator" );
             updateAndShowProgressIndicator( "error" );
            updateButtonsOnFailure();
             return;
          }
          if(resetRequestResponse.statusInd === "Success")
          {
            // Update progress indication.
             updateAndShowProgressIndicator( "success" );
            updateButtonsOnSuccess();

             // Also let link management functionality know that a reset has been
             // initiated (loss of link expected).
             $( document ).trigger( "resetInitiated" );

          }
          else
          {
             if( !("_failReason" in resetRequestResponse) ||
                  (typeof resetRequestResponse._failReason !== "string") )
             {
                console.log( "Invalid reset response; missing failure reason" );
                updateAndShowProgressIndicator( "error" );
                updateButtonsOnFailure();
                return;
             }

             console.log("Reset req failure reason: " + resetRequestResponse._failReason);
             
             if(resetRequestResponse._failReason === "invalidSession"){

                updateAndShowProgressIndicator( "warning", "Session expired" );

                // User session has expired.
                window.alert( "Session has expired - Please login again" );

                // Open login page with session expired indication.
                location.assign( "login.php?expired" );
                return;
             }

             if(resetRequestResponse._failReason === "invalidSecurityToken")
				{
				 updateAndShowProgressIndicator( "warning", "Security Token expired" );

				 // User session has expired.
				 window.alert( "Security token has expired - Please login again" );

				 // Open login page with session expired indication.
				 location.assign( "login.php?expired" );
				 return;
				}


             if(resetRequestResponse._failReason === "busy")
             {
               updateAndShowProgressIndicator( "error", "Site busy");
               $("#resetSiteConfirm").removeClass( "disabled" ).show();
               $( "#resetSiteErrorDescription" ).show().prev().addClass( "ruled" );
               updateButtonsOnBusy();
             }
             // Procedure failed.
             else
             {
               updateButtonsOnFailure();
               updateAndShowProgressIndicator( "error" );
             }
         }
      }
      else if( xmlHttp.readyState == 4 )
      {
          // HTTP level failure has occurred.
          console.log( "Failed to receive reset response from server" );

          // Update progress indication.
          updateAndShowProgressIndicator( "error" );
          updateButtonsOnFailure();
      }
   }
    var updateAndShowProgressIndicator = function( stepName, displayText )
    {
       // displayText argument is "optional". Expected to be explicitly passed
       // by calling function for info and warning step indicators.
       if( typeof displayText === "undefined" )
       {
          switch( stepName )
          {
          case "current":
             displayText = "Performing operation";
             break;

          case "error":
             displayText = "Operation failed";
             break;

          case "success":
            displayText = "Reset initiated";
             break;

          default:
             // Explicit display text should have been provided.
             console.log( "Unrecognized step: " + stepName );
             return;
          }
       }

       var classList = "step " + stepName;

       $( "#resetSiteProgressIndicator" )
       .removeClass()
       .addClass( classList )
       .find( ".text" ).text( displayText ).end()
       .show();
    }
    

   var updateButtonsOnSuccess = function()
   {

      var $cancelButton = $("#resetSiteCancel");
      $cancelButton.removeClass( "disabled" );
      $cancelButton.addClass( "call-to-action" );
      $cancelButton.find( ".button-content" ).text( "Close" );
      $cancelButton.focus();
      $("#resetSiteConfirm").removeClass("call-to-action" ).addClass("disabled").hide();
   }
   var updateButtonsOnBusy = function()
   {
      var $cancelButton = $("#resetSiteCancel");
      $cancelButton.removeClass( "disabled" );
      $cancelButton.removeClass( "call-to-action" );
      $cancelButton.find( ".button-content" ).text( "Close" );
      $("#resetSiteConfirm").addClass("call-to-action" )
                            .removeClass("disabled")
                            .find(".button-content" )
                            .text( "Retry" ).end()
                            .focus();
   }
   var updateButtonsOnFailure = function()
   {
      var $cancelButton = $("#resetSiteCancel");
      $cancelButton.removeClass( "disabled" );
      $cancelButton.find( ".button-content" ).text( "Close" );
      $("#resetSiteConfirm").addClass("disabled").hide();
      $cancelButton.addClass( "call-to-action" );
      $cancelButton.focus();
   }

})( jQuery )
