<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	FailureResponse.php
//
// Description:	Helper class for returning failure indication. Used in cases
//		where the client is expecting a response in the form of a JSON
//		object but no data is available to send (e.g., due to messaging
//		related failures).
//
// ****************************************************************************

class FailureResponse
{
	// All member attributes are public to allow JSON encoding without
	// explicit serialization.
	public $statusInd;
	public $_failReason;

	// Constructor
	public function __construct( $_failReason )
	{
		// This class is only used for returning failure indication.
		// Status always set to Failure.
		$this->statusInd = "Failure";
		$this->_failReason = $_failReason;
	}

	public static function SendFailureResponse( $_failReason )
	{
		$response = new FailureResponse( $_failReason );

		if( !is_null( $response ) )
		{
			// Encode as JSON.
			$jsonString = json_encode( $response );

			if( $jsonString !== false )
			{
				// Output failure response.
				echo $jsonString;
			}
		}

		// Not handling additional (compound) failures in this function.
		// No response sent in case failure to new up object or JSON
		// encoding failure.
	}
}

?>
