<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	SessionHelper.php
//
// Description:	Helper class for user session validation. Validation is done by
//		sending validation request to the WebUIAgent C++ process.
//
// ****************************************************************************

include_once "MessageHandler.php";
include_once "XmlMessageParser.php";
include_once "messages/ValidateSessionRequest.php";
include_once "messages/ValidateSessionResponse.php";

class SessionHelper
{
	// Return codes
	const SESSION_VALID = 1;
	const SESSION_INVALID = 2;
	const SESSION_FAILURE = 3;

	public static function ValidateSession( $sessionId)
	{
		$validateSessionRequest = new ValidateSessionRequest( $sessionId);
		if( is_null( $validateSessionRequest ) )
		{
			syslog( LOG_ERR, "Failed to allocate memory for ValidateSessionRequest message" );
			return self::SESSION_FAILURE;
		}

		// Send message. The MessageHandler will wait for and return the response, if any.
		$response = MessageHandler::SendAndReceive( $validateSessionRequest->XmlMsg() );
		if( is_null( $response ) )
		{
			syslog( LOG_ERR, "Failed to send ValidateSessionRequest message and/or receive response" );
			return self::SESSION_FAILURE;
		}

		$msg = XmlMessageParser::ParseMsg( $response );

		if( (is_null( $msg )) || ($msg->OK() !== true) || ($msg->GetMessageType() !== "ValidateSessionResponse") )
		{
			// Remove line breaks from response string and print to syslog.
			$msgString = str_replace( "\n", null, $response );
			syslog( LOG_ERR, "Invalid or null ValidateSessionResponse message: " . $msgString );

			return self::SESSION_FAILURE;
		}


		// Received a valid response from the WebUIAgent. Status = Success indicates valid session.
		if( $msg->GetStatus() === "Success" )
		{
			return  self::SESSION_VALID;
		}

		return self::SESSION_INVALID;
	}
}

?>
