<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	AcceptedMessage.php
//
// Description:	Source file for the AcceptedMessage class. This is the base
//		class for any message that can be received from the WebUIAgent.
//
// ****************************************************************************

include_once "WebuiXmlMessage.php";

abstract class AcceptedMessage extends WebuiXmlMessage
{
	// Constructor
	public function __construct()
	{
		// Invoke parent constructor (not done automatically in PHP!).
		parent::__construct();

		// Also set okay flag to indicate whether parsing of an accepted
		// message was successful or not.
		$this->okFlag = false;
	}

	public function OK()
	{
		return $this->okFlag;
	}

	// Abstract prototype that must be implemented by any child message
	abstract protected function Parse( SimpleXMLElement $sxe );

	// Attribute(s)
	protected $okFlag;
}

?>
