<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	BlockingStateChangeRequest.php
//
// Description:	Source file for the BlockingStateChangeRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class BlockingStateChangeRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;  
		$this->cgiSecurityToken = $cgiSecurityToken;
		$this->_antModId = "0";
		$this->_blockingState = "";
	}


	// Accessor(s) and mutator(s)
	public function SetAntModId( $_antModId )
	{
		$this->_antModId = $_antModId;
	}

	public function SetBlockingState( $_blockingState )
	{
		$this->_blockingState = $_blockingState;
	}

	public function GetBlockingState()
	{
		return $this->_blockingState;
	}


	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<BlockingStateChangeRequest>\n";
		$msgString .= "<_antModId>" . $this->_antModId . "</_antModId>\n";
		$msgString .= "<_blockingState>" . $this->_blockingState . "</_blockingState>\n";
		$msgString .= "</BlockingStateChangeRequest>\n";

		return $msgString;
	}

	// Private data member(s)
	private $_antModId;
	private $_blockingState;
}

?>
