<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ConfigureSiteIdRequest.php
//
// Description:	Source file for the ConfigureSiteIdRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class ConfigureSiteIdRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;
		$this->cgiSecurityToken = $cgiSecurityToken;
		$this->siteId = "";
	}


	// Accessor(s) and mutator(s)

	public function SetSiteId( $siteId )
	{
		$this->siteId = $siteId;
	}

	public function GetSiteId()
	{
		return $this->siteId;
	}

	// Member function(s).
	protected function BuildMessageBody()
	{
		// Escape special characters in message string that could cause
		// XML parsing to fail.
		$siteIdEncoded = htmlspecialchars( $this->siteId );

		$msgString = "";
		$msgString .= "<ConfigureSiteIdRequest>\n";
		$msgString .= "<_siteId>" . $siteIdEncoded . "</_siteId>\n";
		$msgString .= "</ConfigureSiteIdRequest>\n";

		return $msgString;
	}

	// Private data member(s)
	private $siteId;
}

?>
