<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ConfigureSiteIdResponse.php
//
// Description:	Source file for the ConfigureSiteIdResponse class.
//
// ****************************************************************************

include_once "AcceptedMessage.php";

class ConfigureSiteIdResponse extends AcceptedMessage
{
	// Constructor
	public function __construct() 
	{
		parent::__construct();

		$this->statusInd = "Invalid";
		$this->failureReason = "None";
	}


	public function Parse( SimpleXMLElement $sxe )
	{
		// Parsing a received message. The passed-in argument should be
		// an already parsed (from XML) SimpleXMLElement representing
		// the message body.

		if( !$sxe )
		{
			syslog( LOG_ERR, "Null XML element in ConfigureSiteIdResponse::Parse()" );
			return;
		}

		$statusPresent = false;

		foreach( $sxe->children() as $node )
		{
			switch( $node->getName() )
			{
				case "statusInd":
					$this->SetStatus( (string)$node );
					$statusPresent = true;
					break;

				case "_failReason":
					$this->failureReason = (string)$node;
					break;

				// Default: ignoring other elements, if any.
			}
		}

		// Verify presence of mandatory element(s).
		if( !$statusPresent )
		{
			// Missing mandatory element.
			syslog( LOG_ERR, "Invalid ConfigureSiteIdResponse message; missing statusInd element" );
			return;
		}


		// Message is valid.
		$this->okFlag = true;
	}


	// Accessor(s) and mutator(s).

	public function SetStatus( $statusInd )
	{
		if( ($statusInd === "Success") || ($statusInd === "Failure") )
		{
			$this->statusInd = $statusInd;
		}
	}

	public function GetStatus()
	{
		return $this->statusInd;
	}

	public function SetFailureReason( $failureReason )
	{
		$this->failureReason = $failureReason;
	}

	public function GetFailureReason()
	{
		return $this->failureReason;
	}



	// Private attribute(s)
	private $statusInd;
	private $failureReason;

}

?>
