<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	CreatedMessage.php
//
// Description:	Source file for the CreatedMessage class. Base class for any
//		messages that can be sent to the WebUIAgent C++ process.
//
// ****************************************************************************

include_once "WebuiXmlMessage.php";

abstract class CreatedMessage extends WebuiXmlMessage
{
	// Constructor -- does nothing except invoke parent constructor (not done
	// automatically in PHP!).
	public function __construct()
	{
		parent::__construct();
	}


	public function XmlMsg()
	{
		$msg  = "<?xml version=\"1.0\"?>\n";
		$msg .= "<CGIMessage>\n";
		$msg .= "<CGIMessageHdr>\n";

		// Escape special characters in message strings that could cause
		// XML parsing to fail.
		$sessionIdEncoded = htmlspecialchars( $this->sessionId );
		$cgiSecurityTokenEncoded = htmlspecialchars( $this->cgiSecurityToken );

		// Note: Session ID will be empty "" in messages (if any) where a
		// valid session ID is not available.
		$msg .= "<sessionId>" . $sessionIdEncoded . "</sessionId>\n";
		$msg .= "<CGISecurityToken>" . $cgiSecurityTokenEncoded . "</CGISecurityToken>";
		$msg .= "</CGIMessageHdr>\n";

		// Invoke method on child class to build message body.
		$msg .= $this->BuildMessageBody();

		$msg .= "</CGIMessage>\n";
		return $msg;
	}

	// Abstract prototype that must be implemented by any child message
	abstract protected function BuildMessageBody();
}

?>
