<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	LocationLockUpdateRequest.php
//
// Description:	Source file for the LocationLockUpdateRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class LocationLockUpdateRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId,$cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;
		$this->cgiSecurityToken = $cgiSecurityToken;  
		// Set default value.
		$this->_actLocationLock = "true";
	}


	public function SetactLocationLock( $locationLockUpdate )
	{
		$this->_actLocationLock = $locationLockUpdate;
		// Currently "locked" and "unlocked" are the only values supported.
		if( ($locationLockUpdate == "true") || ($_locationLockUpdate == "false") )
		{
			if( $locationLockUpdate == "true")
			{
				$this->_actLocationLock = "true";
			}
			elseif ($locationLockUpdate == "false")
			{
				
				$this->_actLocationLock = "false";
			}
		}
	}

	public function GetactLocationLock()
	{
		return $this->_actLocationLock;
	}


	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<LocationLockUpdateRequest>\n";
		$msgString .= "<_actLocationLock>" . $this->_actLocationLock . "</_actLocationLock>\n";
		$msgString .= "</LocationLockUpdateRequest>\n";

		return $msgString;
	}


	private $_actLocationLock;
}

?>
