<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	LoginResponse.php
//
// Description:	Source file for the LoginResponse class.
//
// ****************************************************************************

include_once "AcceptedMessage.php";

class LoginResponse extends AcceptedMessage
{
	// Constructor
	public function __construct() 
	{
		parent::__construct();

		$this->statusInd = "Invalid";
		$this->failureReason = "None";
		$this->hasLoginHistory = false;
		$this->_lastSuccessfulLoginTimeOnBts = "";
		$this->_lastSuccessfulLoginTimeOnNetwork = "";
		$this->_failedCountSinceLastSuccessOnBts = 0;
		$this->_failedCountSinceLastSuccessOnNetwork = 0;
	}


	public function Parse( SimpleXMLElement $sxe )
	{
		// Parsing a received message. The passed-in argument should be
		// an already parsed (from XML) SimpleXMLElement representing
		// the message body.

		if( !$sxe )
		{
			syslog( LOG_ERR, "Null XML element in LoginResponse::Parse()" );
			return;
		}

		$statusPresent = false;

		foreach( $sxe->children() as $node )
		{
			switch( $node->getName() )
			{
				case "statusInd":
					$this->SetStatus( (string)$node );
					$statusPresent = true;
					break;

				case "_failReason":
					$this->failureReason = (string)$node;
					break;

				case "LoginHistory":
					$this->hasLoginHistory = true;
					$this->ParseLoginHistory( $node );
					break;

				// Default: ignoring other elements, if any.
			}
		}

		// Verify presence of mandatory element(s).
		if( !$statusPresent )
		{
			// Missing mandatory element.
			syslog( LOG_ERR, "Invalid LoginResponse message; missing statusInd element" );
			return;
		}


		// Message is valid.
		$this->okFlag = true;
	}


	private function ParseLoginHistory( SimpleXMLElement $loginHistory )
	{
		foreach( $loginHistory->children() as $node )
		{
			switch( $node->getName() )
			{
				case "_lastSuccessfulLoginTimeOnBts":
					$this->_lastSuccessfulLoginTimeOnBts = (string)$node;
					break;

				case "_lastSuccessfulLoginTimeOnNetwork":
					$this->_lastSuccessfulLoginTimeOnNetwork = (string)$node;
					break;

				case "_failedCountSinceLastSuccessOnBts":
					$this->SetFailedCountSinceLastSuccessOnBts( (string)$node );
					break;

				case "_failedCountSinceLastSuccessOnNetwork":
					$this->SetFailedCountSinceLastSuccessOnNetwork( (string)$node );
					break;
			}
		}
	}


	// Accessor(s) and mutator(s).

	public function SetStatus( $statusInd )
	{
		if( ($statusInd === "Success") || ($statusInd === "Failure") )
		{
			$this->statusInd = $statusInd;
		}
	}

	public function GetStatus()
	{
		return $this->statusInd;
	}

	public function SetFailureReason( $failureReason )
	{
		$this->failureReason = $failureReason;
	}

	public function GetFailureReason()
	{
		return $this->failureReason;
	}

	public function HasLoginHistory()
	{
		return $this->hasLoginHistory;
	}

	public function GetLastSuccessfulLoginTimeOnBts()
	{
		return $this->_lastSuccessfulLoginTimeOnBts;
	}

	public function GetLastSuccessfulLoginTimeOnNetwork()
	{
		return $this->_lastSuccessfulLoginTimeOnNetwork;
	}

	private function SetFailedCountSinceLastSuccessOnBts( $valueString )
	{
		$this->_failedCountSinceLastSuccessOnBts = intval( $valueString );
	}

	public function GetFailedCountSinceLastSuccessOnBts()
	{
		return $this->_failedCountSinceLastSuccessOnBts;
	}

	private function SetFailedCountSinceLastSuccessOnNetwork( $valueString )
	{
		$this->_failedCountSinceLastSuccessOnNetwork = intval( $valueString );
	}

	public function GetFailedCountSinceLastSuccessOnNetwork()
	{
		return $this->_failedCountSinceLastSuccessOnNetwork;
	}


	// Private attribute(s)
	private $statusInd;
	private $failureReason;
	private $hasLoginHistory;
	private $_lastSuccessfulLoginTimeOnBts;
	private $_lastSuccessfulLoginTimeOnNetwork;
	private $_failedCountSinceLastSuccessOnBts;
	private $_failedCountSinceLastSuccessOnNetwork;

}

?>
