<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	RTTRequest.php
//
// Description:	Source file for the RTTRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class RTTRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;  
		$this->cgiSecurityToken = $cgiSecurityToken;
		$this->ipAddress = "";
	}


	// Accessor(s) and mutator(s)

	public function SetIpAddress( $ipAddress )
	{
		$this->ipAddress = $ipAddress;
	}

	public function GetIpAddress()
	{
		return $this->ipAddress;
	}

	protected function BuildMessageBody()
	{

		$msgString = "";
		$msgString .= "<RTTRequest>\n";
		$msgString .= "<ipAddress>" . $this->ipAddress . "</ipAddress>\n";
		$msgString .= "</RTTRequest>\n";

		return $msgString;
	}


	// Private data member(s)
	private $ipAddress;
}

?>
