<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	SnapshotDataResponse.php
//
// Description:	Source file for the SnapshotDataResponse class.
//
// ****************************************************************************

include_once "AcceptedMessage.php";

class SnapshotDataResponse extends AcceptedMessage implements JsonSerializable
{

	//---------------------------------------------------------------------
	// Constructor
	//---------------------------------------------------------------------
	public function __construct() 
	{
		parent::__construct();

		$this->statusInd = "Invalid";
		$this->_failReason = "None";
	}


	//---------------------------------------------------------------------
	// jsonSerialize method specified in JsonSerializable interface. Returns
	// a parsed SimpleXMLElement suitable for JSON encoding (all member
	// attributes are public). This method is invoked automatically by calls
	// to the PHP built-in json_encode() function.
	//---------------------------------------------------------------------
	public function jsonSerialize()
	{
		if( $this->parsedSimpleXMLElement )
		{
			return $this->parsedSimpleXMLElement;
		}
		else
		{
			// Means the message has not been parsed or it was invalid.
			// JSON encoding should not have been invoked. Encode failure
			// indication.
			$outputArray = array(
				"statusInd" => "Failure",
				"_failReason"  => "SnapshotDataResponse::jsonSerialize(): invalid message"
			);

			return $outputArray;
		}
	}


	//---------------------------------------------------------------------
	// Parse() member function. Parses a received message. The passed-in
	// argument should be an already parsed (from XML) SimpleXMLElement
	// representing the message body.
	//---------------------------------------------------------------------
	public function Parse( SimpleXMLElement $sxe )
	{
		if( !$sxe )
		{
			syslog( LOG_ERR, "Null XML element in SnapshotDataResponse::Parse()" );
			return;
		}

		$statusPresent = false;
		if( $sxe->statusInd )
		{
			$this->SetStatus( (string)($sxe->statusInd) );
			$statusPresent = true;
		}

		if( $sxe->_failReason )
		{
			$this->_failReason = (string)($sxe->_failReason);
		}

		// Not parsing the file name element if included. Will be
		// processed by the client.

		// Verify presence of mandatory element(s).
		if( !$statusPresent )
		{
			// Missing mandatory element.
			syslog( LOG_ERR, "Invalid SnapshotDataResponse message; missing statusInd element" );
			return;
		}

		// Message is valid.
		$this->okFlag = true;

		// Regardless of success or failure, store off the raw, parsed SimpleXMLElement.
		// It will be JSON encoded and sent to the client.
		$this->parsedSimpleXMLElement = $sxe;
	}


	//---------------------------------------------------------------------
	// Accessor(s) and mutator(s).
	//---------------------------------------------------------------------

	public function SetStatus( $statusInd )
	{
		if( ($statusInd === "Success") || ($statusInd === "InProgress") || ($statusInd === "Failure") )
		{
			$this->statusInd = $statusInd;
		}
	}

	public function GetStatus()
	{
		return $this->statusInd;
	}

	public function SetFailureReason( $_failReason )
	{
		$this->_failReason = $_failReason;
	}

	public function GetFailureReason()
	{
		return $this->_failReason;
	}



	//---------------------------------------------------------------------
	// Private attribute(s)
	//---------------------------------------------------------------------

	private $statusInd;
	private $_failReason;
	private $parsedSimpleXMLElement;

}

?>
