<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ValidateSessionResponse.php
//
// Description:	Source file for the ValidateSessionResponse class.
//
// ****************************************************************************

include_once "AcceptedMessage.php";

class ValidateSessionResponse extends AcceptedMessage
{
	// Constructor
	public function __construct()
	{
		// Invoke parent constructor (not done automatically in PHP).
		parent::__construct();

		$this->statusInd = "Invalid";
		$this->username = "";
		$this->csrfToken = "";
	}


	public function Parse( SimpleXMLElement $sxe )
	{
		// Parsing a received message. The passed-in argument should be
		// an already parsed (from XML) SimpleXMLElement representing the
		// message body.

		if( !$sxe )
		{
			syslog( LOG_ERR, "Null XML element in ValidateSessionResponse::Parse()" );
			return;
		}

		$statusPresent = false;
		foreach( $sxe->children() as $node )
		{
			switch( $node->getName() )
			{
				case "statusInd":
					$this->SetStatus( (string)$node );
					$statusPresent = true;
					break;

				case "_userName":
					$this->username = (string)$node;
					break;
				
				case "CGISecurityToken":
					$this->csrfToken = (string)$node;
					break;

				// Default: ignoring other elements, if any.
			}
		}

		// Check for presence of mandatory element(s).
		if( !$statusPresent )
		{
			// Missing mandatory element.
			syslog( LOG_ERR, "Invalid ValidateSessionResponse message; missing statusInd element" );
			return;
		}


		// Message is valid.
		$this->okFlag = true;
	}


	// Accessor(s) and mutator(s).

	public function SetStatus( $statusInd )
	{
		if( ($statusInd === "Success") || ($statusInd === "Failure") )
		{
			$this->statusInd = $statusInd;
		}
	}

	public function GetStatus()
	{
		return $this->statusInd;
	}

	public function SetUserName( $username )
	{
		$this->username = $username;
	}

	public function GetUserName()
	{
		return $this->username;
	}

	public function GetCsrfToken()
	{
	  return $this->csrfToken;
	}

	// Private attribute(s)
	private $statusInd;
	private $username;
	private $csrfToken;
}

?>
