<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	WebuiXmlMessage.php
//
// Description:	Source file for the WebuiXmlMessage class. Base class for all
//		Created and Accepted messages that can be sent/received to/from
//		the WebUIAgent C++ process.
//
// ****************************************************************************

abstract class WebuiXmlMessage
{
	// Constructor
	public function __construct()
	{
		$this->sessionId = "";
                $this->cgiSecurityToken ="";
	}


	public function GetMessageType()
	{
		// PHP get_class() API returns the name of the instantiated
		// object when called with $this argument; i.e., the child
		// class (if invoked with empty argument: base class).
		return get_class( $this );
	}

	public function GetSessionId()
	{
		return $this->sessionId;
	}

	public function SetSessionId( $sessionId )
	{
		$this->sessionId = $sessionId;
	}
	
	public function GetCGISecurityToken()
	{
		return $this->cgiSecurityToken;
	}

	public function SetCGISecurityToken( $cgiSecurityToken )
	{
		$this->cgiSecurityToken = htmlspecialchars($cgiSecurityToken);
	}


	// Class attribute(s).
	protected $sessionId;
	protected $cgiSecurityToken;
}

?>
