#!/bin/bash
##########################################################################
# core_pattern
# |/opt/CCS/coreDispatcher.sh <NodeID> %e %P %s %t %c %h <CoreSize> <CorePath>
# crashHandler is a common name for CCS and RT and the name should not be changed
# crashHandler is called in following parameters:
# crashHandler <NodeID> %e %P %s %t %c <CoreSize> <CorePath>
#-------------------------------------------------------------------------
# Input parameters:
readonly NODEID=$1                 # <NodeID>      NodeID on which the crash occured
readonly PROCPATH=$2               # %E            pathname of executable, with slashes ('/') replaced by exclamation marks ('!')
readonly PID=$3                    # %P            PID of dumped process, as seen in the initial PID namespace (since Linux 3.12)
readonly SIGNALNO=$4               # %s            number of signal causing dump
readonly TIME=$5                   # %t            time of dump, expressed as seconds since the Epoch, 1970-01-01 00:00:00 +0000 (UTC)
readonly SOFTLIMIT=$6              # %c            core file size soft resource limit of crashing process (since Linux 2.6.24)
readonly HOSTNAME=$7               # %h            hostname (for virtual nodes host name indictes virtual nodeId)
readonly CORESIZE=$8               # <CoreSize>    Maximum size of the compressed core file
readonly COREPATH=$9               # <CorePath>    Path where the corefile and bt-coreinfo will be stored
# Binary paths
readonly CRASHHANDLER=/opt/CCS/crashHandler.sh
readonly LXC_SYSROOT_PATH=/tmp/node_${HOSTNAME}
readonly LXC_CRASHHANDLER="${LXC_SYSROOT_PATH}/${CRASHHANDLER}"

#Process name:
readonly PROCNAME="$(basename $(echo "${PROCPATH}" | tr '!' '/'))"

# Debug settings
# DEBUGLOG=/tmp/$(basename "$0").log
#
##########################################################################
main(){
    #    START_TIME=$(date +%s.%N)
    # echo "OWNPID=$$ starting core dispatcher">>$DEBUGLOG
    # echo "NODEID=$NODEID PROCNAME=$PROCNAME SIGNALNO=$SIGNALNO TIME=$TIME SOFTLIMIT=$SOFTLIMIT">>$DEBUGLOG
    # echo "CORESIZE=$CORESIZE COREPATH=$COREPATH HOSTNAME=$HOSTNAME LOCAL_PID=$LOCAL_PID HOST_PID=$HOST_PID ">>$DEBUGLOG
    if [ -e $LXC_CRASHHANDLER ] ; then
            # echo "LXC_CRASHHANDLER Path = $LXC_CRASHHANDLER">>$DEBUGLOG
            $LXC_CRASHHANDLER $HOSTNAME $PROCNAME $PID $SIGNALNO $TIME $SOFTLIMIT $CORESIZE $COREPATH
    else
            # echo "PLATFORM_CRASHHANDLER Path = $CRASHHANDLER">>$DEBUGLOG
            $CRASHHANDLER $NODEID $PROCNAME $PID $SIGNALNO $TIME $SOFTLIMIT $CORESIZE $COREPATH
    fi;
#    END_TIME=$(date +%s.%N)
#    DIFF_TIME=$(echo "$END_TIME - $START_TIME" | bc)
#    echo "core dumping took $DIFF_TIME seconds " >> $DEBUGLOG
 }

# entry point
main

