#!/bin/sh

#This is temporary code to give the read permission to the below file to avoid SmaCertMgr crash
chmod 666 /dev/random
chmod 666 /dev/urandom
chmod 755 /etc/keys.d/private/*

# change umask to 0 to solve problems related to LLPD
umask 0

# enable the possibility to get core files of binaries started from this script
ulimit -c unlimited

# Init script information
INIT_NAME="start_script.conf"

OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"
HWR_DIR="/opt/hwr"
OPT_TRSSHAREDLIBS_DIR="/opt/trssharedlibs"
if [ ! -d "${OPT_TRSSHAREDLIBS_DIR}" ]; then
    OPT_TRSSHAREDLIBS_DIR=''
fi

ENABLE_SSH=/tmp/ssh_enabled
ENABLE_LMP=/tmp/lmp_enabled
ENABLE_SOE=/tmp/soe_enabled
DISABLE_Z3IPSEC=/ffs/run/trs_data/z3ipsec_disabled
TRS_RND_FLAG_CHK_FILE=/tmp/trs_rnd_flag
TRS_FTP_FLAG_CHK_FILE=/tmp/trs_ftp_flag

CCS_CONFIG_FILE="/ffs/run/swconfig.txt"
# 1A is TRS Domain Id and 0020 is TRSW_DBG_ETHSEC_DISABLED Id defined as enum in ERADTRS_MAP in frvob_ukernel/trace/traceCCSPrivate.h file.
TRSW_DBG_ETHSEC_DISABLED="0x1A0020"
# 1A is TRS Domain Id and 0021 is TRSW_FTP_CHECK_FLAG Id defined as enum in ERADTRS_MAP in frvob_ukernel/trace/traceCCSPrivate.h file.
TRSW_FTP_CHECK_FLAG="0x1A0021"
TROUBLESHOOT_MODE="0x1A0023"

# ---------- Dest Path ------------------

TRS_LIB_DEST="${OPT_TRSSHAREDLIBS_DIR}/usr/lib64"
if [ ! -d "${TRS_LIB_DEST}" ]; then
    TRS_LIB_DEST="${OPT_TRSSHAREDLIBS_DIR}/usr/lib"
fi

TRS_BIN_DEST="${OPT_DIR}/bin"
TRS_ETC_DEST="${OPT_DIR}/etc"
# change in directory structure and hence change in the directories path
TRS_DATA="/ffs/run/trs_data"
TRS_ACT_DEST="${TRS_DATA}/active"
TRS_DB_DEST="${TRS_DATA}/db"
TRS_SIM_DEST="${TRS_DATA}/sim"
TRS_PASSIVE_DEST="${TRS_DATA}/passive"
TRS_CORE_DEST="/ffs/run/logs"
TRS_SRV_DEST="${OPT_DIR}/srv"
TRS_PMD_DIR="/ffs/run/logs"

TRS_BOARD_PUB_KEY_PATH="/etc/keys.d/public"

ENCFSPRG=${TRS_BIN_DEST}/changeScenario
ENCFSOPT="-boot"

PROGRAM_ENVINFO="${TRS_BIN_DEST}/test_envInfo"

NETWORKING="${OPT_DIR}/etc/networking"

# Load networking script
[ -f "${NETWORKING}" ] && . "${NETWORKING}"

# get the environment we are running in
#
PROD_WCDMA=1
PROD_WIMAX=2
PROD_LTE_DCM=3
PROD_LTE_WMP=4
PROD_MULTIMODE_DCM=7
PROD_MULTIMODE_WMP=8

is_product_lte_wmp()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"
    ${PROGRAM_ENVINFO} envInfoProductType > /dev/null
    PROD=$?

    if [ $PROD -eq $PROD_LTE_WMP ]; then
        return 1;
    else
        return 0;
    fi
}

# Load init script configuration
[ -f "${TRS_SIM_DEST}/${INIT_NAME}" ] && . "${TRS_SIM_DEST}/${INIT_NAME}"

# RAN2332.12 - LTE623 Feature
# SRN: EncFS support in FSMR3

generateboardkeys()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"

    if [ ! -d $TRS_BOARD_PUB_KEY_PATH ]; then
        mkdir $TRS_BOARD_PUB_KEY_PATH
        cragenbkeyset -i /etc/keys.d/board/unitid.dat -s /etc/keys.d/board/privkey.pem sok sig enc
    fi
}

loadencfs()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"

    $ENCFSPRG $ENCFSOPT
    RET=$?
}

populate_eeprom()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"

    local stringNewProductCode
    local stringNewSerialNumber
    local stringNewUnitType

    stringNewProductCode="$(cat /proc/device-tree/board-identity/product-code)"
    stringNewSerialNumber="$(cat /proc/device-tree/board-identity/serial-number)"
    stringNewUnitType="$(cat /proc/device-tree/board-identity/unit-id)"

    test_hlEeprom setProductCode ${stringNewProductCode} >/dev/null 2>&1
    test_hlEeprom setSerialNumber ${stringNewSerialNumber} >/dev/null 2>&1
    test_hlEeprom setUnitType ${stringNewUnitType} >/dev/null 2>&1
    test_hlEeprom setHWCompatString fzm_k2 >/dev/null 2>&1

}

updateResetCnt()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"

    local cnt
    local thiscnt
    local file
    local keep
    local keepfiles
    local thesefiles
    local deletefiles

    local stringNew
    local stringUnitType
    local stringZ

    mkdir -m 0775 -p /tmp
    (cd "${TRS_ETC_DEST}" && md5sum eeprom0 eeprom1 >/tmp/eeprom.md5sum)
    if [ ! -s "${TRS_DB_DEST}/eeprom.md5sum" ] || ! cmp -s /tmp/eeprom.md5sum "${TRS_DB_DEST}/eeprom.md5sum"; then

        mkdir -m 0775 -p "${TRS_DB_DEST}"
        cp -f "${TRS_ETC_DEST}/eeprom0" "${TRS_DB_DEST}/eeprom0"
        cp -f "${TRS_ETC_DEST}/eeprom1" "${TRS_DB_DEST}/eeprom1"
        cp -f /tmp/eeprom.md5sum "${TRS_DB_DEST}/eeprom.md5sum"

    else
        rm -f /tmp/eeprom.md5sum
    fi

    # populate the eeprom from the board info
    populate_eeprom

    let cnt=$(test_hlEeprom getResetCnt allResets | awk '{print $NF}')
    let thiscnt=$cnt
    let ++cnt
    if [ $cnt -gt 65535 ]; then
        let cnt=0
    fi
    test_hlEeprom setResetCnt allResets $cnt >/dev/null 2>&1

    # create list of files to keep
    let keep=5
    while [ $keep -gt 0 ]; do
        thesefiles="${TRS_PMD_DIR}/TraceLog.${thiscnt}|${TRS_PMD_DIR}/ErrorLog.${thiscnt}|${TRS_PMD_DIR}/CcsLog.${thiscnt}|${TRS_PMD_DIR}/corefiles${thiscnt}.tgz"
        if [ "x$keepfiles" = "x" ]; then
            keepfiles="$thesefiles"
        else
            keepfiles="${keepfiles}|${thesefiles}"
        fi
        let --keep
        let --thiscnt
        if [ $thiscnt -lt 0 ]; then
            let thiscnt=65535
        fi
    done

    # create list of files to delete
    for file in $(ls "${TRS_PMD_DIR}"/TraceLog.* "${TRS_PMD_DIR}"/ErrorLog.* "${TRS_PMD_DIR}"/CcsLog.* "${TRS_PMD_DIR}"/corefiles* 2>/dev/null); do
        eval "case \"\$file\" in
$keepfiles)
;;
*)
deletefiles=\"\$deletefiles '\$file'\"
;;
esac"
    done

    # delete the files
    if [ "x$deletefiles" != "x" ]; then
        eval "rm -f $deletefiles"
    fi
}

prepareTmpFolder()
{
    local dir
    chmod 1777 /tmp

    for dir in /tmp/etc /tmp/ftp /tmp/config /tmp/pmuser/PM/ /tmp/trs/tftpboot; do
        if [ ! -d "$dir" ]; then
            mkdir -p "$dir"
            chmod 777 "$dir"
        fi
    done

    if [ ! -e "/PM" ]; then
        ln -s "/tmp/pmuser/PM" "/PM"
    fi
}

prepareConfFolder()
{
    if [ ! -d "${TRS_DATA}" ]; then
        rm -f "${TRS_DATA}"
        mkdir -m 0775 -p "${TRS_DATA}"
    else
        chmod 0775 "${TRS_DATA}"
    fi

    if [ ! -d "${TRS_ACT_DEST}" ]; then
        rm -f "${TRS_ACT_DEST}"
        mkdir -m 0775 -p "${TRS_ACT_DEST}"
    else
        chmod 0775 "${TRS_ACT_DEST}"
    fi

    if [ ! -d "${TRS_PASSIVE_DEST}" ]; then
        rm -f "${TRS_PASSIVE_DEST}"
        mkdir -m 0775 -p "${TRS_PASSIVE_DEST}"
    else
        chmod 0775 "${TRS_PASSIVE_DEST}"
    fi

    if [ ! -d "${TRS_SIM_DEST}" ]; then
        rm -f "${TRS_SIM_DEST}"
        mkdir -m 0775 -p "${TRS_SIM_DEST}"
    else
        chmod 0775 "${TRS_SIM_DEST}"
    fi

    if [ ! -d "${TRS_DB_DEST}" ]; then
        rm -f "${TRS_DB_DEST}"
        mkdir -m 0775 -p "${TRS_DB_DEST}"
    else
        chmod 0775 "${TRS_DB_DEST}"
    fi

    # RAN2332.12 - LTE623 Feature
    # SRN: This function is called instead of creating keystorage folder
    generateboardkeys

    loadencfs
}

fixObsaiStartup()
{
    local VERSION

    [ -f "${TRS_ACT_DEST}/obsai_conf.xml" ] || cp -f "${TRS_SRV_DEST}/obsai_conf.xml" "${TRS_ACT_DEST}/obsai_conf.xml"

    if [ ! -f "${TRS_ACT_DEST}/swdlBD.xml" ]; then
        VERSION=$(cat "${TRS_SRV_DEST}/targetBD.xml" | grep softwareReleaseVersion|tail -n 1 | FS="\"" awk 'BEGIN { FS = "\"" } ; { print $2 }')
        cp -f "${TRS_SRV_DEST}/targetBD.xml" "${TRS_ACT_DEST}/${VERSION}.xml"
        ln -sf "${VERSION}.xml" "${TRS_ACT_DEST}/swdlBD.xml"
    fi
    if [ ! -f "${TRS_ACT_DEST}/passiveBD.xml" ]; then
        cp -f "${TRS_SRV_DEST}/targetBD.xml" "${TRS_ACT_DEST}/passiveBD.xml"
    fi

}

# configure eth interfaces
configEthIf()
{
    export "LD_LIBRARY_PATH=${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export "PATH=${TRS_BIN_DEST}:$PATH"


    brctl addbr pan0
    ip addr flush dev pan0 label pan0
    ip addr flush dev pan0 label pan0:1
    ip addr flush dev pan0 label pan0:2
    ip addr add 192.168.255.245/29 broadcast 192.168.255.247 dev pan0
    ip addr add 192.168.255.241/29 broadcast 192.168.255.247 dev pan0 label pan0:1
    ip addr add 192.168.255.242/29 broadcast 192.168.255.247 dev pan0 label pan0:2
    ip link set pan0 up
    ########### start of TEMP changes ##########################
    suppressLinkLevelAutoconfTraffic all default
    disableIPv6RouterAutoconfiguration all default eth0
    disableIPv6
    ip link set eth0 down
    echo 0 > /sys/devices/virtual/cpld-usr/cpld-usr/bh_phy_reset
    ip link set eth0 up
    ########## end of TEMP changes until PS_REL fixes it ######

## for dual bridge feature: make eth0 bridged into br0, later if needed eth1 will be bridged in for bridge config.

    brctl addbr br0
    brctl addif br0 eth0
    ifconfig br0 0.0.0.0 up
    brctl setageing br0 600

    # enable the R&D service ETH ports if the R&D flag is set.
    value=$(${CCS_DIR}/evaluateRadParam  $TRSW_DBG_ETHSEC_DISABLED $CCS_CONFIG_FILE)
    result=$?

    # We check if the TRS R&D flag exists and it is set to 1
    #echo "result =  $result , value  = $value"

    if [ $result -eq 0 ]; then
        # SOE = 0, LMP open, R&D+SSH open

        touch $TRS_RND_FLAG_CHK_FILE
        echo "!!!R&D PORT FLAG IS SET!!!"

        # SOE = 0
        if [ -f $ENABLE_SOE ]; then
            rm -f $ENABLE_SOE
            echo "!!!SOE = 0!!!"
        fi

        touch $ENABLE_SSH
        echo "!!!SSH = 1!!!"

    else
        echo "!!!R&D PORT FLAG IS NOT SET!!!"
        echo ".$TRSW_DBG_ETHSEC_DISABLED. not found"

        if [ -f $TRS_RND_FLAG_CHK_FILE ]; then
            rm -f $TRS_RND_FLAG_CHK_FILE
            echo "!!!RND = 0!!!"
        fi

        touch $ENABLE_SOE
        echo "!!!SOE = 1!!!"

        touch $ENABLE_LMP

        if [ -f $ENABLE_SSH ]; then
            rm -f $ENABLE_SSH
        fi
    fi

    # enable the FTP Service if FTP flag is set to 1
    value=$(${CCS_DIR}/evaluateRadParam  $TRSW_FTP_CHECK_FLAG $CCS_CONFIG_FILE)
    result=$?

    # We check if the FTP flag exists and it is set to 1
    #echo "result =  $result , value  = $value"

    if [ $result -eq 0 ]; then
     #enable the FTP Service
        touch $TRS_FTP_FLAG_CHK_FILE
        echo "!!!FTP Enable FLAG is Set!!!"

    else
        echo "!!!FTP Enable FLAG is NOT SET!!!"

        if [ -f $TRS_FTP_FLAG_CHK_FILE ];then
            rm -rf $TRS_FTP_FLAG_CHK_FILE
            echo "!!!FTP = 0!!!"
        fi
    fi

    ### SFN MASTER CASE
    rm -rf $DISABLE_Z3IPSEC
    value=$(${CCS_DIR}/evaluateRadParam  $TROUBLESHOOT_MODE $CCS_CONFIG_FILE)
    result=$?
    if [ "$result" == "0" ]; then
    if [ "$value" == "0x00000000" ]; then
     #Troubleshoot mode set to 0 - Enabled ipsec on Z3
        echo "!!!Z3 IPSEC Enabled!!!" 
    else                                              
     #Troubleshoot mode set to 1 - Disable ipsec on Z3
        touch $DISABLE_Z3IPSEC
        if [ $? != 0 ];then
            echo "!!!Z3 IPSEC Disabling Failure!!!"
        else
            echo "Creating $DISABLE_Z3IPSEC Success"
            chmod 744 $DISABLE_Z3IPSEC
            if [ $? != 0 ];then
               echo "changing File permission Failed.Z3 IPSEC Disabling may Fail"
            else
                echo "!!!Z3 IPSEC Disabled!!!" 
            fi
        fi
    fi                                
    fi  
 
    # For testing in the lab environment always enable ssh on lmp
    case "${BTSOM_SIMULATED}${TEST_ADAPTER}" in
        *yes*|*y*|*YES*|*Y*)
            touch $ENABLE_SSH
            echo "!!!SSH = 1!!!"
            ;;
    esac

    $OPT_DIR/S02iptables restart system 2>/dev/null

    if [ $result -eq 0 ]; then
        # Configure LMP Interface using trswStartup_init binary
#         echo "Config lmp using trswStartup_init"
#         ${TRS_BIN_DEST}/trswStartup_init 2 3
        echo "!!!LMP OPENED!!!"
    fi

    # do not start secure mode
    chmod a+x ${TRS_ETC_DEST}/set_secure_mode
    ${TRS_ETC_DEST}/set_secure_mode init
    ${TRS_ETC_DEST}/set_secure_mode 0

    suppressLinkLevelAutoconfTraffic eth1
    disableIPv6RouterAutoconfiguration all default eth0
    disableIPv6RouterAutoconfiguration all default br0
    forceMLDversion 2 all default eth0

    echo 1  > /proc/sys/net/ipv4/conf/eth0/forwarding
    echo 1  > /proc/sys/net/ipv4/conf/lo/forwarding

    echo 255 > /proc/sys/net/ipv4/ip_default_ttl
    echo 255 > /proc/sys/net/ipv6/conf/all/hop_limit
    echo 255 > /proc/sys/net/ipv6/conf/default/hop_limit
    echo 255 > /proc/sys/net/ipv6/conf/eth0/hop_limit
    echo 1 > /proc/sys/net/ipv6/ip6frag_time
    echo 1 > /proc/sys/net/ipv4/ipfrag_time

    echo 0  >/proc/sys/net/ipv6/conf/all/accept_redirects
    echo 0  >/proc/sys/net/ipv6/conf/eth0/accept_redirects
    echo 0  >/proc/sys/net/ipv6/conf/br0/accept_redirects
    #Disabling mcast snooping for LTE 1117-H MBMS
    echo 0 > /sys/devices/virtual/net/br0/bridge/multicast_snooping
    # Added to support new DA design for MREC . Secondary IP should be promoted
    # to primary IP when primary ip gets deleted.
#     echo 1 > /proc/sys/net/ipv4/conf/all/promote_secondaries
}

setsockoptions()
{
    echo "Set Recive & Send socket buffer size for TCP /UDP"
    echo 524288 > /proc/sys/net/core/wmem_max
    echo 262144 > /proc/sys/net/core/wmem_default
    echo 524288 > /proc/sys/net/core/rmem_max
    echo 262144 > /proc/sys/net/core/rmem_default
}

releaseCores()
{
    echo "Releasing cores  "
#     echo 0 > /sys/devices/system/cpu/cpu1/online
#     echo 0 > /sys/devices/system/cpu/cpu2/online
#     echo 0 > /sys/devices/system/cpu/cpu3/online
#     echo 0 > /sys/devices/system/cpu/cpu4/online
#     echo 0 > /sys/devices/system/cpu/cpu5/online
#     echo 0 > /sys/devices/system/cpu/cpu6/online
#     echo 0 > /sys/devices/system/cpu/cpu7/online
}

loadKmodules()
{
    # This kernel is necessary if we need VTC
    echo "Loading iwf.ko ..."
    insmod ${TRS_BIN_DEST}/iwf.ko
    # IPSec related kernel modules
    insmod ${TRS_BIN_DEST}/hplibmod.ko
    modprobe xfrm_algo
    insmod ${TRS_BIN_DEST}/ipsecmgr_mod.ko
}

loadStartSe()
{
    export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib:/lib:$LD_LIBRARY_PATH"
    export PATH="${TRS_BIN_DEST}:$PATH"

    echo 2 > /proc/sys/net/ipv4/tcp_mtu_probing

    ${PROGRAM_ENVINFO} envInfoProductType >/dev/null 2>&1
    help=$?
    if [ $help -eq 4 ]; then
        echo "LTE: loading IP SE on cpu4..5"
#         ${TRS_BIN_DEST}/trswStartup_init 1 2
    fi

    sleep 1
}

enableEthPorts()
{
    local enableports

    enableethports=0

    # in case test adapter mode is used
    case "${TEST_ADAPTER}" in
        yes|y|YES|Y)
            enableethports=1
            ;;
    esac

    if [ "x${START_TRSSW}" = "x" ]; then
        START_TRSSW=yes
    fi

    # or startup of TRSSW is explicit disabled (e.g. for traffic test)
    case "${START_TRSSW}" in
        yes|y|YES|Y)
            ;;
        *)
            enableethports=1
            ;;
    esac

    if [ $enableethports -ne 0 ]; then
        # enable the copper Interface for EIF1 (=eth3 for FCTA )
        echo "TA mode: enable EIF1 / EIF2 indoor using trswStartup_init"
#         ${TRS_BIN_DEST}/trswStartup_init 2 1
    fi
}

setL2Switch()
{
    echo "Configuring Marvel L2 switch..."

    # set P2 for murkk interface
    # set P3 to Gigabit Ethernet, FTIF ATM traffic path
    echo "Config switch ports using trswStartup_init"
#     ${TRS_BIN_DEST}/trswStartup_init 2 2
    echo "Configuring Marvel L2 switch: DONE"
}

# disable IPv6 (if present in kernel) before ethernet interfaces are set up
disableIPv6()
{
    echo "Disabling IPv6 support on eth0, pan0 eth1, ifb0 interfaces"
    echo 1 > /proc/sys/net/ipv6/conf/eth0/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/eth1/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/all/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/default/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/pan0/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/ifb0/disable_ipv6
    echo 1 > /proc/sys/net/ipv6/conf/br0/disable_ipv6
}

enableIPv6()
{
    echo "Enabling IPv6 support..."
    echo 0 > /proc/sys/net/ipv6/conf/all/disable_ipv6
    echo "Enabling IPv6 support done"
}

# note: this was intended for for specific interfaces ("ethX, rioX, swX")
# but it als works for "meta" names ("all" and "default"); saves lost of typing
disableIPv6RouterAutoconfiguration()
{
    echo "Disabling IPv6 Router autoconfiguration for: $@"
    for IFN in "$@"; do
        CD=/proc/sys/net/ipv6/conf/${IFN}
        if [ -d "$CD" ]; then
            echo "0" > ${CD}/router_solicitations
            echo "0" > ${CD}/accept_source_route
            echo "0" > ${CD}/accept_ra
            echo "0" > ${CD}/accept_ra_defrtr
            echo "0" > ${CD}/accept_ra_pinfo
        else
            echo "invalid '$IFN' (directory ${CD} not found)"
        fi
    done
}

forceMLDversion()
{
    MLDV=$1
    shift 1
    echo "Forcing MLD version $MLDV for: $@"
    for IFN in "$@"; do
        CD=/proc/sys/net/ipv6/conf/${IFN}
        if [ -d "$CD" ]; then
            echo "$MLDV" > ${CD}/force_mld_version
        else
            echo "invalid '$IFN' (directory ${CD} not found)"
        fi
    done
}

# when IPv6 is enabled globally, all interfaces (rio, sw, ..) get IPv6 addrs.
# their "autoconf traffic" (Router solicitation, Duplicate Address Detection,..)
# is completely legal, but unxepected fom the testers P.O.V. As a Workaround,
# we reduce autoconf attempts to ZERO for the exposed interfaces
# (this will be redundant if/when IPv6 is enabled more selectively)
suppressLinkLevelAutoconfTraffic() {
    echo "Suppressing LinkLevelAutoconf traffic for: $@"
    for IFN in "$@"; do
        CD=/proc/sys/net/ipv6/conf/${IFN}
        if [ -d "$CD" ]; then
            echo "0" > ${CD}/router_solicitations
            echo "0" > ${CD}/dad_transmits
            echo "0" > ${CD}/autoconf
        else
            echo "invalid '$IFN' (directory ${CD} not found)"
        fi
    done
}

startTftpMonitor()
{
    if [ -x "${TRS_BIN_DEST}/ftifBist" ]; then
        echo "Starting the tftp LED monitoring porcess"
        ${TRS_BIN_DEST}/ftifBist -a &
        echo "Starting the tftp LED monitoring porcess: DONE"
    fi
}

disableFlowControlOnConsole()
{
    for dev in /dev/ttyS*; do
        stty -ixon -ixoff < $dev
        stty -crtscts < $dev
        stty -cdtrdsr < $dev 2>/dev/null
    done
}

activateSctpLoopback()
{
    if [ ! -e "${TRS_SIM_DEST}/SCTP_TEST_ENABLE" ]; then
        case "${TEST_ADAPTER}" in
            yes|y|YES|Y)
                ;;
            *)
                case "${BTSOM_SIMULATED}" in
                    yes|y|YES|Y)
                        if [ -x "${TRS_BIN_DEST}/test_loopback" ]; then
                            echo "Activate SCTP loopback..."
                            { ${TRS_BIN_DEST}/test_loopback -s eth3 & }
                            echo "Activate SCTP loopback: DONE"
                        else
                            echo "ERROR: SCTP looback could not be activated"
                        fi
                        ;;
                esac
                ;;
        esac
    else
        echo "SCTP Forwarding is enabled, Not activating Loopback"
    fi
}

startHeartbeat()
{
    if [ -x "${TRS_BIN_DEST}/hbtApp" ]; then
        echo "Starting heartbeat Application......."
        { ${TRS_BIN_DEST}/hbtApp & }
        echo " Heartbeat Application running: "
    else
        echo "ERROR: Not able to start the heartbeat Application"
    fi
}

status_iptables()
{
    echo "======================================================================"
    echo "                       mangle - table"
    echo "======================================================================"
    iptables -v -n -L -t mangle
}

start_ndp_config()
{
    for d in $(/bin/ls /proc/sys/net/ipv6/neigh); do
        echo 5 > /proc/sys/net/ipv6/neigh/$d/mcast_solicit
        echo 400 > /proc/sys/net/ipv6/neigh/$d/base_reachable_time
        echo 400000 > /proc/sys/net/ipv6/neigh/$d/base_reachable_time_ms
    done
}

# Pronto 48299ESPE05 - Disable Do Not Fragment bit in outgoing packets
# by disabling Path MTU Discovery (Ref: WBTS_TRS_9227)
# Pronto 110045ESPE04 - As a workaround fix, set min_pmtu=0 to avoid fragmentation
# up receiving ICMP destination unreach message with "fragmentaion needed" bit set.
disablePmtu()
{
    sysctl -w net.ipv4.ip_no_pmtu_disc=1
    sysctl -w net.ipv4.route.min_pmtu=0
}

disableacceptsourceroute()
{
    sysctl -w net.ipv4.conf.default.accept_source_route=0
    sysctl -w net.ipv4.conf.eth0.accept_source_route=0
    sysctl -w net.ipv4.conf.eth1.accept_source_route=0
    sysctl -w net.ipv4.conf.eth2.accept_source_route=0
    sysctl -w net.ipv4.conf.lo.accept_source_route=0
    sysctl -w net.ipv4.conf.pan0.accept_source_route=0
}

# Preset environment for EvK / FZM board
presetEnvironment()
{
    #temp fix until the next build comes out
    ln -s  /lib/ld-2.17.so /lib/ld-linux.so.3

    #temp fix until the official packaging puts libs in the correct location
    mv -f /opt/trs/lib/* /usr/lib/
    ln -sf /lib64/libAaMemOsWrapper.so /lib/libAaMemOsWrapper.so
    ln -sf /lib64/libCCS.so /lib/libCCS.so
    ln -sf /lib64/libHWR.so /lib/libHWR.so

    #cp /rom/trs_data/db/eeprom* /var/log
}

drop_ip_options_pkt()
{
    iptables -I INPUT 1 -m u32 --u32 "0&0x0F000000=0x06000000:0x0F000000" -j DROP
}

restart_bluetoothd()
{
    # This is only TEMP solution till PS start BT daemon with incorrect options
    mkdir -p /ffs/run/trs_data/active/bluetooth
}

#Adding Users and Groups on the board as part of LLPD feature
prepareUserAndGrp()
{
    # work around NFS issue with reboot triggered during adduser/usermod
    local NFSINTERFACE
    NFSINTERFACE=$(check_nfsboot)
    if [ "x${NFSINTERFACE}" != "x" ]; then
        rm -f /etc/passwd+
        rm -f /etc/group+

        if [ ! -e /etc/passwd ]; then
            cp -f /etc/passwd- /etc/passwd+ 2>/dev/null && ln /etc/passwd+ /etc/passwd && rm -f /etc/passwd+
        fi
        if [ ! -e /etc/group ]; then
            cp -f /etc/group- /etc/group+ 2>/dev/null && ln /etc/group+ /etc/group && rm -f /etc/group+
        fi
    fi

    user='smafiletransfer smacertmgr smaruim smaasn1 smaxoh smaftacmgr smaruem nma nmapagent bfd quagga lighttp strongswan dhcp'
    userid='607 606 602 604 605 601 603 693 608 307 701 702 704 703'
    keystorage_group='llpd_keystorage'

    keystore_access_group='keystoreaccessgrp'
    certs_reader_grp='certsreadergrp'

    trs_software_group='trs_software'
    trs_logger_group='trs_logger'
    bts_software_group='btssw'

    # Adding Group on the board
    groupadd -g 65000 $keystorage_group
    groupadd -g 801 $keystore_access_group
    groupadd -g 802 $certs_reader_grp
    groupadd -g 803 $trs_software_group
    groupadd -g 804 $trs_logger_group

    g=1
    while [ $g -le 13 ]; do
        GROUP=`echo "$user" | cut -d ' ' -f $g`
        GROUPID=`echo "$userid" | cut -d ' ' -f $g`

        groupadd -g $GROUPID $GROUP
        let g++
    done

    sleep 1

    # Adding User on the board

    n=1
    while [ $n -le 13 ]; do
        USER=`echo "$user" | cut -d ' ' -f $n`
        USERID=`echo "$userid" | cut -d ' ' -f $n`

        useradd -u $USERID $USER -g $USER
        let n++
    done

    # Adding Users in the nma and llpd_keystorage group

    n=1
    while [ $n -le 12 ]; do
        USER=`echo "$user" | cut -d ' ' -f $n`
        #USERID=`echo "$userid" | cut -d ' ' -f $n`

        usermod -a $USER -G nma
        usermod -a $USER -G $keystorage_group
        let n++
    done

    usermod -a root -G $keystorage_group
    # Adding users to KeyStoreAccessGrp
    usermod -a nma -G $keystore_access_group
    usermod -a smacertmgr -G $keystore_access_group
    usermod -a smaruem -G $keystore_access_group
    usermod -a smaruim -G $keystore_access_group

    # Adding users to CertsReaderGrp
    usermod -a nma -G $certs_reader_grp
    usermod  -a lighttp -G $certs_reader_grp

    usermod  -a smaxoh -G $certs_reader_grp
    usermod  -a smaasn1 -G $certs_reader_grp
    usermod  -a smaruim -G $certs_reader_grp
    usermod -a smafiletransfer -G $certs_reader_grp

    #Adding users to Trs_Software Group
    usermod -a nma -G $trs_software_group
    usermod -a smafiletransfer -G  $trs_software_group
    usermod -a smacertmgr -G $trs_software_group
    usermod -a sma -G $trs_software_group
    usermod -a smaruim -G $trs_software_group
    usermod -a smaasn1 -G $trs_software_group
    usermod -a smaxoh -G $trs_software_group
    usermod -a smaftacmgr -G $trs_software_group
    usermod -a smaruem -G $trs_software_group
    usermod -a bfd -G $trs_software_group

    #Adding users to Trs_Logger Group
    usermod -a nma -G $trs_logger_group
    usermod -a smafiletransfer -G $trs_logger_group
    usermod -a smacertmgr -G $trs_logger_group
    usermod -a sma -G $trs_logger_group
    usermod -a smaruim -G $trs_logger_group
    usermod -a smaasn1 -G $trs_logger_group
    usermod -a smaxoh -G $trs_logger_group
    usermod -a smaftacmgr -G $trs_logger_group
    usermod -a smaruem -G $trs_logger_group
    usermod -a bfd -G $trs_logger_group

    #Adding users to Bts_Software Group
    usermod -a nma -G $bts_software_group
    usermod -a smafiletransfer -G $bts_software_group
    usermod -a smacertmgr -G $bts_software_group
    usermod -a sma -G $bts_software_group
    usermod -a smaruim -G $bts_software_group
    usermod -a smaasn1 -G $bts_software_group
    usermod -a smaxoh -G $bts_software_group
    usermod -a smaftacmgr -G $bts_software_group
    usermod -a bfd -G $bts_software_group
    usermod -a smaruem -G $bts_software_group

    # Adding nma to Groups
    usermod  -a nma -G smaruem
    usermod  -a nma -G smaruim

    # Adding smaFileTransfer user in Ruem group
    usermod -a smafiletransfer -G smaruem

    # Adding Users in the SmaCertMgr group
    usermod -a smaruim -G smacertmgr
    usermod -a smaasn1 -G smacertmgr
    usermod -a smaxoh -G smacertmgr
    usermod -a nma -G smacertmgr
    usermod -a smafiletransfer -G smacertmgr
    usermod -a lighttp -G smacertmgr

    # resolve for PR41646
    # Adding Users in the SmaRuim group
    usermod -a smaftacmgr -G smaruim

    if [ -d "/var/fpwork" ]
        then
        chmod -R 777 /var/fpwork
    fi

    if [ -d "/etc" ]
        then
        chmod -R 600 /etc/shadow
    fi

    echo "SSH_SERVICE=0" > /tmp/fcmSsh_status.conf
    chmod 660 /tmp/fcmSsh_status.conf

    echo "RND_PORTS_SERVICE=0" > /tmp/iptables_ports_service.conf
    chmod 660 /tmp/iptables_ports_service.conf

    chown root:nma /tmp/iptables_ports_service.conf /tmp/fcmSsh_status.conf

    # Resolve for PR41138 It will be removed when issue is resolved by CC&S
    if [ -r "/proc/sys/fs/suid_dumpable" ]; then
        echo 2 > /proc/sys/fs/suid_dumpable
    fi
}

set_tbit()
{

	if [ -d /ffs/fs1/trs_data/active/bluetooth ]; then
		chmod +t /ffs/fs1/trs_data/active/bluetooth
	fi

	if [ -d /ffs/fs1/trs_data/active/tauf_config ]; then
		chmod +t /ffs/fs1/trs_data/active/tauf_config
	fi

	if [ -d /ffs/fs1/trs_data/db ]; then
		chmod +t /ffs/fs1/trs_data/db
	fi

	if [ -d /ffs/fs1/trs_data/active ]; then
		chmod +t /ffs/fs1/trs_data/active
	fi
}

#########################################
# START TRS CONFURATION"
#########################################
#presetEnvironment

#disableFlowControlOnConsole

prepareTmpFolder

prepareConfFolder

updateResetCnt

fixObsaiStartup

#enableEthPorts

loadKmodules

#releaseCores

#loadStartSe

#setL2Switch

arptimers

icmp_rate_limit

identifyLmpIpAddress

configEthIf
disableIPv6

# Pronto 48299ESPE05 - Disable Do Not Fragment bit in outgoing packets
# by disabling Path MTU Discovery (Ref: WBTS_TRS_9227)
disablePmtu

disableacceptsourceroute

setsockoptions

restart_bluetoothd

#case "${TEST_ADAPTER}" in
#    yes|y|YES|Y)
#        ;;
#    *)
#        startTftpMonitor
#        ;;
#esac

#activateSctpLoopback

arp_unres_qlen

protect_dos_ddos_attacks
set_ipv6_hop_limit

start_ndp_config

#startHeartbeat

#if ! [ -a "${TRS_PMD_DIR}"/orbWaitDuration ]; then
#    echo 10 > "${TRS_PMD_DIR}"/orbWaitDuration
#fi

drop_ip_options_pkt

prepareUserAndGrp

set_tbit

chmod 644 /etc/passwd
chmod -R 755 /etc/keys.d
chmod -R 755 /etc/ipsec.d
chown -R SmaCertMgr:CertsReaderGrp /etc/ipsec.d

#PR 107223ESPE01: [FZM RL50 SBM] Triple fragmentation causes packet loss inside FZM
#Maximum disorder which is allowed among fragments which share a common IP source address is increased from 64 to 1000.
echo 1000 > /proc/sys/net/ipv4/ipfrag_max_dist

/opt/trs/bin/trsXfrmBridge &
#END
