#! /bin/sh

OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"

TRS_DATA="/ffs/run/trs_data"
TRS_ACT_DEST="${TRS_DATA}/active"

# ---------- Dest Path ------------------

TRS_BIN_DEST="${OPT_DIR}/bin"
TRS_ETC_DEST="${OPT_DIR}/etc"

TRS_KEYSTR_DEST="${TRS_ACT_DEST}/keystorage"
TRS_KEYSTR_DEST_CERTS="${TRS_KEYSTR_DEST}/certs"

export LD_LIBRARY_PATH="${TRS_LIB_DEST}:${CCS_DIR}:/usr/lib64:/lib64:/lib:$LD_LIBRARY_PATH"
export PATH="${TRS_BIN_DEST}:$PATH"

mkdir -m 0775 -p "${TRS_KEYSTR_DEST_CERTS}"

if [ ! -e "${TRS_KEYSTR_DEST_CERTS}/privkey.crk" ]; then
    /bin/cp -f "${TRS_ETC_DEST}/cert/bts_priv_key.pem" "${TRS_KEYSTR_DEST_CERTS}/privkey.crk"
fi

if [ ! -e "${TRS_KEYSTR_DEST_CERTS}/cert.pem" ]; then
    /bin/cp -f "${TRS_ETC_DEST}/cert/bts_pub_cert.pem" "${TRS_KEYSTR_DEST_CERTS}/cert.pem"
fi

