# is for Starting/Stopping/Restarting DHCPD server. You won't need
# to edit anything.
DHCPD_CONF=/opt/trs/etc/dhcpd_sfn.conf
PIDFILE=/opt/trs/etc/dhcpd_sfn.pid
DHCP_LEASEFILE=/ffs/run/trs_data/active/dhcpd_sfn.leases
export SHELL=/bin/sh
 
case "$1" in
  start)
    # Starts the dhcpd server
    echo "Starting DHCPD"
    #PATH=$PATH:/usr/local/bin /usr/sbin/lighttpd -f $LIGHTTPD_CONF &
    /usr/sbin/dhcpd -user dhcpd -group dhcpd -cf $DHCPD_CONF -lf $DHCP_LEASEFILE -pf $PIDFILE &
    ;;
  stop)
    # stops the daemon bt cat'ing the pidfile
    echo "Stopping DHCPD"
    kill -9 `/bin/cat $PIDFILE`
    ;;
  restart)
    ## Stop the service regardless of whether it was
    ## running or not, start it again.
    echo "Restarting dhcpd"
    $0 stop
    COUNT=5
    while [ COUNT ]
    do
        echo "Stopping dhcp_sfn pid : `cat /opt/trs/etc/dhcpd_sfn.pid`"
        pgrep -l dhcp | grep `cat $PIDFILE`
        if [ $? != 0 ];then
            break
        fi
        sleep 0.2
        COUNT=$(($COUNT -1))
        if [ "$COUNT" == "0" ]; then
           echo "Failed : stopping dhcp daemon pid: `cat /opt/trs/etc/dhcpd_sfn.pid`"
        fi
    done
    $0 start
    ;;
  reload)
    # reloads the config file by sending HUP
    echo "Reloading config"
    kill -HUP `/bin/cat $PIDFILE`
    ;;
  *)
    echo "Usage: dhcpdctrl (start|stop|restart|reload)"
    exit 1
    ;;
esac
