#!/bin/sh

TMPPREFIX="extendedSettingsTmpDir"
GLOBALTMP=""

umask 002

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

if [ "x${ROOT_DIR}" = "x/tmp/SIM" ]; then
    simulation=1
else
    simulation=0
fi

if [ -d "/sdm_selected" ]; then
    RUN_DIR="${ROOT_DIR}/tmp"
    START_SCRIPT="${ROOT_DIR}/sdm_selected/start_script.conf"
else
    RUN_DIR="${ROOT_DIR}/ffs/run"
    STB_DIR="${ROOT_DIR}/ffs/stb"
    START_SCRIPT="${RUN_DIR}/trs_data/sim/start_script.conf"
fi

TRSCRASHLOG="${RUN_DIR}/logs/TRSCrashLogs.tgz"
TRSBOOTUPTCPDUMP="${RUN_DIR}/logs/eNB_boot_tcpdump.pcap"
OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"

TRS_BIN_DEST="${OPT_DIR}/bin"
TRS_LIB_DEST="${OPT_DIR}/lib64"

PROGRAM_ENVINFO="${TRS_BIN_DEST}/test_envInfo"

PROG_FASTPATHCONFIG="${TRS_BIN_DEST}/FPCiTest"
PROG_FPDEBUGACESS="${TRS_BIN_DEST}/fpdebugAccess"
PROG_DDAL_TEST_TOOL="${TRS_BIN_DEST}/ddal_test_tool"

# Signal handler function: removes temporary directory in case of
# premature termination of the script

onDie()
{
    if [ -n "${GLOBALTMP}" ]
        then
        rm -rf  ${GLOBALTMP}
    fi
    rmdir $LOCKFILEDIR 2>&1
    exit 0;
}

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${ROOT_DIR}/opt/trs/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

# detect machine (processor) type
MACHINE=$(uname -m)

if [ "$MACHINE" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi


if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

#LTE1266
UNIT=`test_envInfo envInfoUnitType | head -1`
if [ $UNIT == "UNIT_FCTA" ]; then
    FLAG=`test_envInfo envInfoIfRP441 | head -1`
    if [ $FLAG == "RP441_ENABLE" ]; then
        FTP_DIR="/shareTmp/transport/ftp"
    else
        FTP_DIR="/tmp/ftp"
    fi
else
    FTP_DIR="/tmp/ftp"
fi

. ${FUNCTIONS}

[ -f "${START_SCRIPT}" ] && . "${START_SCRIPT}"

test_envInfo envInfoUnitType >/dev/null
UNIT=$?

if [ $simulation -ne 0 ]; then
    ACTIVE_CORE_DIR="${ROOT_DIR}/var/log"
    LOGDIR=${ROOT_DIR}/var/log
    STBLOGDIR=${ROOT_DIR}/ffs/stb/logs
else
    ACTIVE_CORE_DIR="${RUN_DIR}/logs"
    LOGDIR=${RUN_DIR}/logs
fi
TMPPATH=${ROOT_DIR}/tmp

PASSIVE_CORE_DIR=${ROOT_DIR}/tmp/passCfg

if [ $simulation -ne 0 ]; then
    # SIM env
    COREFILE_ACTIVE="${ACTIVE_CORE_DIR}/*core* ${HOME}/*core* /tmp/*core* ${HOME}/memcheck_*.log /tmp/memcheck_*.log ${HOME}/helgrind_*.log /tmp/helgrind_*.log"
else
    COREFILE_ACTIVE="${ACTIVE_CORE_DIR}/core* ${ACTIVE_CORE_DIR}/../*core* /var/tmp/core* /var/tmp/diagn/core* /var/diagn/core*"
fi

COREFILE_PASSIVE=${PASSIVE_CORE_DIR}/core*

BACKTRACE_ACTIVE_FILES="${ACTIVE_CORE_DIR}/bt-* /var/tmp/diagn/bt-*"
BACKTRACE_PASSIVE_FILES="${PASSIVE_CORE_DIR}/bt-*"

was_cgi_bin=$(wasCgiBin $SCRIPT_NAME)

if [ $was_cgi_bin -eq 1 ]; then
    sendMessage 0 "Please use the link [ Download TRS Log file -> Enhanced Log Collection ]" "Unauthorized - Access denied" 6
    exit
fi

if [ $# -eq 1 ]; then
    filename="$1"
else
    filename="ExtendedFtmLog.tgz"
fi

collect_fp_qos_logs_to_a_file()
{
    #Get QoS FastPath debug data to log file.
    #call required debug functions.
    echo "*********************************" > "${TMPDIR}/fp_qos_logs.txt"
    echo "*** QoS : FastPath Debug logs ***" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "*********************************" >> "${TMPDIR}/fp_qos_logs.txt"
    echo " " >> "${TMPDIR}/fp_qos_logs.txt"

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_cfg_dbg ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_cfg_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_cfg_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_cfg_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_port_dbg for port-index: 1 ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_port_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_port_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_port_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_path_dbg_table for port-index: 1 ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_path_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_path_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_path_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_if_grp_dbg ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_if_grp_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_if_grp_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_if_grp_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###  iptest_qos_if_shldrid_dbg for if-index: 9  ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_if_shldrid_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_if_shldrid_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_if_shldrid_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_ip_discard_counters_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_ip_discard_counters_table.txt" ]; then
        cat /tmp/ipgw_qos_ip_discard_counters_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_ip_discard_counters_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_dscp_phb_dp_dbg_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "########################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_dscp_to_vlan_prio_mapping_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "########################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt" ]; then
        cat /tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_flow_clfr_dbg_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_flow_clfr_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_flow_clfr_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_flow_clfr_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    #Done with dumping QoS FP debug data. Delete the temporary log files.
    rm -f /tmp/ipgw_qos_*_table.txt > /dev/null
}

collect_fpapp_logs_to_a_file()
{

    # Copy TRS fpapp Log to TMPDIR
    cat /tmp/fuse/iwf/HistoryLog | grep "TRS::FPAPP" > "/tmp/trs_fpapp.log"
    /opt/trs/bin/FpAppCfgDump
    if [ -f /tmp/lte_syscom_iwf_ul_connection_dump_table.txt ]; then
        cp /tmp/lte_syscom_iwf_ul_connection_dump_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_iwf_dl_connection_dump_table.txt ]; then
        cp /tmp/lte_syscom_iwf_dl_connection_dump_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/gtpu_mgmt_err_ind_table.txt ]; then
        cp /tmp/gtpu_mgmt_err_ind_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_iwf_config_table.txt ]; then
        cp /tmp/lte_syscom_iwf_config_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_application_ip_table.txt ]; then
        cp /tmp/lte_syscom_application_ip_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/l3l4_classifier_table.txt ]; then
        cp /tmp/l3l4_classifier_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/ipgw_iptest_show_interfaces_table.txt ]; then
        cp /tmp/ipgw_iptest_show_interfaces_table.txt ${TMPDIR}/
    fi
    cp /tmp/trs_fpapp.log ${TMPDIR}/
}

collect_fpctrl_package_logs()
{
    # Collect fpctrl package logs. Logs are generated in /ffs/run/logs/
    fpctrl pkg-trs

    # Move file to TMPDIR for collection
    cp /ffs/run/logs/netfp_logs.tgz ${TMPDIR}/ > /dev/null
    
    # Delete generated file after copying
    rm -f /ffs/run/logs/netfp_logs.tgz > /dev/null

}

collect_journal_logs()
{
    # Generate Journal logs
    /opt/trs/bin/llpd journalctl -b > /tmp/journal_logs.txt
    
    
    #compress file using tar
    if [ -f /tmp/journal_logs.txt ]; then
       tar -cvzf /tmp/journal_logs.tgz /tmp/journal_logs.txt > /dev/null
    fi

    # Move file to TMPDIR for collection
    if [ -f /tmp/journal_logs.tgz ]; then
       cp /tmp/journal_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f /tmp/journal_logs.tgz ]; then
       rm -f /tmp/journal_logs.tgz > /dev/null
    fi

    if [ -f /tmp/journal_logs.txt ]; then
       rm -f /tmp/journal_logs.txt > /dev/null
    fi
}

collect_fpAppsDebug_logs()
{
    # Generate Fastpath counter logs
    /opt/trs/bin/FpAppDebugCountersDump show > /tmp/fpAppsDebugCounters_logs.txt

    #compress file using tar
    if [ -f /tmp/fpAppsDebugCounters_logs.txt ]; then
       tar -cvzf /tmp/fpAppsDebugCounters_logs.tgz /tmp/fpAppsDebugCounters_logs.txt > /dev/null
    fi

    # Move file to TMPDIR for collection
    if [ -f /tmp/fpAppsDebugCounters_logs.tgz ]; then
       cp /tmp/fpAppsDebugCounters_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f /tmp/fpAppsDebugCounters_logs.tgz ]; then
       rm -f /tmp/fpAppsDebugCounters_logs.tgz > /dev/null
    fi

    if [ -f /tmp/fpAppsDebugCounters_logs.txt ]; then
       rm -f /tmp/fpAppsDebugCounters_logs.txt > /dev/null
    fi

}

collect_fpAppsCfgDump_logs()
{

    # Generate Fastpath config dump logs. Logs are generated in /tmp/lte_syscom_application_ip_table.txt
    /opt/trs/bin/FpAppCfgDump

    #compress file using tar
    tar -cvzf /tmp/fpAppsCfgDump_logs.tgz /tmp/lte_syscom_iwf_ul_connection_dump_table.txt /tmp/lte_syscom_iwf_dl_connection_dump_table.txt /tmp/lte_syscom_iwf_config_table.txt              /tmp/lte_syscom_application_ip_table.txt /tmp/gtpu_mgmt_err_ind_table.txt /tmp/fp_ipsec_cfgfile.txt > /dev/null

    # Move file to TMPDIR for collection
    if [ -f /tmp/fpAppsCfgDump_logs.tgz ]; then
       cp /tmp/fpAppsCfgDump_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    rm -f /tmp/fpAppsCfgDump_logs.tgz /tmp/lte_syscom_iwf_ul_connection_dump_table.txt /tmp/lte_syscom_iwf_dl_connection_dump_table.txt /tmp/lte_syscom_iwf_config_table.txt              /tmp/lte_syscom_application_ip_table.txt /tmp/gtpu_mgmt_err_ind_table.txt /tmp/fp_ipsec_cfgfile.txt > /dev/null

}


collectAndSendExtendedLogfiles()
{
    local TMPDIR

    #Before Creating a Temp Directory, Clear if old temporary Directory exists.
    rm -rf ${TMPPATH}/${TMPPREFIX}*

    # create a tmp dir
    TMPDIR=$(mktemp -d ${TMPPATH}/${TMPPREFIX}.XXXXXX)
    GLOBALTMP=${TMPDIR}

    # Set signal handler to delete temporary dir in case of premature end of
    # the script
    trap 'onDie' TERM
    trap 'onDie' STOP
    trap 'onDie' INT

    # add core dumps
    for core_file in $COREFILE_ACTIVE; do
        cp -f "$core_file" ${TMPDIR}
        if [ $simulation -ne 0 ]; then
            rm -f "$core_file"
        else
            case "${BTSOM_SIMULATED}" in
                yes|y|YES|Y)
                    rm -f "$core_file"
                    ;;
                *)
                    ;;
            esac
        fi
    done

    # and the passive partition core files
    for core_file in $COREFILE_PASSIVE; do
        cp -f "$core_file" "${TMPDIR}/passivePartition.$(basename "$core_file")"
        if [ $simulation -ne 0 ]; then
            rm -f "$core_file"
        else
            #FSMR3
            case "${BTSOM_SIMULATED}" in
                yes|y|YES|Y)
                    rm -f "$core_file"
                    ;;
                *)
                    ;;
            esac
        fi
    done

    # start SCF snapshot, copy at the end of this function
    # we send this into background because we do not want this script to block
    mkdir -p "${ROOT_DIR}${FTP_DIR}" -m 0775 >/dev/null
    objcli generate_scf >/dev/null &

    if [ "armv5teb" = "${MACHINE}" ]; then
        # Dump Counters once
        rm -f ${FTP_DIR}/getCountersReady1
        GetCounters.cgi np_tables np_debug_info > ${FTP_DIR}/Counters1.log &

        if [ -s $/tmp/HIB_reg_dump.txt ]; then
            tar -czf "${TMPDIR}/LLP_reg_dumps_1.tar.gz" /tmp/*_reg_dump.txt
            rm /tmp/*_reg_dump.txt
        fi
    fi

    # Get counter & log files
    if [ "mips64" = "${MACHINE}" ]; then
        echo "############################################" > "${TMPDIR}/FPCounter.log"
        echo "### 1. $PROG_FPDEBUGACESS show " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        /opt/trs/bin/llpd $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        PRODUCT_TYPE=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
        ${PROGRAM_ENVINFO} envInfoProductType > /dev/null
        PROD_TYPNUM=$?
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "###### PRODUCT TYPE: " $PRODUCT_TYPE >>     "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"

        case "${TEST_ADAPTER}" in
                    yes|y|YES|Y)
            ;;
        *)
            echo "############################################" >> "${TMPDIR}/FPCounter.log"
            echo "### $PROG_FASTPATHCONFIG iptest_ip_se_log_file_support" >> "${TMPDIR}/FPCounter.log"
            echo "############################################" >> "${TMPDIR}/FPCounter.log"
            $PROG_FASTPATHCONFIG iptest_ip_se_log_file_support $PROD_TYPNUM >> "${TMPDIR}/FPCounter.log" 2>&1
            ;;
        esac
         
        #Collect QoS debug info
        collect_fp_qos_logs_to_a_file > /dev/null

        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### $PROG_FASTPATHCONFIG ipsec_dump_all_test " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        $PROG_FASTPATHCONFIG ipsec_dump_all_test >> "${TMPDIR}/FPCounter.log" 2>&1

        HOST_COUNTER="
        /sys/kernel/fpcidisp/cnt_fpcidp
        /sys/kernel/heartbeat/hbt_cntr
        /sys/kernel/fpapool/fpa_pool
        /sys/kernel/mcheck/reserve32
        /sys/kernel/mcheck/reserve32_freelist
        /sys/kernel/heartbeat/hbt_cntr
      "
        for counter in $HOST_COUNTER; do
            if [ -e $counter ]; then
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                echo "### cat $counter " >> "${TMPDIR}/HostCounter.log"
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                cat $counter >> "${TMPDIR}/HostCounter.log" 2>&1
            else
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                echo "### $counter not existing" >> "${TMPDIR}/HostCounter.log"
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
            fi
        done

        echo "### MLPPP driver counter ###################" >> "${TMPDIR}/HostCounter.log"
        /opt/trs/bin/fpdebugAccess mlppp >> "${TMPDIR}/HostCounter.log"
        echo "############################################" >> "${TMPDIR}/HostCounter.log"
        cp -f /tmp/transport/pppd*.log $TMPDIR

        VARLOGDIR=/var/log
        VARTMPDIR=/var/tmp

        INIT_NAME="start_script.conf"
        TRS_CFG_DEST="${RUN_DIR}/trs_data/sim"

        if [ -s "/var/log/bist_log.txt" ]; then
            rm -f "/var/log/bist_log.txt"
        fi
        if [ -s "/var/log/FxIFSelfTest.log" ]; then
            rm -f "/var/log/FxIFSelfTest.log"
        fi
        if [ -s "/var/log/config_upgrade.xml" ]; then
            rm -f "/var/log/config_upgrade.xml"
        fi
        if [ -s "/var/log/lighttpd.pid" ]; then
            rm -f "/var/log/lighttpd.pid"
        fi

        cp -f /rom/swconfig.txt $TMPDIR

        if [ "x${VIA_SEM}" == "x" ]; then
            cp -f /opt/trs/etc/ccs_log.txt $TMPDIR
            cp -f /ffs/run/apps/fct/AppDef*.txt $TMPDIR
            cp -f $LOGDIR/*.logs $TMPDIR
            cp -f /var/tmp/ukptTmrMon $TMPDIR

            # Copy the Last activated SCF
            if [ -f ${LAST_ACTIVATED_USER_SCF} ]; then
            cp ${LAST_ACTIVATED_USER_SCF} ${TMPDIR}
            rm ${LAST_ACTIVATED_USER_SCF}
            fi

            # Sending all var logs collectively by a tar file
            tar -cf ${TMPDIR}/linux_logs.tar $VARLOGDIR/*
        fi

        POSTMORTEMFILE=postmortem.bin
        for POSTMORTEM in {"${VARTMPDIR}","${VARLOGDIR}"}/"${POSTMORTEMFILE}"; do
            if [ -e $POSTMORTEM ]; then
                xz --lzma2=dict=512KiB -c $POSTMORTEM > "${TMPDIR}/${POSTMORTEMFILE}.xz"
            fi
        done

        cp -f /tmp/*table*.txt $TMPDIR
        cp -f /tmp/fp_crash_hang_log.txt $TMPDIR >/dev/null 2>&1
        
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### 2. $PROG_FPDEBUGACESS show " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        /opt/trs/bin/llpd $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        echo "############################################" > "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### 1. Marvel switch counters " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        for interface in 0 2 3 4 ; do
            $PROG_DDAL_TEST_TOOL -s 0 -d 1 -o 18 -n $interface >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        done
    fi

    if [ $simulation -ne 0 ]; then
        # Simulation
        cp -f $ROOT_DIR/usr/local/etc/*.ip $TMPDIR
        cp -f /tmp/tmgr.log $TMPDIR
    fi

    OURDIR=$(dirname $0)
    
    if [ `isFzm` -eq 1 ]; then
        if [ "armv7l" = "${MACHINE}" ]; then #FZM
           echo "############################################" >> "${TMPDIR}/IWFCounter.log"
            echo "### IWF Counter Logs                        " >> "${TMPDIR}/IWFCounter.log"
            echo "############################################" >> "${TMPDIR}/IWFCounter.log"
            cat /proc/fzm_iwf/iwf_ko >> "${TMPDIR}/IWFCounter.log" 2>&1
            echo "############################################" >> "${TMPDIR}/IWFTableDump.log"
            echo "### IWF Table Dump                          " >> "${TMPDIR}/IWFTableDump.log"
            echo "############################################" >> "${TMPDIR}/IWFTableDump.log"
            cat /proc/fzm_iwf/iwf_ko_tbl_dump >> "${TMPDIR}/IWFTableDump.log" 2>&1

            #QMSS QoS traces
            ${OURDIR}/../protected/qos_trace.sh > "${TMPDIR}/qmss_qos_dump.txt"

            #collect fpapp logs
            collect_fpapp_logs_to_a_file > /dev/null

            # collect fpctrl package
            collect_fpctrl_package_logs > /dev/null

            # collect jounral logs
            collect_journal_logs > /dev/null

            # collect Fastpath Counter logs
            collect_fpAppsDebug_logs > /dev/null

            # collect Fastpath Config dump logs
            collect_fpAppsCfgDump_logs > /dev/null

        fi
    fi

    # Collect Traces
    ${OURDIR}/../protected/ukptTraces.sh > "${TMPDIR}/Traces.log"

    # Add extended information
    ${OURDIR}/../protected/ShowLocalSettings.cgi > "${TMPDIR}/ExtendedSystemInfo.log"

    #FSMR4
    if [ `isFsmr4` -eq 1 ]; then
        mkdir /tmp/fsmr4
        ${OURDIR}/../protected/Fsmr4_vtclogs.sh
        cp -rf /tmp/fsmr4/* ${TMPDIR}
        cp -rf /ffs/fs1/swconfig.txt ${TMPDIR}
        rm -rf /tmp/fsmr4/
    fi


    # Add FTIF information

    if [ "mips64" = "${MACHINE}" ]; then
        rm -f /tmp/trs/tftpboot/ftif_tmp
        /opt/trs/bin/ftifPresent > /dev/null 2>&1
        if [ -e /tmp/trs/tftpboot/ftif_tmp ]; then
            /opt/trs/bin/elogClient > /dev/null 2>&1 &
            sleep 30
            if [ -s /tmp/trs/tftpboot/ftif_tmp ]; then
                mv -f /tmp/trs/tftpboot/ftif_tmp /tmp/trs/tftpboot/ftif_logs.tgz
                mv -f /tmp/trs/tftpboot/ftif_logs.tgz $TMPDIR

                if [ -s /tmp/trs/tftpboot/ftif_core ]; then
                    mv -f /tmp/trs/tftpboot/ftif_core $TMPDIR
                    touch /tmp/trs/tftpboot/ftif_core
                fi
            fi
        fi
    fi

    # Add post-mortem informations
    if [ -e $LOGDIR/shmem_Trace ]
    then
        rm $LOGDIR/shmem_Trace
    fi
    if [ -e $LOGDIR/SwmTrace.xml ]
    then
        rm $LOGDIR/SwmTrace.xml
    fi

    if [ `isFzm` -eq 1 ]; then
        find $LOGDIR -name 'TraceLog*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    else
        find $LOGDIR -name '*Trace*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    fi

    if [ -e $STBLOGDIR/shmem_Trace ]
    then
        rm $STBLOGDIR/shmem_Trace
    fi
    if [ -e $STBLOGDIR/SwmTrace.xml ]
    then
        rm $STBLOGDIR/SwmTrace.xml
    fi

    if [ `isFzm` -eq 1 ]; then
        find $STBLOGDIR -name 'TraceLog*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    else
        find $STBLOGDIR -name '*Trace*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    fi    

    # TAUF extension
    if [ -x /usr/local/bin/tauf/run_tauf ]; then
        /usr/local/bin/tauf/run_tauf >/dev/null
        mv -f /tmp/tauf_logs ${TMPDIR}
    fi

    # adding active backtrace files
    for file in $BACKTRACE_ACTIVE_FILES; do
        cp -f $file ${TMPDIR}
        case "${BTSOM_SIMULATED}" in
            yes|y|YES|Y)
                rm -f "$file"
                ;;
            *)
                ;;
        esac
    done

    # adding passive backtrace files
    for file in $BACKTRACE_PASSIVE_FILES; do
        cp -f $file ${TMPDIR}/passive_$(basename $file)
        case "${BTSOM_SIMULATED}" in
            yes|y|YES|Y)
                rm -f "$file"
                ;;
            *)
                ;;
        esac
    done

    if [ "armv5teb" = "${MACHINE}" ]; then
        # Dump Counters once for the second time, but including the np_tables
        rm -f ${FTP_DIR}/getCountersReady2
        ${OURDIR}/GetCounters.cgi > ${FTP_DIR}/Counters2.log &

        if [ -s /tmp/HIB_reg_dump.txt ]; then
            tar -czf ${TMPDIR}/LLP_reg_dumps_2.tar.gz /tmp/*_reg_dump.txt
            rm /tmp/*_reg_dump.txt
        fi
        # On Octeon: retrieve remote static log and add to logfile
        test_envInfo envInfoOcteonAvailable >/dev/null
        if [ 0 -eq $? ]; then
            mkdir -p /tmp/remoteLogDir -m 0775 >/dev/null
            mkdir -p ${TMPDIR}/octeonLogs -m 0775 >/dev/null
            ukpt remoteLog extendedLog >/dev/null
            cp -r /tmp/remoteLogDir/* ${TMPDIR}/octeonLogs >/dev/null
            rm -rf /tmp/remoteLogDir >/dev/null
        fi
    fi

    if [ -s "${ROOT_DIR}${FTP_DIR}/SelfTest.txt" ]; then
        cp -f "${ROOT_DIR}${FTP_DIR}/SelfTest.txt" ${TMPDIR}
    fi

    #trsOverloadProtection logs
    trsOverloadlogDir="/ffs/run/logs/mon/*"
    for trsoverloadlogfile in $trsOverloadlogDir
    do
        if [ -f $trsoverloadlogfile ]; then
            cp $trsoverloadlogfile ${TMPDIR}
        fi
    done

    if [ $simulation -ne 0 ]; then
        if [ -s "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ]; then
            cp -f "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ${TMPDIR}
        fi
    else
        if [ -s "${STB_DIR}/trs_data/active/ConfigurationMigration.log" ]; then
            cp "${STB_DIR}/trs_data/active/ConfigurationMigration.log" ${TMPDIR}
        fi
        if [ -s "${STB_DIR}/trs_data/passive/ConfigurationMigration.log" ]; then
            cp "${STB_DIR}/trs_data/passive/ConfigurationMigration.log" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/TmlParsing.txt" ]; then
            cp "${RUN_DIR}/trs_data/active/TmlParsing.txt" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/config_upgrade.xml" ]; then
            cp "${RUN_DIR}/trs_data/active/config_upgrade.xml" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/FxIFSelfTest.log" ]; then
            cp "${RUN_DIR}/trs_data/active/FxIFSelfTest.log" $TMPDIR
        fi
        if [ -s "${RUN_DIR}/trs_data/active/lighttpd.pid" ]; then
            cp "${RUN_DIR}/trs_data/active/lighttpd.pid" $TMPDIR
        fi
        if [ -s "${RUN_DIR}/trs_data/active/bist_log.txt" ]; then
            cp "${RUN_DIR}/trs_data/active/bist_log.txt" $TMPDIR
        fi
    fi

    # now copy data of background collections, timeout applies
    if [ "armv5teb" = "${MACHINE}" ]; then
        for index in {1..10}; do
            if [ -e "${FTP_DIR}/getCountersReady1" ]; then
                gzip -c -q -1 ${FTP_DIR}/Counters1.log > "${TMPDIR}/Counters.log.gz"
                break
            fi
            sleep 1
        done
        for index in {1..10}; do
            if [ -e "${FTP_DIR}/getCountersReady2" ]; then
                gzip -c -q -1 ${FTP_DIR}/Counters2.log >> "${TMPDIR}/Counters.log.gz"
                break
            fi
            sleep 1
        done
    fi
    for index in {1..15}; do
        if [ -e "${ROOT_DIR}${FTP_DIR}/configDumpReady" ]; then
            cp -f "${ROOT_DIR}${FTP_DIR}/config.xml" ${TMPDIR} >/dev/null
            break
        fi
        sleep 2
    done

    # RLe: leave this as last one. Otherwise the current traces might miss informations
    # Create Dump file for current settings
    ukpt dump "${TMPDIR}/FtmDump.bin" >/dev/null

    #MbTac Dump rnd-settings and fp-dscp values into files for extended log library
    PRODUCT_TYPE=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
    if [ "WCDMA" != "$PRODUCT_TYPE" ]; then
        objcli show_rnd_mbtac_settings > "${TMPDIR}/MbTacRnDSettings.txt" 2>&1
        cp /tmp/MbTacMeasTracing* ${TMPDIR}
        cp /tmp/MbTacErgTracing* ${TMPDIR}
    fi

    # Copy TRS Crash Log to TMPDIR
    if [ -f ${TRSCRASHLOG} ]; then
        echo "TRS Crash Logs Found in the ${RUN_DIR}/logs directory" >> "${TMPDIR}/ExtendedSystemInfo.log"
        cp ${TRSCRASHLOG} ${TMPDIR}/
        rm -f ${TRSCRASHLOG}
    fi

    if [ "mips64" = "${MACHINE}" ]; then
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### 3. $PROG_FPDEBUGACESS show" >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        /opt/trs/bin/llpd $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### The state of Murrku MUX " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 0 -d 3 -n 0 -o 0 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### All interface states " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 0 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 1 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log" 
        $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 2 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

        $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 0 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 1 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 2 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 3 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### State of EIF2 interface " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "/sys/class/misc/mdioctl/eif2aneg  : " `cat /sys/class/misc/mdioctl/eif2aneg` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "/sys/class/sfp/sfp_0_5/rx_los     : " `cat /sys/class/sfp/sfp_0_5/rx_los` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "/sys/class/sfp/sfp_0_5/tx_disable : " `cat /sys/class/sfp/sfp_0_5/tx_disable` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### 2. Marvel switch counters " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        for interface in 0 2 3 4 ; do
            $PROG_DDAL_TEST_TOOL -s 0 -d 1 -o 18 -n $interface >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        done

    fi

    # Copy TRS Static SysCom Routes XML file
    cp ${ROOT_DIR}/tmp/SysComRoute-*.xml ${TMPDIR} >/dev/null 2>&1
    # Copy Bootup Wireshark log
    cp ${TRSBOOTUPTCPDUMP} ${TMPDIR} >/dev/null 2>&1 

    chmod ug+rw -R ${TMPDIR} >/dev/null
    # bundle the thing
    if [ $# -eq 1 ]; then
      # to file $filename
        tar -c -C ${TMPDIR} . | gzip -c -q > $filename
    else
      # dump to standard out
        tar -c -C ${TMPDIR} . | gzip -c -q
    fi

    rm -rf ${TMPDIR}
}

#114005ESPE04 - Lock added so that only one log collection
#will be triggered at a time
LOCKFILEDIR=${ROOT_DIR}/tmp/.`basename "$0"`.lock
mkdir -p $(dirname $LOCKFILEDIR)

if mkdir $LOCKFILEDIR > /dev/null 2>&1; then

ETAG="`date -u +%s 2>/dev/null`"

cat <<EOF
Content-Disposition: attachment; filename="$filename"
Etag: $ETAG
Expires: -1
EOF

cache_control

cat <<EOF
Connection: Keep-Alive 800
Content-type: application/x-tar-gz

EOF

    collectAndSendExtendedLogfiles ${1+"$@"} </dev/null 2>/dev/null
    rmdir $LOCKFILEDIR 2>/dev/null
else
  echo "Another log file generation is in progress. Please try after some time."
fi
