#!/bin/sh

trap '' PIPE
trap '' HUP
trap '' INT
trap '' TERM

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi
. `dirname "$0"`/../cgi-bin/functions
unitIsFsmr3=$(wasFsmr3)
unitIsFsmr4=$(isFsmr4)
PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"
PRODUCT=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
machine=`uname -m`

if [ "$machine" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi

if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

. ${FUNCTIONS}

if [ -d "${ROOT_DIR}/ffs/run/trs_data" ]; then
    TRS_DATA="${ROOT_DIR}/ffs/run/trs_data"
    ACTIVE_CONFIG_DIR="${TRS_DATA}/active"
    PASSIVE_CONFIG_DIR="${TRS_DATA}/passive"
    PERSISTENCE_DIR="${TRS_DATA}/db"
    DHCP_LEASE_PATH="${ROOT_DIR}/ffs/run/logs/dhclient.leases"
    DHCP_SFN_LEASE_PATH="${ACTIVE_CONFIG_DIR}/dhcpd_sfn.leases"
else
    ACTIVE_CONFIG_DIR="${ROOT_DIR}/usr/local/etc/config"
    PASSIVE_CONFIG_DIR="${ROOT_DIR}/tmp/passCfg"
    PERSISTENCE_DIR="${ACTIVE_CONFIG_DIR}"
    DHCP_LEASE_PATH="${ROOT_DIR}/var/log/dhclient.leases"
fi

IPSEC_CRL_PATH="${ROOT_DIR}/etc/ipsec.d/crls"
PRIVATE_IP=$(test_envInfo envInfoIpAddr | head -n 1 | sed -e '2,$ d;s/[^(0-9\.)*]//g')

if [ `isFsmr4` = 1 ]; then
    DEBUG_IP=$(/sbin/ifconfig eth0 | grep -w 'inet' | awk '{ print $2}')
else
    DEBUG_IP=$(/sbin/ifconfig eth1 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}')
fi

LOCKFILEDIR=${ROOT_DIR}/tmp/.`basename "$0"`.lock

mkdir -p $(dirname $LOCKFILEDIR)

if mkdir $LOCKFILEDIR > /dev/null 2>&1; then
    if [ "x${SERVER_SOFTWARE}" = "x" ]; then
        # script does not run under webserver
        SERVER_NAME="${PRIVATE_IP}"
        scriptstatus=0
    else
        # script runs under webserver
        scriptstatus=1
    fi

    # Recover is only allowed via following IPs
    is_allowed_ip=0
    allowed_ip[0]="192.168.255.129"
    allowed_ip[1]="192.168.255.1"
    allowed_ip[2]="192.168.255.16"
    allowed_ip[3]="192.168.255.245"
    allowed_ip[4]="192.168.255.241"
    allowed_ip[5]="192.168.255.242"
    allowed_ip[6]=$DEBUG_IP

    a=0
    while [ $a -lt 7 ]
    do
       if [ $SERVER_NAME = ${allowed_ip[a]} ] ; then
           is_allowed_ip=1
           break
       fi
       a=`expr $a + 1`
    done

    if [ $is_allowed_ip = 1 ] ; then
        header
        
        cat <<EOF
<h3>TRS Recover is initiated...</h3><P>
<h3>TRS will now reset and come up again with factory defaults</h3><P>
EOF

        if [ $scriptstatus = 1 ] ; then
            ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 110
        fi

        ukpt disable SEV_DEBUG >/dev/null 2>&1

        # default the sharedRP3Role CCS tag to "ETH"
        if test "$machine" = 'mips64'; then
            /opt/trs/bin/objcli SharedSFPRole ETH
        fi
		if [ "$PRODUCT" = "LTE_WMP" ] && ([ $unitIsFsmr3 -eq 1 ]  || [ $unitIsFsmr4 -eq 1 ]); then
			/opt/trs/bin/objcli IpTrafficCapacity IpTrafficBackup >/dev/null 2>&1
		fi
        # delete persist.db,cmp_params.xml, error and backup version
        if [ "WCDMA" = "$PRODUCT" ]; then
            rm -f "${PERSISTENCE_DIR}/persist.db" >/dev/null 2>&1
            rm -f "${PERSISTENCE_DIR}/persist.db.with_error2" >/dev/null 2>&1
            rm -f "${PERSISTENCE_DIR}/persist.bak" >/dev/null 2>&1
            rm -f "${PERSISTENCE_DIR}/fallback.db" >/dev/null 2>&1
            rm -f "${PERSISTENCE_DIR}/rollforward.db" >/dev/null 2>&1
        else
            /opt/trs/bin/llpd rm -f "${PERSISTENCE_DIR}/persist.db" >/dev/null 2>&1
            /opt/trs/bin/llpd rm -f "${PERSISTENCE_DIR}/persist.db.with_error2" >/dev/null 2>&1
            /opt/trs/bin/llpd rm -f "${PERSISTENCE_DIR}/persist.bak" >/dev/null 2>&1
            /opt/trs/bin/llpd rm -f "${PERSISTENCE_DIR}/fallback.db" >/dev/null 2>&1
            /opt/trs/bin/llpd rm -f "${PERSISTENCE_DIR}/rollforward.db" >/dev/null 2>&1
        fi

       if [ "WCDMA" = "$PRODUCT" ]; then
            rm -f "${ACTIVE_CONFIG_DIR}/keystorage/cmpdb/cmp_params.xml" >/dev/null 2>&1
	else
	    /opt/trs/bin/llpd rm -f "${ACTIVE_CONFIG_DIR}/keystorage/cmpdb/cmp_params.xml" >/dev/null 2>&1
        fi
        if [ "WCDMA" = "$PRODUCT" ]; then
          if [ -f ${DHCP_SFN_LEASE_PATH} ]; then
            rm -f "${DHCP_SFN_LEASE_PATH}" 2>&1
          fi
          rm -f "${DHCP_LEASE_PATH}" 2>&1 
        else
          if [ -f ${DHCP_SFN_LEASE_PATH} ]; then
            /opt/trs/bin/llpd rm -f "${DHCP_SFN_LEASE_PATH}" 2>&1
          fi
            /opt/trs/bin/llpd rm -f "${DHCP_LEASE_PATH}" 2>&1 
        fi
            rm -f "${ACTIVE_CONFIG_DIR}/oam_role" >/dev/null 2>&1

        if test "$machine" = 'armv5teb'; then
            /usr/local/bin/changeScenario -both -development >/dev/null 2>&1
        fi

        if test "$machine" = 'armv5teb'; then
            /usr/local/bin/changeScenario -both -customer >/dev/null 2>&1
        fi

        echo '<pre>'

        enforce_reboot

        echo '</pre>'

        footer

    else

        header 0 '403 Forbidden'

        cat <<EOF
<h3>TRS Recover request <font color="#FF0000">failed</font>...</h3>
<p>TRS accepts this request only if source is connected to LMP or debug (in development environment) interface</p>
EOF

        if [ $scriptstatus = 1 ] ; then
            ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 201
        fi

        footer
    fi

        rmdir $LOCKFILEDIR 2>&1

else
    header 0 '403 Conflict'
    
    cat <<EOF
<h3>TRS Recover request <font color="#FF0000">failed</font>...</h3>
<p>another recover request is active</p>
EOF
     if [ $scriptstatus = 1 ] ; then
        ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 201
     fi

    footer
fi
