#!/bin/sh

trap '' PIPE
trap '' HUP
trap '' INT
trap '' TERM

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

machine=`uname -m`

if [ "$machine" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi

if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

. ${FUNCTIONS}

LOCKFILEDIR=${ROOT_DIR}/tmp/.`basename "$0"`.lock

if mkdir $LOCKFILEDIR > /dev/null 2>&1; then

    if [ "x${SERVER_SOFTWARE}" != "x" ]; then
        # script runs under webserver
        ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 111 
    fi

    header

unitIsFzm=$(isFzm)
unitIsFzm=${unitIsFzm:-0}

if [ $unitIsFzm -eq 1 ]; then
cat <<EOF
<h3>FZM Reboot is initiated...</h3>
EOF
else
cat <<EOF
<h3>FTM Reboot is initiated...</h3>
EOF
fi

    echo '<pre>'

    enforce_reboot

    echo '</pre>'

    footer

    rmdir $LOCKFILEDIR 2>&1

else
    header 0 '403 Conflict'
    
if [ $unitIsFzm -eq 1 ]; then    
cat <<EOF
<h3>FZM Reboot request <font color="#FF0000">failed</font>...</h3>
<p>another reboot request is active</p>
EOF
else
cat <<EOF
<h3>FTM Reboot request <font color="#FF0000">failed</font>...</h3>
<p>another reboot request is active</p>
EOF
fi


    
    footer
fi
