#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions
if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
  variant='FSMR4'
  FSMR4_VARIANT_TYPE=`cat /proc/device-tree/board-identity/product-code | awk -F [.] '{print $2}'`
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

#assigning token variables

if [[ -z $1 || -z $2 || -z $3 ]]; then
  TIMESTAMP="########"
  TOKEN="********"
  FILENAME="$%$%$%$%"
else
  TIMESTAMP=$1
  TOKEN=$2
  FILENAME=$3
fi


#Input variables

CAPTURE_POINT='2'
USER_PLANE='1'
OUTPUT_OPTION='1'
STRM_OPTION='0'
DST_MAC=''
UNIT_TYPE='0'
SERVER_STATUS='0'
VALUE=`cat /tmp/ignore_ftif_tmp_flag.txt`
#UNIT=$(getUnit)

if [ -f /opt/trs/bin/vtc ]
then
  UNIT=`/opt/trs/bin/test_envInfo envInfoUnitType | grep UNIT`
else
UNIT=`/opt/trs/bin/test_envInfo -a|sed -e '/Unit/ !d;s/.*UNIT_//;s/)$//'`
UNIT_FZM=`echo $UNIT | grep Unit`
fi

if [ "$UNIT_FZM" ] ; then
###  UNIT=`/opt/trs/bin/test_envInfo -a| sed -e '/Unit/ !d;s/.*://;s/)$//'`
  UNIT="FZM"
fi

if [ $UNIT == "FCTA" ]; then 
  if [ $VALUE == 0 ]; then
    UNIT_TYPE='2'
  else
    UNIT_TYPE='1'
  fi
fi

if [ $UNIT == "FCTF" ]; then
UNIT_TYPE='3'
fi

### if [ $UNIT == "FWGH" ]; then
if [ $UNIT == "FZM" ]; then
UNIT_TYPE='4'
fi

if [ $UNIT == "UNIT_FCTJ" ]; then
  if [ $FSMR4_VARIANT_TYPE == "X31" ]; then
    UNIT_TYPE='5'
  else
    UNIT_TYPE='6'
  fi      
fi

if [ -f "/tmp/portMirrorringConfTmpFile" ]; then

CAPTURE_POINT=`cat /tmp/portMirrorringConfTmpFile | grep CAPTURE_POINT`
CAPTURE_POINT=${CAPTURE_POINT/CAPTURE_POINT /}

USER_PLANE=`cat /tmp/portMirrorringConfTmpFile | grep USER_PLANE`
USER_PLANE=${USER_PLANE/USER_PLANE /}

OUTPUT_OPTION=`cat /tmp/portMirrorringConfTmpFile | grep OUTPUT_OPTION`
OUTPUT_OPTION=${OUTPUT_OPTION/OUTPUT_OPTION /}

STRM_OPTION=`cat /tmp/portMirrorringConfTmpFile | grep STRM_OPTION`
STRM_OPTION=${STRM_OPTION/STRM_OPTION /}

  if [ $variant == FSMR4 ]; then
    if [ $FSMR4_VARIANT_TYPE == "X31" ]; then
        touch /tmp/sooru
      if [ $STRM_OPTION == 20 ]; then
        STRM_OPTION=0
      elif [ $STRM_OPTION == 0 ]; then
        STRM_OPTION=1
      elif [ $STRM_OPTION == 16 ]; then
        STRM_OPTION=2
      elif [ $STRM_OPTION == 17 ]; then
        STRM_OPTION=3
      elif [ $STRM_OPTION == 18 ]; then
        STRM_OPTION=4
      elif [ $STRM_OPTION == 19 ]; then
        STRM_OPTION=5
      fi
    else
      if [ $STRM_OPTION == 20 ]; then
        STRM_OPTION=0
      elif [ $STRM_OPTION == 0 ]; then
        STRM_OPTION=1
      elif [ $STRM_OPTION == 16 ]; then
        STRM_OPTION=2
      elif [ $STRM_OPTION == 1 ]; then
        STRM_OPTION=3
      elif [ $STRM_OPTION == 2 ]; then
        STRM_OPTION=4
      elif [ $STRM_OPTION == 17 ]; then
        STRM_OPTION=5
      elif [ $STRM_OPTION == 18 ]; then
        STRM_OPTION=6
      elif [ $STRM_OPTION == 19 ]; then
        STRM_OPTION=7
      fi
    fi
  fi

DST_MAC=`cat /tmp/portMirrorringConfTmpFile | grep DST_MAC`
DST_MAC=${DST_MAC/DST_MAC /}

replace=":"
DST_MAC=${DST_MAC/\%3A/$replace}
DST_MAC=${DST_MAC/\%3A/$replace}
DST_MAC=${DST_MAC/\%3A/$replace}
DST_MAC=${DST_MAC/\%3A/$replace}
DST_MAC=${DST_MAC/\%3A/$replace}

fi

BUFFER=$(echo $QUERY_STRING | tr '&' ' ' | tr '=' ' ')

serverStatus=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
serverStatus=${serverStatus/"PORT MIRRORRING STATUS "/""}
      

HIDDEN_STATE_FIELD_VAL=SERVER_CAPTURING_STOP   
if [ $serverStatus == "TRAFFIC_CAPTURE_START" ]; then
   SERVER_STATUS=1
 HIDDEN_STATE_FIELD_VAL=SERVER_CAPTURING_ON
elif [ $serverStatus == "TRAFFIC_CAPTURE_GEN_PCAP_START" ]; then
   SERVER_STATUS=2
  HIDDEN_STATE_FIELD_VAL=SERVER_FILE_GEN_ON
fi

web_page()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<head>
   <META HTTP-EQUIV="Cache-control" CONTENT="no-store">
   <META HTTP-EQUIV="Pragma" CONTENT="no-cache">
   <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
   <meta http-equiv="refresh" content="540">
<script>
function onLoad()
{
  if('4'== $UNIT_TYPE)
  {
      document.getElementById("CaptureB").hidden=true;
  }
  if($CAPTURE_POINT == 1)
  {
     document.getElementById("cp1").checked = true;
     onSelectAorB();
  }
  else if($CAPTURE_POINT == 2)
  { 
     document.getElementById("cp2").checked = true;
     onSelectAorB();
  }
  else
  {
     document.getElementById("cp3").checked = true;
     onSelectAprime();
  }
  if($USER_PLANE == 1)  
  {
     document.getElementById("up1").checked = true;
  }
  else
  {
     document.getElementById("up2").checked = true;
  }          
  if($OUTPUT_OPTION == 1)
  {
     document.getElementById("optionFile").checked = true;
     onSelectFile();
  }
  else
  {
     document.getElementById("optionStream").checked = true;
     onSelectStreaming();
     document.getElementById("Port").value=$STRM_OPTION;
     var macaddr="$DST_MAC";
     document.getElementById("macaddr").value=macaddr;
  }
  if($SERVER_STATUS == '1')
  {
    document.getElementById("strt").disabled = true;
    document.getElementById("stp").disabled = false;
  }
  else if ($SERVER_STATUS == '2')
  {
    document.getElementById("strt").disabled = true;
    document.getElementById("stp").disabled = true;
  }  
  else
  {
    document.getElementById("strt").disabled = false;
    document.getElementById("stp").disabled = true;
  }

 if($UNIT_TYPE == '1')
  {
     var select = document.getElementById("Port");
     var options = ["LMP", "FSM-EIF1", "FSM-EIF2"];
     for (var i = 0; i < options.length; i++) {
       var opt = options[i];
       var el = document.createElement("option");
       el.Text = opt;
       el.value = i;
       el.innerHTML = opt;
       select.appendChild(el);
     }
  }
  else if($UNIT_TYPE == '2')
  {
    var select = document.getElementById("Port");
    var options = ["LMP", "FSM-EIF1", "FSM-EIF2", "FTIF-EIF1", "FTIF-EIF2", "FTIF-EIF3", "FTIF-EIF4"];
    for (var i = 0; i < options.length; i++) {
       var opt = options[i];
       var el = document.createElement("option");
       el.Text = opt;
       el.value = i;
       el.innerHTML = opt;
       select.appendChild(el);
    } 
 }
 else if($UNIT_TYPE == '3')
 {
    var select = document.getElementById("Port");
    var options = ["LMP", "FSI-EIF1", "FSI-EIF2", "FSI-EIF3", "FSI-EIF4", "FSI-EIF5"];
    for (var i = 0; i < options.length; i++) {
       var opt = options[i];
       var el = document.createElement("option");
       el.Text = opt;
       if (i == 0)
       {
          el.value = i;
       }
       else
       {
          el.value = i+6;
       }
       el.innerHTML = opt;
       select.appendChild(el);
    }
 } 
 else if($UNIT_TYPE == '4')
 {
    var select = document.getElementById("Port");
    var options = ["LMP", "BH"];
    for (var i = 0; i < options.length; i++) {
      var opt = options[i];
      var el = document.createElement("option");
      el.Text = opt;
      el.value = i;
      el.innerHTML = opt;
      select.appendChild(el);
    }
 }
 else if($UNIT_TYPE == "5")
 {
    var select = document.getElementById("Port");
    var options = ["AIRSCALE-LMP", "AIRSCALE-EIF1", "AIRSCALE-EIF2", "AIRSCALE-EIF3", "AIRSCALE-EIF4", "AIRSCALE-EIF5"];
    for (var i = 0; i < options.length; i++) {
      var opt = options[i];
      var el = document.createElement("option");
      el.Text = opt;
      el.value = i;
      el.innerHTML = opt;
      select.appendChild(el);
    }
 }
 else if($UNIT_TYPE == "6")
 {
    var select = document.getElementById("Port");
    var options = ["AIRSCALE-LMP", "AIRSCALE-EIF1", "AIRSCALE-EIF2", "AIRSCALE-EIF3", "AIRSCALE-EIF4", "AIRSCALE-EIF5", "AIRSCALE-EIF6", "AIRSCALE-EIF7"];
    for (var i = 0; i < options.length; i++) {
      var opt = options[i];
      var el = document.createElement("option");
      el.Text = opt;
      el.value = i;
      el.innerHTML = opt;
      select.appendChild(el);
    }
 }
 else
 {
   alert("UNIT Not supported")
 }

 if($UNIT_TYPE == '3' && $STRM_OPTION != 0)
 {
   document.getElementById('Port').getElementsByTagName('option')[$STRM_OPTION -6].selected = 'selected';
 }
 else
 {
   document.getElementById('Port').getElementsByTagName('option')[$STRM_OPTION].selected = 'selected';
 }
 document.getElementById("stamp1").value = "$TIMESTAMP";
 document.getElementById("stamp2").value = "$TIMESTAMP";
 document.getElementById("token1").value = "$TOKEN";
 document.getElementById("token2").value = "$TOKEN";
 document.getElementById("frame1").value = "$FILENAME";
 document.getElementById("frame2").value = "$FILENAME";
}
</script>   
   
</head>
<body onload="onLoad()" bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3><FONT face="Arial, Helvetica, sans-serif">
  <font color="#000000">Local and Remote IP Traffic Capturing</FONT></h3>
EOF
cat <<EOF
   <img src="../images/portMirrorringCapPoints.gif" width="550" height"200" align="right">
EOF
cat <<EOF
   <form id="frm1" name="form1" target="Ausgabe" onsubmit="return startCaptureInput(DstMacAddress)">
   <FONT face="Arial, Helvetica, sans-serif"></FONT>
   Capture Point(Default:A):<br>
   <div id="CaptureB"><input name="CapturePoint" type="radio" id="cp1" value="1" onClick="onSelectAorB();">B: Capture IP traffic to/from the BTS and SSE, at the transport network interfaces<br>
   </div>
   <input name="CapturePoint" type="radio" id="cp2" value="2" onClick="onSelectAorB();">A: Capture IP traffic to/from the BTS and SSE<br>
   <BR>Uplane capture(Default:Enable):
   <input name="UserPlane" type="radio" id="up2" value="0" >Disable
   <input name="UserPlane" type="radio" id="up1" value="1" >Enable<BR>
   <BR>Capture Output Option(Default:File):
   <input name="CaptureOption" id="optionFile" type="radio" value="1" onClick="onSelectFile();">File
   <input name="CaptureOption" id="optionStream" type="radio" value="2" onClick="onSelectStreaming();">Streaming<br>
   <BR>Streaming Option:
   <select name="streamOption" id="Port">
   </select>
   <input type="text" id="macaddr" name="DstMacAddress" SIZE="18" maxlength="17" required>Destination MAC Addr<BR><BR>
   <input type="SUBMIT" VALUE="START" id="strt" onclick="document.pressed=this.value" >
   <input type="SUBMIT" VALUE="STOP" id="stp" onclick="document.pressed=this.value">
   <input type=hidden id="stamp1" name=stamp value="$TIMESTAMP">
   <input type=hidden id="token1" name=token value="$TOKEN">
   <input type=hidden id="frame1" name=frame value="$FILENAME">
   </form></A><BR>

   <form method="post" id="frm2" name="form2" target="Ausgabe" onsubmit="return genPcapInput(Password)">
   <FONT face="Arial, Helvetica, sans-serif"></FONT>
   <BR>Capture File Option: 
   <input NAME="Password" id="Password" SIZE="20" type="password" maxlength="40" autocomplete="off" >Password<BR><BR>
   <input type="SUBMIT" VALUE="GEN&DOWNLOAD_PCAP" id="getfile" onclick="document.pressed=this.value">
   <input type="SUBMIT" VALUE="ABRT_GEN&DOWNLOAD_PCAP" id="abrtfile" onclick="document.pressed=this.value">
   <input type=hidden id="stamp2" name=stamp value="$TIMESTAMP">
   <input type=hidden id="token2" name=token value="$TOKEN">
   <input type=hidden id="frame2" name=frame value="$FILENAME">
   </form></A>

   <form id="ServerState" name="ServerState">
      <input type="hidden" name="state" value="$HIDDEN_STATE_FIELD_VAL"></input>
   </form> 

   <script>

   function onSelectAprime()
   {
     document.getElementById("optionFile").checked=true;
     document.getElementById("optionStream").disabled=true;
     onSelectFile()
   }

     function onSelectAorB()
     {
         document.getElementById("optionStream").disabled=false;
         if('4' == $UNIT_TYPE)
             {
                 document.getElementById("cp1").disabled=true;
             }
     }

     function onSelectFile()
     {
         document.getElementById("Password").disabled=false;
         document.getElementById("Port").disabled=true;
         document.getElementById("macaddr").disabled=true;
         document.getElementById("getfile").disabled=false;
         document.getElementById("abrtfile").disabled=false;
     }

     function onSelectStreaming()
     {
         document.getElementById("Password").disabled=true;
         document.getElementById("Port").disabled=false;
         document.getElementById("macaddr").disabled=false;
         document.getElementById("getfile").disabled=true;
         document.getElementById("abrtfile").disabled=true;
     }

   function stringlength(inputtxt, minlength, maxlength)
   {
     var field = inputtxt.value; 
     var mnlen = minlength;
     var mxlen = maxlength;
     if(field.length < mnlen || field.length >  mxlen)
     { 
       return false;
     }
     else
     { 
       return true;
     }
   }
   function genPcapInput(passwd)
   {
     var elemvalue = passwd.value;
     elemvalue = elemvalue.toString();
      
     if((elemvalue.indexOf(" ") != -1) || (elemvalue.indexOf(":") != -1) || (elemvalue.indexOf("<") != -1) || (elemvalue.indexOf(">") != -1) || 
        (elemvalue.indexOf("{") != -1) || (elemvalue.indexOf("}") != -1) || (elemvalue.indexOf("\"") != -1) || (elemvalue.indexOf("^") != -1) || 
        (elemvalue.indexOf("\`") != -1) || (elemvalue.indexOf("\\\") != -1) || (elemvalue.indexOf("|") != -1)) 
     {
        alert("Invalid password format! Unsupported characters [space,':','<','>','{','}','\"','^','\`','\\\','|']");
        return false;
     }
     
     if(stringlength(passwd, 8, 40) == false)
     {
        if(passwd.value.length != 0 && document.getElementById("optionFile").checked==true)
        {
           alert("\nWarning password is invalid..PCAP file will not be generated..!!!\n\n\n1.Password should be of minimum 8 characters.\n\n2.Unsupported Characters [space, \<, \{, \:, \>, \", \\, \|, \^, \}, \`]")	
       	   return false;
        } 
     }
      
     if(document.pressed == 'GEN&DOWNLOAD_PCAP')
     {
        document.getElementById("stp").disabled = true;
        document.getElementById("getfile").disabled = true;
        //check if the traffic is running on the server
        if ( document.getElementById("ServerState")[0].value == "SERVER_CAPTURING_ON")
        { 
           //Set the client side state
           document.getElementById("ServerState")[0].value = "SERVER_FILE_GEN_ON";
           document.form2.action = "getPortMirrorringFile.cgi";
        } 
        else
        {
            //TODO 
           if ( document.getElementById("ServerState")[0].value == "SERVER_FILE_GEN_ON")
           {
              alert("Invalid Operation ! : File Generation And Download already Ongoing");
              document.getElementById("getfile").disabled = false;
              return false;
	       }
           else
           {
              document.getElementById("ServerState")[0].value = "SERVER_FILE_GEN_ON";
              document.form2.action = "getPortMirrorringFile.cgi";
              return true ;
	       }
        } 
     }
     else if(document.pressed == 'ABRT_GEN&DOWNLOAD_PCAP')
     {
        document.getElementById("strt").disabled = false;
        document.getElementById("getfile").disabled = false;
       //check if the traffic is running on the server
        if ( document.getElementById("ServerState")[0].value == "SERVER_FILE_GEN_ON")
        {
          //Set the client side state
           document.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
           document.form2.action = "abortPortMirrorringPcap.cgi";
        } 
        else
        {
            //TODO 
	    if ( document.getElementById("ServerState")[0].value == "SERVER_CAPTURING_ON")
	    {
		document.getElementById("strt").disabled = true;
	    }
            alert("Invalid Operation in this state!"); 
            return false;
        } 
       
     } 
   }

   function startCaptureInput(macaddr)
   {
     var elemvalue = macaddr.value;
     elemvalue = elemvalue.toString();

     regex=/^([0-9a-f]{2}([:-]|$)){6}$/i;
     if (document.getElementById("optionFile").checked!=true && !regex.test(elemvalue)){
         alert("Please enter the MAC address either in the form of AA-BB-CC-DD-EE-FF or AA:BB:CC:DD:EE:FF");
         return false;
     }

     if(stringlength(macaddr, 17, 17) == false)
     {
       if(document.getElementById("optionFile").checked==false)
       {
           alert("Please enter the MAC address either in the form of AA-BB-CC-DD-EE-FF or AA:BB:CC:DD:EE:FF");
           return false;
       }
     }

     if(document.pressed == 'START')
     {
       if ( document.getElementById("ServerState")[0].value == "SERVER_CAPTURING_STOP")
       {
           document.getElementById("strt").disabled = true;
           document.getElementById("stp").disabled = false;
          //Set the client side state
           document.getElementById("ServerState")[0].value = "SERVER_CAPTURING_ON";
           document.form1.action = "startPortMirrorring.cgi";
       }
       else
       {
            //TODO
	    if ( document.getElementById("ServerState")[0].value == "SERVER_FILE_GEN_ON")
	    {
		alert("Pcap File Generation Is already in progress. So Ignoring this Action!!!");
		return false;
	    } 
	    else
	    {
		alert("Invalid Operation in this state!"); 
            	return false; 
	    }
       } 
     }
     else if(document.pressed == 'STOP')
     {
       if ( document.getElementById("ServerState")[0].value == "SERVER_CAPTURING_ON")
       {  
           document.getElementById("strt").disabled = false;
           document.getElementById("stp").disabled = true;          
//Set the client side state
           document.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
          document.form1.action = "stopPortMirrorring.cgi";
       } 
       else
       {
            //TODO 
            alert("Invalid Operation in this state!"); 
            return false; 
       } 
     }
     return true;
   } 
   </script>  
       
   </body>
</html>
EOF
}
server_response
web_page

